/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.export;

import at.mrdevelopment.esl.custom.export.Level2Importer;
import at.mrdevelopment.esl.custom.level3.Level3Interface;
import at.mrdevelopment.esl.server.data.GenericZipEntry;
import at.mrdevelopment.esl.type.wrapper.element.ESLArticle;
import at.mrdevelopment.esl.type.wrapper.element.ESLMessage;
import at.mrdevelopment.esl.type.wrapper.list.ESLArticleList;
import java.util.Collection;

public class Level3Importer
extends Level2Importer {
    private final Level3Interface eslInterface;

    public Level3Importer(Level3Interface eslInterface) {
        super(eslInterface.getLevel2Interface());
        this.eslInterface = eslInterface;
    }

    public ESLMessage importArticles(boolean clear, ESLArticleList list) throws Exception {
        if (clear) {
            this.eslInterface.removeAllArticles();
        }
        for (ESLArticle article : list.List) {
            this.eslInterface.storeArticle(article.toArticle(), 0L);
        }
        return new ESLMessage("%d records imported", list.List.size());
    }

    @Override
    public void importEntries(boolean clear, Collection<GenericZipEntry<?>> entries) throws Exception {
        super.importEntries(clear, entries);
        for (GenericZipEntry<?> entry : entries) {
            if (!entry.getRecordClass().equals(ESLArticleList.class)) continue;
            this.importArticles(clear, (ESLArticleList)entry.getRecord());
        }
    }
}

