/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.export;

import at.mrdevelopment.esl.custom.export.Level1Importer;
import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.server.data.GenericZipEntry;
import at.mrdevelopment.esl.type.wrapper.element.ESLMessage;
import at.mrdevelopment.esl.type.wrapper.list.ESLMatchingList;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.Collection;

public class Level2Importer
extends Level1Importer {
    private final Level2Interface eslInterface;

    public Level2Importer(Level2Interface eslInterface) {
        super(eslInterface.getLevel1Interface());
        this.eslInterface = eslInterface;
    }

    public ESLMessage importMatchings(boolean clear, ESLMatchingList list) throws SerializeException, Exception {
        if (clear) {
            this.eslInterface.removeAllMatchings();
        }
        this.eslInterface.modifyMatchings(list.toMatchings(), 0L);
        return new ESLMessage("%d records imported", list.List.size());
    }

    @Override
    public void importEntries(boolean clear, Collection<GenericZipEntry<?>> entries) throws Exception {
        super.importEntries(clear, entries);
        for (GenericZipEntry<?> entry : entries) {
            if (!entry.getRecordClass().equals(ESLMatchingList.class)) continue;
            this.importMatchings(clear, (ESLMatchingList)entry.getRecord());
        }
    }
}

