/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.export;

import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetRecordNotFoundException;
import at.mrdevelopment.esl.persistence.record.User;
import at.mrdevelopment.esl.server.data.GenericImport;
import at.mrdevelopment.esl.server.data.GenericZipEntry;
import at.mrdevelopment.esl.type.wrapper.element.ESLAccessPointRegistration;
import at.mrdevelopment.esl.type.wrapper.element.ESLConfiguration;
import at.mrdevelopment.esl.type.wrapper.element.ESLLicense;
import at.mrdevelopment.esl.type.wrapper.element.ESLMessage;
import at.mrdevelopment.esl.type.wrapper.list.ESLAccessPointRegistrationList;
import at.mrdevelopment.esl.type.wrapper.list.ESLConfigurationList;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelList;
import at.mrdevelopment.esl.type.wrapper.list.ESLLicenseList;
import at.mrdevelopment.esl.type.wrapper.list.ESLUserList;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.List;

public class Level1Importer
extends GenericImport {
    static ESLLogger logger = ESLLogger.getLogger(Level1Importer.class);
    private final Level1Interface eslInterface;

    public Level1Importer(Level1Interface eslInterface) {
        this.eslInterface = eslInterface;
    }

    public ESLMessage importLicenses(boolean clear, ESLLicenseList list) throws DatasetException {
        if (clear) {
            this.eslInterface.removeAllLicenses();
        }
        for (ESLLicense license : list.List) {
            this.eslInterface.addLicense(license.toLicence());
        }
        return new ESLMessage("%d records imported", list.List.size());
    }

    public ESLMessage importLabels(boolean clear, ESLLabelList list) throws DatasetException, SerializeException {
        if (clear) {
            this.eslInterface.removeAllLabels();
        }
        this.eslInterface.registerLabels(list.toLabelRegistrations(), 0L);
        return new ESLMessage("%d records imported", list.List.size());
    }

    public ESLMessage importAccessPoints(boolean clear, ESLAccessPointRegistrationList list) throws DatasetException, MalformedURLException {
        if (clear) {
            this.eslInterface.removeAllAccessPoints();
        }
        for (ESLAccessPointRegistration accessPointRegistration : list.List) {
            this.eslInterface.registerAccessPoint(accessPointRegistration.toAccessPointRegistration());
        }
        return new ESLMessage("%d records imported", list.List.size());
    }

    public ESLMessage importConfigurationKeys(boolean clear, ESLConfigurationList list) throws DatasetException {
        if (clear) {
            this.eslInterface.restoreDefaultConfiguration();
        }
        int importCount = 0;
        for (ESLConfiguration configuration : list.List) {
            try {
                this.eslInterface.updateConfiguration(configuration.Key, configuration.Value);
                ++importCount;
            }
            catch (DatasetRecordNotFoundException exc) {
                logger.warn("Configuration key %s not found (check version compatibility/plugin installation");
                logger.logException((Throwable)exc);
            }
        }
        return new ESLMessage("%d records imported", importCount);
    }

    public ESLMessage importUsers(boolean clear, ESLUserList list) throws DatasetException, SerializeException {
        List<User> users = list.toUsers();
        this.eslInterface.importUsers(users, clear);
        return new ESLMessage("%d records imported", list.List.size());
    }

    public void importEntries(boolean clear, Collection<GenericZipEntry<?>> entries) throws Exception {
        for (GenericZipEntry<?> entry : entries) {
            if (entry.getRecordClass().equals(ESLLicenseList.class)) {
                this.importLicenses(clear, (ESLLicenseList)entry.getRecord());
                continue;
            }
            if (entry.getRecordClass().equals(ESLConfigurationList.class)) {
                this.importConfigurationKeys(clear, (ESLConfigurationList)entry.getRecord());
                continue;
            }
            if (!entry.getRecordClass().equals(ESLUserList.class)) continue;
            this.importUsers(clear, (ESLUserList)entry.getRecord());
        }
        for (GenericZipEntry<?> entry : entries) {
            if (entry.getRecordClass().equals(ESLLabelList.class)) {
                this.importLabels(clear, (ESLLabelList)entry.getRecord());
                continue;
            }
            if (!entry.getRecordClass().equals(ESLAccessPointRegistrationList.class)) continue;
            this.importAccessPoints(clear, (ESLAccessPointRegistrationList)entry.getRecord());
        }
    }
}

