/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.export;

import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.AccessPointConfiguration;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.persistence.record.LicenceRecord;
import at.mrdevelopment.esl.persistence.record.User;
import at.mrdevelopment.esl.server.data.DataExporter;
import at.mrdevelopment.esl.server.data.ESLDatabaseId;
import at.mrdevelopment.esl.server.data.ESLDatabaseIdList;
import at.mrdevelopment.esl.server.data.GenericExport;
import at.mrdevelopment.esl.server.data.GenericZipEntry;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLAccessPointRegistration;
import at.mrdevelopment.esl.type.wrapper.element.ESLConfiguration;
import at.mrdevelopment.esl.type.wrapper.element.ESLLabel;
import at.mrdevelopment.esl.type.wrapper.element.ESLLicense;
import at.mrdevelopment.esl.type.wrapper.element.ESLUser;
import at.mrdevelopment.esl.type.wrapper.list.ESLAccessPointRegistrationList;
import at.mrdevelopment.esl.type.wrapper.list.ESLConfigurationList;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelList;
import at.mrdevelopment.esl.type.wrapper.list.ESLLicenseList;
import at.mrdevelopment.esl.type.wrapper.list.ESLUserList;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.authentication.UserId;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Level1Exporter
extends GenericExport
implements DataExporter {
    private final Level1Interface eslInterface;

    public Level1Exporter(Level1Interface eslInterface) {
        this.eslInterface = eslInterface;
    }

    public ESLLicenseList exportLicenses() throws MappingException, DatasetException {
        DatasetQuery query = this.eslInterface.getQuery("licencerecord/index");
        QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedQuery());
        return ESLWrapper.wrap(queryResult.getRecords(), LicenceRecord.class, ESLLicense.class, ESLLicenseList.class);
    }

    public ESLLabelList exportLabels() throws DatasetException, MappingException {
        return ESLWrapper.wrap(this.eslInterface.getRegisteredLabels(), LabelRegistration.class, ESLLabel.class, ESLLabelList.class);
    }

    public ESLAccessPointRegistrationList exportAccessPoints() throws DatasetException, MappingException {
        DatasetQuery query = this.eslInterface.getQuery("accesspointconfiguration/index");
        QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedQuery());
        return ESLWrapper.wrap(queryResult.getRecords(), AccessPointConfiguration.class, ESLAccessPointRegistration.class, ESLAccessPointRegistrationList.class);
    }

    public ESLConfigurationList exportConfigurationKeys() throws DatasetException, MappingException {
        DatasetQuery query = this.eslInterface.getQuery("configuration/index");
        QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedQuery());
        List modifiedConfigurations = Configuration.filterModified((Iterable)queryResult.getRecords());
        return ESLWrapper.wrap(modifiedConfigurations, Configuration.class, ESLConfiguration.class, ESLConfigurationList.class);
    }

    public ESLUserList exportUsers() throws DatasetException, MappingException {
        DatasetQuery query = this.eslInterface.getQuery("user/index");
        QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedQuery());
        return ESLWrapper.wrap(queryResult.getRecords(), User.class, ESLUser.class, ESLUserList.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportData(File file) throws Exception {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            this.exportData(outputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.close(outputStream);
            throw throwable;
        }
        StreamUtils.close((OutputStream)outputStream);
    }

    public Collection<GenericZipEntry<?>> createEntries() throws Exception {
        ArrayList entries = new ArrayList();
        ESLLicenseList licenses = this.exportLicenses();
        ESLLabelList labels = this.exportLabels();
        ESLAccessPointRegistrationList accessPoints = this.exportAccessPoints();
        ESLConfigurationList configurationKeys = this.exportConfigurationKeys();
        ESLUserList users = this.exportUsers();
        entries.add(new GenericZipEntry(ESLLicenseList.class, (Object)licenses));
        entries.add(new GenericZipEntry(ESLLabelList.class, (Object)labels));
        entries.add(new GenericZipEntry(ESLAccessPointRegistrationList.class, (Object)accessPoints));
        entries.add(new GenericZipEntry(ESLConfigurationList.class, (Object)configurationKeys));
        entries.add(new GenericZipEntry(ESLUserList.class, (Object)users));
        entries.add(new GenericZipEntry(ESLDatabaseIdList.class, (Object)this.exportDatabaseId()));
        return entries;
    }

    private ESLDatabaseIdList exportDatabaseId() {
        ESLDatabaseIdList list = new ESLDatabaseIdList();
        list.List = Lists.newArrayList((Object[])new ESLDatabaseId[]{ESLDatabaseId.wrap((String)this.eslInterface.getServiceStatus(UserId.SYSTEM).getPropertyValue("database-id"))});
        return list;
    }
}

