/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom;

import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.custom.level1.Level1Connector;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.gui.ESLFrame;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.TemplateValuesTask;
import at.mrdevelopment.esl.template.FileTemplateSource;
import at.mrdevelopment.esl.template.TemplateSource;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.type.UpdateResult;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Range;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;

public class TaskGeneratorTest
implements Level1Connector {
    static ESLLogger logger = ESLLogger.getLogger(TaskGeneratorTest.class);
    private static final Range<Address> LABEL_ADDRESSES_1 = new Range((Comparable)Address.fromString((String)"A100000A"), (Comparable)Address.fromString((String)"A10000C8"));
    private static final Range<Address> LABEL_ADDRESSES_2 = new Range((Comparable)Address.fromString((String)"B2000324"), (Comparable)Address.fromString((String)"B200070F"));
    private static final File TEMPLATE_FILE = new File("data/template", "template-clock.xsl");
    private static final Set<Address> EXCLUDE_ADDRESSES = new HashSet<Address>();
    private Level1Interface eslInterface;
    private Map<LabelId, Entry> entries = new HashMap<LabelId, Entry>();
    private boolean enabled = false;

    public TaskGeneratorTest(Level1Interface eslInterface) throws InitializationException, SerializeException {
        LabelId labelId;
        GUIUtils.setSystemLookAndFeel();
        this.eslInterface = eslInterface;
        ESLFrame frame = new ESLFrame();
        frame.setResizable(false);
        frame.setTitle("Task import");
        frame.setLayout(new FlowLayout());
        final JButton enableButton = new JButton("Enable");
        final JButton disableButton = new JButton("Disable");
        enableButton.setEnabled(!this.enabled);
        enableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TaskGeneratorTest.this.enabled = true;
                enableButton.setEnabled(false);
                disableButton.setEnabled(true);
            }
        });
        disableButton.setEnabled(this.enabled);
        disableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TaskGeneratorTest.this.enabled = false;
                enableButton.setEnabled(true);
                disableButton.setEnabled(false);
            }
        });
        frame.add(enableButton);
        frame.add(disableButton);
        frame.pack();
        frame.setVisible(true);
        for (Address labelAddress : LABEL_ADDRESSES_1) {
            if (EXCLUDE_ADDRESSES.contains(labelAddress)) continue;
            labelId = new LabelId(labelAddress);
            this.entries.put(labelId, new Entry(labelId));
        }
        for (Address labelAddress : LABEL_ADDRESSES_2) {
            if (EXCLUDE_ADDRESSES.contains(labelAddress)) continue;
            labelId = new LabelId(labelAddress);
            this.entries.put(labelId, new Entry(labelId));
        }
    }

    public void importTasks() throws Exception {
        LinkedList<Task> tasks = new LinkedList<Task>();
        if (this.enabled) {
            for (Entry entry : this.entries.values()) {
                LabelId labelId = entry.labelId;
                Task task = entry.task;
                int externalId = entry.successfulCount + 1;
                if (task != null) continue;
                task = this.createNewTask(labelId, externalId);
                tasks.add(task);
                entry.task = task;
            }
        }
        TaskOrder taskOrder = new TaskOrder("Task import", 0L, tasks);
        this.eslInterface.addTasks(taskOrder);
    }

    public void notifyUpdateFinished(UpdateResult updateResult) {
        Entry entry = this.entries.get(updateResult.getLabelId());
        if (entry != null && entry.task != null && entry.task.hasExternalId() && entry.task.getExternalId() == updateResult.getExternalId()) {
            System.out.println(String.format("%3d: %s", updateResult.getExternalId(), updateResult.getStatus().toString()));
            this.handleFinishedUpdate(updateResult, entry);
            entry.task = null;
            this.printStatistics(entry);
        }
    }

    private Task createNewTask(LabelId labelId, long externalId) throws SerializeException {
        return new TemplateValuesTask(labelId, TaskPriority.NORMAL, externalId, false, (TemplateSource)new FileTemplateSource(TEMPLATE_FILE), new HashMap(), Page.PAGE_0, false);
    }

    private void handleFinishedUpdate(UpdateResult updateResult, Entry entry) {
        if (updateResult.getStatus().isSuccessful()) {
            entry.successfulCount++;
        } else if (updateResult.getStatus().isUnsuccessful()) {
            entry.failedCount++;
        }
    }

    private void printStatistics(Entry entry) {
        if ((entry.successfulCount + entry.failedCount) % 10 == 0) {
            logger.info("%s: %d successful update(s), %d failed update(s)", new Object[]{entry.labelId, entry.successfulCount, entry.failedCount});
        }
    }

    public void cleanup(int daysToKeep) {
    }

    public void run() {
        try {
            this.importTasks();
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
        }
    }

    public void shutdown() {
    }

    public void notifyLabelStatusChanged() {
    }

    public void notifyLabelEvent(LabelEvent labelEvent) {
    }

    public void notifyEslProblem() {
    }

    static {
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B200033B"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B2000346"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B2000354"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B2000355"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B200035E"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B200036E"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B2000375"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B2000399"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B20003E9"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B200043C"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B2000498"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B20004E6"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B2000509"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B200050A"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B200050B"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B200050C"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B200050D"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B200050E"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B200050F"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B200056C"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B20005E6"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B2000633"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B2000662"));
        EXCLUDE_ADDRESSES.add(Address.fromString((String)"B20006CC"));
    }

    private static class Entry {
        private final LabelId labelId;
        private Task task;
        private int successfulCount = 0;
        private int failedCount = 0;

        public Entry(LabelId labelId) {
            this.labelId = labelId;
        }
    }
}

