/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom;

import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.custom.level1.Level1Connector;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.gui.ESLFrame;
import at.mrdevelopment.esl.gui.userinfo.UserInfoView;
import at.mrdevelopment.esl.type.UpdateResult;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.joda.time.format.DateTimeFormat;

public class ServiceDebugWindow
implements Level1Connector {
    static ESLLogger logger = ESLLogger.getLogger(ServiceDebugWindow.class);
    private JFrame frame;
    private final UserInfoView userInfo;
    private final Level1Interface level1;

    public ServiceDebugWindow(Level1Interface level1) {
        this.level1 = level1;
        if (GraphicsEnvironment.isHeadless()) {
            this.userInfo = null;
            this.frame = null;
        } else {
            GUIUtils.setSystemLookAndFeel();
            this.userInfo = new UserInfoView(DateTimeFormat.forStyle((String)"MM"));
            this.frame = new ESLFrame(ESLFrame.ESL_ICONS_BLACK);
            try {
                this.showFrame();
            }
            catch (Exception exc) {
                logger.logException((Throwable)exc);
            }
        }
    }

    private void showFrame() {
        this.frame.setLayout(new BorderLayout());
        this.frame.setTitle(this.getTitleText());
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ServiceDebugWindow.this.close();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu menuAccessPoint = new JMenu("Service");
        JMenuItem shutdownItem = new JMenuItem("Shutdown");
        shutdownItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ServiceDebugWindow.this.close();
            }
        });
        menuAccessPoint.add(shutdownItem);
        menuBar.add(menuAccessPoint);
        this.frame.setJMenuBar(menuBar);
        this.frame.add(this.userInfo.getComponent());
        this.frame.setPreferredSize(new Dimension(640, 480));
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    private String getTitleText() {
        ServiceStatus serviceStatus = this.level1.getServiceStatus(UserId.SYSTEM);
        String applicationName = serviceStatus.getServiceName();
        Version version = serviceStatus.getVersion();
        if (version == null) {
            return applicationName;
        }
        return String.format("%s (%s)", applicationName, version);
    }

    protected void close() {
        if (JOptionPane.showConfirmDialog(this.frame, "Really shutdown SES-imagotag Core service?", "SES-imagotag Core", 0) == 0) {
            this.frame.dispose();
            this.frame = null;
            this.level1.shutdownService();
        }
    }

    public void run() {
    }

    public void cleanup(int daysToKeep) {
    }

    public void shutdown() {
        if (this.frame != null) {
            logger.info("Shutting down service debug window");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServiceDebugWindow.this.frame.dispose();
                    ServiceDebugWindow.this.frame = null;
                }
            });
        }
    }

    public void notifyUpdateFinished(UpdateResult updateResult) {
        if (this.userInfo != null) {
            this.userInfo.addInfo("Task to label %s finished with status %s", new Object[]{updateResult.getLabelId(), updateResult.getStatus()});
        }
    }

    public void notifyLabelStatusChanged() {
        if (this.userInfo != null) {
            this.userInfo.addInfo("Label status changed", new Object[0]);
        }
    }

    public void notifyLabelEvent(LabelEvent labelEvent) {
        if (this.userInfo != null) {
            this.userInfo.addInfo("Received label event from %s", new Object[]{labelEvent.getLabelAddress()});
        }
    }

    public void notifyEslProblem() {
        if (this.userInfo != null) {
            this.userInfo.addWarning("ESL problem detected", new Object[0]);
        }
    }
}

