/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom;

import at.mrdevelopment.esl.type.wrapper.task.ESLTaskOrder;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class JerseyValidationUtils {
    public static void validatePage(Integer page) {
        if (page != null && page < 0) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Negative page number not allowed").build());
        }
    }

    public static WebApplicationException createException(Throwable exc, Response.Status status) {
        return new WebApplicationException(exc, Response.status((Response.Status)status).type("text/plain").entity((Object)exc.getMessage()).build());
    }

    public static void respondErrorMessage(String message, Response.Status status) {
        throw new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)message).build());
    }

    public static void validateNotNull(Object parameter) {
        JerseyValidationUtils.validateNotNull(parameter, "Parameter not allowed to be null", new Object[0]);
    }

    public static void validateNotNull(Object parameter, String message, Object ... args) {
        if (parameter == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)(message != null ? String.format(message, args) : "")).build());
        }
    }

    public static void validateAccessPointId(int accessPointId) {
        if (accessPointId < 1000) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Access Point ID must be >= 1000").build());
        }
    }

    public static void validateNotEmpty(String parameter) {
        if (parameter == null || parameter.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Parameter not allowed to be empty").build());
        }
    }

    public static void validateMinutes(Integer minutes) {
        if (minutes == null || minutes < 0 || minutes >= 60) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Minutes must be between 0-59").build());
        }
    }

    public static void validateNotEmpty(ESLTaskOrder order) {
        if (order.Task == null || order.Task.size() == 0) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Empty list of tasks not allowed").build());
        }
    }
}

