/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.firmware.FileFirmwareSource;
import at.mrdevelopment.esl.firmware.FirmwareSource;
import at.mrdevelopment.esl.firmware.MemoryFirmwareSource;
import at.mrdevelopment.esl.flashing.BasicLED;
import at.mrdevelopment.esl.flashing.LEDColor;
import at.mrdevelopment.esl.flashing.LEDPattern;
import at.mrdevelopment.esl.flashing.LabelLED;
import at.mrdevelopment.esl.tasks.BinaryImageTask;
import at.mrdevelopment.esl.tasks.FirmwareTask;
import at.mrdevelopment.esl.tasks.FlashingTask;
import at.mrdevelopment.esl.tasks.ForceChannelScanTask;
import at.mrdevelopment.esl.tasks.ForceUpdateTask;
import at.mrdevelopment.esl.tasks.GetConfigTask;
import at.mrdevelopment.esl.tasks.ImageTask;
import at.mrdevelopment.esl.tasks.InitializeTask;
import at.mrdevelopment.esl.tasks.NDEFMessageTask;
import at.mrdevelopment.esl.tasks.PingTask;
import at.mrdevelopment.esl.tasks.QueryCounterTask;
import at.mrdevelopment.esl.tasks.QuerySensorTask;
import at.mrdevelopment.esl.tasks.RebootTask;
import at.mrdevelopment.esl.tasks.RefreshDisplayTask;
import at.mrdevelopment.esl.tasks.ResendTask;
import at.mrdevelopment.esl.tasks.ResetAllCountersTask;
import at.mrdevelopment.esl.tasks.ResetCounterTask;
import at.mrdevelopment.esl.tasks.ResetImageTask;
import at.mrdevelopment.esl.tasks.ResetTask;
import at.mrdevelopment.esl.tasks.SetConfigTask;
import at.mrdevelopment.esl.tasks.SwitchPageTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.TemplateValuesTask;
import at.mrdevelopment.esl.tasks.TemplateXMLTask;
import at.mrdevelopment.esl.tasks.UnlockLabelTask;
import at.mrdevelopment.esl.template.DOMTemplateSource;
import at.mrdevelopment.esl.template.FileTemplateSource;
import at.mrdevelopment.esl.template.TemplateSource;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.LabelKeys;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.FirmwareImage;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskXMLSerializer
implements XMLSerializer<Task> {
    static ESLLogger logger = ESLLogger.getLogger(TaskXMLSerializer.class);
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(TaskOrder taskOrder) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        Element list = document.createElement("tasks");
        if (taskOrder.getTitle() != null) {
            list.setAttribute("title", taskOrder.getTitle());
        }
        if (taskOrder.getExternalId() != 0L) {
            list.setAttribute("externalId", Long.toString(taskOrder.getExternalId()));
        }
        for (Task task : taskOrder.getTasks()) {
            list.appendChild(this.taskToXML(document, task));
        }
        document.appendChild(list);
        return document;
    }

    public Document toXML(Task task) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        Element list = document.createElement("tasks");
        list.appendChild(this.taskToXML(document, task));
        document.appendChild(list);
        return document;
    }

    private Element taskToXML(Document document, Task task) throws SerializeException {
        Element taskElement = document.createElement("task");
        taskElement.setAttribute("id", Long.toString(task.getExternalId()));
        taskElement.setAttribute("label", task.getLabelId().getLabelIdString());
        taskElement.setAttribute("priority", task.getPriority().toString());
        taskElement.setAttribute("replace", Boolean.toString(task.isReplaceWaitingTasks()));
        if (task.getRetryValidInMinutes() != null) {
            taskElement.setAttribute("retryValidInMinutes", Integer.toString(task.getRetryValidInMinutes()));
        }
        if (task instanceof TemplateXMLTask) {
            Element element = this.templateXMLTaskToXML(document, (TemplateXMLTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof TemplateValuesTask) {
            Element element = this.templateValuesTaskToXML(document, (TemplateValuesTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof ImageTask) {
            Element element = this.imageTaskToXML(document, (ImageTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof BinaryImageTask) {
            Element element = this.binaryImageTaskToXML(document, (BinaryImageTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof ResetTask) {
            Element element = this.resetTaskToXML(document, (ResetTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof ResendTask) {
            Element element = this.resendTaskToXML(document, (ResendTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof FirmwareTask) {
            Element element = this.firmwareTaskToXML(document, (FirmwareTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof SwitchPageTask) {
            Element element = this.switchPageTaskToXML(document, (SwitchPageTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof RefreshDisplayTask) {
            Element element = this.refreshDisplayTaskToXML(document, (RefreshDisplayTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof ForceUpdateTask) {
            Element element = this.forceUpdateTaskToXML(document, (ForceUpdateTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof PingTask) {
            Element element = this.pingTaskToXML(document, (PingTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof UnlockLabelTask) {
            Element element = this.unlockLabelTaskToXML(document, (UnlockLabelTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof QueryCounterTask) {
            Element element = this.queryCounterTaskToXML(document, (QueryCounterTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof QuerySensorTask) {
            Element element = this.querySensorTaskToXML(document, (QuerySensorTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof GetConfigTask) {
            Element element = this.getConfigTaskToXML(document, (GetConfigTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof SetConfigTask) {
            Element element = this.getSetConfigTaskToXML(document, (SetConfigTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof ResetCounterTask) {
            Element element = this.getResetCounterTaskToXML(document, (ResetCounterTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof ResetAllCountersTask) {
            Element element = this.getResetAllCountersTaskToXML(document, (ResetAllCountersTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof RebootTask) {
            Element element = this.getRebootTaskToXML(document, (RebootTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof ForceChannelScanTask) {
            Element element = this.getForceChannelScanTaskToXML(document, (ForceChannelScanTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof InitializeTask) {
            Element element = this.getInitializeTaskToXML(document, (InitializeTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof FlashingTask) {
            Element element = this.getFlashingTaskToXML(document, (FlashingTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof NDEFMessageTask) {
            Element element = this.getNDEFMessageTaskToXML(document, (NDEFMessageTask)task);
            taskElement.appendChild(element);
        } else {
            throw new SerializeException("Could not serialize unknown task type %s", new Object[]{task.getClass().getSimpleName()});
        }
        return taskElement;
    }

    private Element getNDEFMessageTaskToXML(Document document, NDEFMessageTask task) {
        Element taskElement = document.createElement("ndefmessage-task");
        taskElement.setAttribute("url", task.getURL());
        return taskElement;
    }

    public Element getFlashingTaskToXML(Document document, FlashingTask task) {
        Element taskElement = document.createElement("flashing-task");
        LabelLED led = task.getLabelLED();
        if (led instanceof BasicLED) {
            BasicLED basicLed = (BasicLED)led;
            Element ledElement = document.createElement("basic-led");
            ledElement.setAttribute("color", String.valueOf(basicLed.getColor().getValue()));
            ledElement.setAttribute("pattern", String.valueOf(basicLed.getPattern().getValue()));
            ledElement.setAttribute("duration", String.valueOf(basicLed.getDurationInMinutes()));
            ledElement.setAttribute("count", String.valueOf(basicLed.getRepeatCount()));
            taskElement.appendChild(ledElement);
        }
        return taskElement;
    }

    private Element getInitializeTaskToXML(Document document, InitializeTask task) {
        Element taskElement = document.createElement("initialize-task");
        for (Map.Entry<LabelKeys, String> entry : task.getKeys().entrySet()) {
            Element keyElement = document.createElement("key");
            keyElement.setAttribute("id", String.valueOf(entry.getKey().getKeyId()));
            keyElement.setAttribute("value", entry.getValue());
            taskElement.appendChild(keyElement);
        }
        return taskElement;
    }

    private Element getForceChannelScanTaskToXML(Document document, ForceChannelScanTask task) {
        Element taskElement = document.createElement("force-channel-scan-task");
        taskElement.setAttribute("all-channels", Boolean.toString(task.isScanAllChannels()));
        return taskElement;
    }

    private Element getRebootTaskToXML(Document document, RebootTask task) {
        Element taskElement = document.createElement("reboot-task");
        return taskElement;
    }

    private Element getResetAllCountersTaskToXML(Document document, ResetAllCountersTask task) {
        Element taskElement = document.createElement("reset-all-counters-task");
        return taskElement;
    }

    private Element getResetCounterTaskToXML(Document document, ResetCounterTask task) {
        Element taskElement = document.createElement("reset-counter-task");
        int index = 1;
        for (LabelCounter counter : task.getCounters()) {
            taskElement.setAttribute(String.format("counter%d", index), String.valueOf(counter.getCounterId()));
            ++index;
        }
        return taskElement;
    }

    private Element getSetConfigTaskToXML(Document document, SetConfigTask task) {
        Element taskElement = document.createElement("set-config-task");
        int index = 1;
        for (Map.Entry<LabelConfig, Integer> config : task.getConfigs().entrySet()) {
            taskElement.setAttribute(String.format("config%d", index), String.valueOf(config.getKey().getConfigId()));
            taskElement.setAttribute(String.format("value%d", index), String.valueOf(config.getValue()));
            ++index;
        }
        return taskElement;
    }

    private Element getConfigTaskToXML(Document document, GetConfigTask task) {
        Element taskElement = document.createElement("get-config-task");
        int index = 1;
        for (LabelConfig config : task.getConfigs()) {
            taskElement.setAttribute(String.format("config%d", index), String.valueOf(config.getConfigId()));
            ++index;
        }
        return taskElement;
    }

    private Element querySensorTaskToXML(Document document, QuerySensorTask task) {
        Element taskElement = document.createElement("query-sensor-task");
        int index = 1;
        for (LabelSensor sensor : task.getSensors()) {
            taskElement.setAttribute(String.format("sensor%d", index), String.valueOf(sensor.getSensorId()));
            ++index;
        }
        return taskElement;
    }

    private Element queryCounterTaskToXML(Document document, QueryCounterTask task) {
        Element taskElement = document.createElement("query-counter-task");
        int index = 1;
        for (LabelCounter counter : task.getCounters()) {
            taskElement.setAttribute(String.format("counter%d", index), String.valueOf(counter.getCounterId()));
            ++index;
        }
        return taskElement;
    }

    private Element templateValuesTaskToXML(Document document, TemplateValuesTask task) throws SerializeException {
        Element taskElement = document.createElement("values-template-task");
        taskElement = this.templateSourceToXML(document, taskElement, task.getTemplateSource());
        taskElement.setAttribute("page", Integer.toString(task.getPage().getPageIndex()));
        taskElement.setAttribute("preload", Boolean.toString(task.isPreload()));
        taskElement.setAttribute("skipOnEqualImage", Boolean.toString(task.isSkipOnEqualImage()));
        Element valuesElement = document.createElement("values");
        taskElement.appendChild(valuesElement);
        for (Map.Entry<String, String> entry : task.getValues().entrySet()) {
            Element element = document.createElement("value");
            element.setAttribute("key", entry.getKey());
            element.setTextContent(entry.getValue());
            valuesElement.appendChild(element);
        }
        return taskElement;
    }

    private Element templateXMLTaskToXML(Document document, TemplateXMLTask task) throws SerializeException {
        Element taskElement = document.createElement("xml-template-task");
        taskElement = this.templateSourceToXML(document, taskElement, task.getTemplateSource());
        taskElement.setAttribute("page", Integer.toString(task.getPage().getPageIndex()));
        taskElement.setAttribute("preload", Boolean.toString(task.isPreload()));
        taskElement.setAttribute("skipOnEqualImage", Boolean.toString(task.isSkipOnEqualImage()));
        Node importedNode = document.importNode(task.getDocument().getDocumentElement(), true);
        taskElement.appendChild(importedNode);
        return taskElement;
    }

    private Element templateSourceToXML(Document document, Element taskElement, TemplateSource templateSource) throws SerializeException {
        if (templateSource instanceof FileTemplateSource) {
            FileTemplateSource fileTemplateSource = (FileTemplateSource)templateSource;
            taskElement.setAttribute("template", fileTemplateSource.getTemplateFilename());
        } else if (templateSource instanceof DOMTemplateSource) {
            Element templateSourceElement = document.createElement("templateSource");
            DOMTemplateSource domTemplateSource = (DOMTemplateSource)templateSource;
            Node sourceNode = domTemplateSource.getSource().getNode();
            if (sourceNode instanceof Document) {
                sourceNode = ((Document)sourceNode).getDocumentElement();
            }
            sourceNode = document.importNode(sourceNode, true);
            templateSourceElement.appendChild(sourceNode);
            taskElement.appendChild(templateSourceElement);
        }
        return taskElement;
    }

    private Element imageTaskToXML(Document document, ImageTask task) {
        Element taskElement = document.createElement("image-task");
        taskElement.setAttribute("file", task.getImageFilename());
        taskElement.setAttribute("page", Integer.toString(task.getPage().getPageIndex()));
        taskElement.setAttribute("skipOnEqualImage", Boolean.toString(task.isSkipOnEqualImage()));
        taskElement.setAttribute("preload", Boolean.toString(task.isPreload()));
        return taskElement;
    }

    private Element binaryImageTaskToXML(Document document, BinaryImageTask task) throws SerializeException {
        Element taskElement = document.createElement("binary-image-task");
        taskElement.setAttribute("image", ImageSerializer.toBase64String((BufferedImage)task.getImage()));
        taskElement.setAttribute("page", Integer.toString(task.getPage().getPageIndex()));
        taskElement.setAttribute("skipOnEqualImage", Boolean.toString(task.isSkipOnEqualImage()));
        taskElement.setAttribute("preload", Boolean.toString(task.isPreload()));
        return taskElement;
    }

    private Element resetTaskToXML(Document document, ResetTask task) {
        Element taskElement = document.createElement("reset-task");
        return taskElement;
    }

    private Element resendTaskToXML(Document document, ResendTask task) {
        Element taskElement = document.createElement("resend-task");
        taskElement.setAttribute("task-id", task.getTaskId().toString());
        return taskElement;
    }

    private Element firmwareTaskToXML(Document document, FirmwareTask task) {
        Element taskElement = document.createElement("firmware-task");
        taskElement = this.firmwareSourceToXML(document, taskElement, task.getFirmwareSource());
        return taskElement;
    }

    private Element firmwareSourceToXML(Document document, Element taskElement, FirmwareSource firmwareSource) {
        if (firmwareSource instanceof FileFirmwareSource) {
            FileFirmwareSource fileFirmwareSource = (FileFirmwareSource)firmwareSource;
            taskElement.setAttribute("file", fileFirmwareSource.getFirmwareFilename());
        } else if (firmwareSource instanceof MemoryFirmwareSource) {
            MemoryFirmwareSource memoryFirmwareSource = (MemoryFirmwareSource)firmwareSource;
            taskElement.setAttribute("data", memoryFirmwareSource.getData());
        }
        return taskElement;
    }

    private Element switchPageTaskToXML(Document document, SwitchPageTask task) {
        Element taskElement = document.createElement("switch-page-task");
        taskElement.setAttribute("page", Integer.toString(task.getPage().getPageIndex()));
        taskElement.setAttribute("durationInMinutes", String.valueOf(task.getDurationInMinutes()));
        return taskElement;
    }

    private Element refreshDisplayTaskToXML(Document document, RefreshDisplayTask task) {
        Element taskElement = document.createElement("refresh-display-task");
        return taskElement;
    }

    private Element forceUpdateTaskToXML(Document document, ForceUpdateTask task) {
        Element taskElement = document.createElement("force-update-task");
        return taskElement;
    }

    private Element pingTaskToXML(Document document, PingTask task) {
        Element taskElement = document.createElement("ping-task");
        return taskElement;
    }

    private Element unlockLabelTaskToXML(Document document, UnlockLabelTask task) {
        Element taskElement = document.createElement("unlock-task");
        taskElement.setAttribute("puk", task.getPuk().toBase64());
        return taskElement;
    }

    public Collection<Task> parseXMLFromFile(File xmlFile, File templateDirectory) throws SerializeException {
        try {
            Element root = this.xmlToolkit.getDocumentRootFromFile(xmlFile);
            return this.parseTasks(root, templateDirectory);
        }
        catch (IOException exc) {
            throw new SerializeException((Throwable)exc);
        }
        catch (NumberFormatException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public TaskOrder parseXMLFromStream(InputStream xmlInputStream, File templateDirectory) throws SerializeException {
        try {
            Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
            String title = root.getAttribute("title");
            long externalId = root.hasAttribute("externalId") ? Long.parseLong(root.getAttribute("externalId")) : 0L;
            List<Task> tasks = this.parseTasks(root, templateDirectory);
            return new TaskOrder(title, externalId, tasks);
        }
        catch (RuntimeException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private List<Task> parseTasks(Element root, File templateDirectory) throws SerializeException, NumberFormatException, IllegalArgumentException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        NodeList taskNodes = root.getElementsByTagName("task");
        for (int index = 0; index < taskNodes.getLength(); ++index) {
            Element taskElement = (Element)taskNodes.item(index);
            Task task = this.parseTask(taskElement, templateDirectory);
            tasks.add(task);
        }
        return tasks;
    }

    private Task parseTask(Element element, File templateDirectory) throws SerializeException, NumberFormatException, IllegalArgumentException {
        LabelId labelId = LabelId.fromString(element.getAttribute("label"));
        TaskPriority priority = element.hasAttribute("priority") ? TaskPriority.valueOf((String)element.getAttribute("priority")) : TaskPriority.NORMAL;
        long externalId = element.hasAttribute("id") ? Long.parseLong(element.getAttribute("id")) : 0L;
        boolean replaceWaitingTasks = element.hasAttribute("replace") ? Boolean.valueOf(element.getAttribute("replace")) : false;
        Integer retryValidInMinutes = element.hasAttribute("retryValidInMinutes") ? Integer.valueOf(Integer.parseInt(element.getAttribute("retryValidInMinutes"))) : null;
        NodeList templateValuesNodes = element.getElementsByTagName("values-template-task");
        NodeList templateXMLNodes = element.getElementsByTagName("xml-template-task");
        NodeList imageNodes = element.getElementsByTagName("image-task");
        NodeList binaryImageNodes = element.getElementsByTagName("binary-image-task");
        NodeList resetNodes = element.getElementsByTagName("reset-task");
        NodeList resetImageNodes = element.getElementsByTagName("reset-image-task");
        NodeList resendNodes = element.getElementsByTagName("resend-task");
        NodeList firmwareNodes = element.getElementsByTagName("firmware-task");
        NodeList switchPageNodes = element.getElementsByTagName("switch-page-task");
        NodeList refreshDisplayNodes = element.getElementsByTagName("refresh-display-task");
        NodeList forceUpdateNodes = element.getElementsByTagName("force-update-task");
        NodeList pingNodes = element.getElementsByTagName("ping-task");
        NodeList unlockLabelNodes = element.getElementsByTagName("unlock-task");
        NodeList queryCounterNodes = element.getElementsByTagName("query-counter-task");
        NodeList querySensorNodes = element.getElementsByTagName("query-sensor-task");
        NodeList getConfigNodes = element.getElementsByTagName("get-config-task");
        NodeList setConfigNodes = element.getElementsByTagName("set-config-task");
        NodeList resetCounterNodes = element.getElementsByTagName("reset-counter-task");
        NodeList resetAllCountersNodes = element.getElementsByTagName("reset-all-counter-task");
        NodeList rebootNodes = element.getElementsByTagName("reboot-task");
        NodeList forceChannelScanNodes = element.getElementsByTagName("force-channel-scan-task");
        NodeList initializeNodes = element.getElementsByTagName("initialize-task");
        NodeList flashingNodes = element.getElementsByTagName("flashing-task");
        NodeList ndefMessageNodes = element.getElementsByTagName("ndefmessage-task");
        if (templateValuesNodes.getLength() > 0) {
            return this.parseTemplateValuesTask(labelId, priority, externalId, replaceWaitingTasks, (Element)templateValuesNodes.item(0), templateDirectory, retryValidInMinutes);
        }
        if (templateXMLNodes.getLength() > 0) {
            return this.parseTemplateXMLTask(labelId, priority, externalId, replaceWaitingTasks, (Element)templateXMLNodes.item(0), templateDirectory, retryValidInMinutes);
        }
        if (imageNodes.getLength() > 0) {
            return this.parseImageTask(labelId, priority, externalId, replaceWaitingTasks, (Element)imageNodes.item(0), retryValidInMinutes);
        }
        if (binaryImageNodes.getLength() > 0) {
            return this.parseBinaryImageTask(labelId, priority, externalId, replaceWaitingTasks, (Element)binaryImageNodes.item(0), retryValidInMinutes);
        }
        if (resetNodes.getLength() > 0) {
            return this.parseResetTask(labelId, priority, externalId, replaceWaitingTasks, (Element)resetNodes.item(0), retryValidInMinutes);
        }
        if (resetImageNodes.getLength() > 0) {
            return this.parseResetImageTask(labelId, priority, externalId, replaceWaitingTasks, (Element)resetImageNodes.item(0), retryValidInMinutes);
        }
        if (resendNodes.getLength() > 0) {
            return this.parseResendTask(labelId, priority, externalId, replaceWaitingTasks, (Element)resendNodes.item(0), retryValidInMinutes);
        }
        if (firmwareNodes.getLength() > 0) {
            return this.parseFirmwareTask(labelId, priority, externalId, replaceWaitingTasks, (Element)firmwareNodes.item(0), retryValidInMinutes);
        }
        if (switchPageNodes.getLength() > 0) {
            return this.parseSwitchPageTask(labelId, priority, externalId, replaceWaitingTasks, (Element)switchPageNodes.item(0), retryValidInMinutes);
        }
        if (refreshDisplayNodes.getLength() > 0) {
            return this.refreshDisplayTask(labelId, priority, externalId, replaceWaitingTasks, (Element)refreshDisplayNodes.item(0), retryValidInMinutes);
        }
        if (forceUpdateNodes.getLength() > 0) {
            return this.forceUpdateTask(labelId, priority, externalId, replaceWaitingTasks, (Element)forceUpdateNodes.item(0), retryValidInMinutes);
        }
        if (pingNodes.getLength() > 0) {
            return this.pingTask(labelId, priority, externalId, replaceWaitingTasks, (Element)pingNodes.item(0), retryValidInMinutes);
        }
        if (unlockLabelNodes.getLength() > 0) {
            return this.unlockLabelTask(labelId, priority, externalId, replaceWaitingTasks, (Element)unlockLabelNodes.item(0));
        }
        if (queryCounterNodes.getLength() > 0) {
            return this.queryCounterTask(labelId, priority, externalId, replaceWaitingTasks, (Element)queryCounterNodes.item(0), retryValidInMinutes);
        }
        if (querySensorNodes.getLength() > 0) {
            return this.querySensorTask(labelId, priority, externalId, replaceWaitingTasks, (Element)querySensorNodes.item(0), retryValidInMinutes);
        }
        if (getConfigNodes.getLength() > 0) {
            return this.getConfigTask(labelId, priority, externalId, replaceWaitingTasks, (Element)getConfigNodes.item(0), retryValidInMinutes);
        }
        if (setConfigNodes.getLength() > 0) {
            return this.setConfigTask(labelId, priority, externalId, replaceWaitingTasks, (Element)setConfigNodes.item(0), retryValidInMinutes);
        }
        if (resetCounterNodes.getLength() > 0) {
            return this.resetCounterTask(labelId, priority, externalId, replaceWaitingTasks, (Element)resetCounterNodes.item(0), retryValidInMinutes);
        }
        if (resetAllCountersNodes.getLength() > 0) {
            return this.resetAllCountersTask(labelId, priority, externalId, replaceWaitingTasks, (Element)resetAllCountersNodes.item(0), retryValidInMinutes);
        }
        if (rebootNodes.getLength() > 0) {
            return this.rebootTask(labelId, priority, externalId, replaceWaitingTasks, (Element)rebootNodes.item(0), retryValidInMinutes);
        }
        if (forceChannelScanNodes.getLength() > 0) {
            return this.forceChannelScanTask(labelId, priority, externalId, replaceWaitingTasks, (Element)forceChannelScanNodes.item(0), retryValidInMinutes);
        }
        if (initializeNodes.getLength() > 0) {
            return this.initializeTask(labelId, priority, externalId, replaceWaitingTasks, (Element)initializeNodes.item(0), retryValidInMinutes);
        }
        if (flashingNodes.getLength() > 0) {
            return this.flashingTask(labelId, priority, externalId, replaceWaitingTasks, (Element)flashingNodes.item(0), retryValidInMinutes);
        }
        if (ndefMessageNodes.getLength() > 0) {
            return this.ndefMessageTask(labelId, priority, externalId, replaceWaitingTasks, (Element)ndefMessageNodes.item(0), retryValidInMinutes);
        }
        throw new SerializeException("Unexpected task type", new Object[0]);
    }

    private Task parseTemplateValuesTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, File templateDirectory, Integer retryValidInMinutes) throws SerializeException {
        TemplateSource templateSource = this.parseTemplateSource(element, templateDirectory);
        Page page = Page.fromString((String)element.getAttribute("page"));
        boolean preload = Boolean.parseBoolean(element.getAttribute("preload"));
        boolean skipOnEqualImage = element.hasAttribute("skipOnEqualImage") ? Boolean.parseBoolean(element.getAttribute("skipOnEqualImage")) : false;
        NodeList valueNodes = element.getElementsByTagName("value");
        HashMap<String, String> values = new HashMap<String, String>();
        for (int index = 0; index < valueNodes.getLength(); ++index) {
            Element valueElement = (Element)valueNodes.item(index);
            String key = valueElement.getAttribute("key");
            String value = valueElement.getTextContent();
            values.put(key, value);
        }
        return new TemplateValuesTask(labelId, priority, externalId, replaceWaitingTasks, templateSource, values, page, preload, skipOnEqualImage, retryValidInMinutes);
    }

    private Task parseTemplateXMLTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, File templateDirectory, Integer retryValidInMinutes) throws SerializeException {
        TemplateSource templateSource = this.parseTemplateSource(element, templateDirectory);
        Page page = Page.fromString((String)element.getAttribute("page"));
        boolean preload = Boolean.parseBoolean(element.getAttribute("preload"));
        boolean skipOnEqualImage = element.hasAttribute("skipOnEqualImage") ? Boolean.parseBoolean(element.getAttribute("skipOnEqualImage")) : false;
        Document document = this.xmlToolkit.newDocument();
        NodeList nodes = element.getChildNodes();
        for (int index = 0; index < nodes.getLength(); ++index) {
            Node node = nodes.item(index);
            if (!(node instanceof Element)) continue;
            Node importedNode = document.importNode(node, true);
            document.appendChild(importedNode);
        }
        return new TemplateXMLTask(labelId, priority, externalId, replaceWaitingTasks, templateSource, document, page, preload, skipOnEqualImage, retryValidInMinutes);
    }

    private TemplateSource parseTemplateSource(Element element, File templateDirectory) throws SerializeException {
        if (element.hasAttribute("template")) {
            String templateName = element.getAttribute("template");
            return new FileTemplateSource(templateDirectory, templateName);
        }
        NodeList templateSourceElement = element.getElementsByTagName("templateSource");
        if (templateSourceElement.getLength() > 0 && templateSourceElement.item(0).hasChildNodes()) {
            NodeList childNodes = templateSourceElement.item(0).getChildNodes();
            for (int index = 0; index < childNodes.getLength(); ++index) {
                Node childNode = childNodes.item(index);
                if (childNode.getNodeType() != 1) continue;
                Document templateDocument = this.xmlToolkit.newDocument();
                templateDocument.appendChild(templateDocument.importNode(childNode, true));
                DOMTemplateSource domTemplateSource = new DOMTemplateSource(templateDirectory, new DOMSource(templateDocument));
                element.removeChild(templateSourceElement.item(0));
                return domTemplateSource;
            }
        }
        throw new SerializeException("No template source found in XML", new Object[0]);
    }

    private ImageTask parseImageTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        String imageFilename = element.getAttribute("file");
        Page page = Page.fromString((String)element.getAttribute("page"));
        boolean preload = Boolean.parseBoolean(element.getAttribute("preload"));
        boolean skipOnEqualImage = element.hasAttribute("skipOnEqualImage") ? Boolean.parseBoolean(element.getAttribute("skipOnEqualImage")) : false;
        return new ImageTask(labelId, priority, externalId, replaceWaitingTasks, imageFilename, page, preload, skipOnEqualImage, retryValidInMinutes);
    }

    private BinaryImageTask parseBinaryImageTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) throws NumberFormatException, SerializeException {
        BufferedImage image = ImageSerializer.fromBase64String((String)element.getAttribute("image"));
        Page page = Page.fromString((String)element.getAttribute("page"));
        boolean preload = Boolean.parseBoolean(element.getAttribute("preload"));
        boolean skipOnEqualImage = element.hasAttribute("skipOnEqualImage") ? Boolean.parseBoolean(element.getAttribute("skipOnEqualImage")) : false;
        return new BinaryImageTask(labelId, priority, externalId, replaceWaitingTasks, image, page, preload, skipOnEqualImage, retryValidInMinutes);
    }

    private ResetTask parseResetTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        return new ResetTask(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
    }

    private ResetImageTask parseResetImageTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        return new ResetImageTask(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
    }

    private ResendTask parseResendTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) throws IllegalArgumentException {
        UUID taskId = UUID.fromString(element.getAttribute("task-id"));
        return new ResendTask(labelId, priority, externalId, replaceWaitingTasks, taskId, retryValidInMinutes);
    }

    private FirmwareTask parseFirmwareTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        FirmwareSource firmwareSource = this.parseFirmwareSource(element);
        return new FirmwareTask(labelId, priority, externalId, replaceWaitingTasks, firmwareSource, retryValidInMinutes);
    }

    private FirmwareSource parseFirmwareSource(Element element) {
        if (element.hasAttribute("file")) {
            return new FileFirmwareSource(element.getAttribute("file"));
        }
        FirmwareImage firmwareImage = FirmwareImage.decode((String)element.getAttribute("data"));
        return new MemoryFirmwareSource(firmwareImage);
    }

    private SwitchPageTask parseSwitchPageTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) throws NumberFormatException {
        Page page = Page.fromString((String)element.getAttribute("page"));
        int duration = element.hasAttribute("durationInMinutes") ? Integer.valueOf(element.getAttribute("durationInMinutes")) : 0;
        return new SwitchPageTask(labelId, priority, externalId, replaceWaitingTasks, page, duration, retryValidInMinutes);
    }

    private RefreshDisplayTask refreshDisplayTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        return new RefreshDisplayTask(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
    }

    private ForceUpdateTask forceUpdateTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        return new ForceUpdateTask(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
    }

    private PingTask pingTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        return new PingTask(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
    }

    private UnlockLabelTask unlockLabelTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) {
        Puk puk = Puk.fromBase64((String)element.getAttribute("puk"));
        return new UnlockLabelTask(labelId, puk, priority, externalId, replaceWaitingTasks);
    }

    private Task queryCounterTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        ArrayList<LabelCounter> counters = new ArrayList<LabelCounter>();
        int index = 1;
        while (element.hasAttribute(String.format("counter%d", index))) {
            int counterId = Integer.valueOf(element.getAttribute(String.format("counter%d", index)));
            counters.add(LabelCounter.fromId((int)counterId));
            ++index;
        }
        return new QueryCounterTask(labelId, priority, externalId, replaceWaitingTasks, counters, retryValidInMinutes);
    }

    private Task initializeTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        NodeList keyNodeList = element.getElementsByTagName("key");
        HashMap<LabelKeys, String> keys = new HashMap<LabelKeys, String>();
        if (keyNodeList.getLength() > 0) {
            for (int index = 0; index < keyNodeList.getLength(); ++index) {
                Element keyElement = (Element)keyNodeList.item(index);
                int keyId = Integer.valueOf(keyElement.getAttribute("id"));
                String key = keyElement.getTextContent();
                keys.put(LabelKeys.fromId((int)keyId), key);
            }
        }
        return new InitializeTask(labelId, priority, externalId, replaceWaitingTasks, keys, retryValidInMinutes);
    }

    private Task flashingTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) throws SerializeException {
        NodeList basicLedNodeList = element.getElementsByTagName("basic-led");
        if (basicLedNodeList.getLength() > 0) {
            Element basicLedElement = (Element)basicLedNodeList.item(0);
            LEDColor color = LEDColor.fromValue(Integer.valueOf(basicLedElement.getAttribute("color")));
            LEDPattern pattern = LEDPattern.fromValue(Integer.valueOf(basicLedElement.getAttribute("pattern")));
            int duration = Integer.valueOf(basicLedElement.getAttribute("duration"));
            int count = Integer.valueOf(basicLedElement.getAttribute("count"));
            BasicLED led = duration > 0 ? BasicLED.createWithDuration(color, pattern, duration) : BasicLED.createWithCount(color, pattern, count);
            return new FlashingTask(labelId, priority, externalId, replaceWaitingTasks, led, retryValidInMinutes);
        }
        throw new SerializeException("LED type not supported", new Object[0]);
    }

    private Task ndefMessageTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) throws SerializeException {
        try {
            String url = element.getAttribute("url");
            return new NDEFMessageTask(labelId, priority, externalId, replaceWaitingTasks, url, retryValidInMinutes);
        }
        catch (MalformedURLException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private Task forceChannelScanTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        boolean allChannels = Boolean.valueOf(element.getAttribute("all-channels"));
        return new ForceChannelScanTask(labelId, priority, externalId, replaceWaitingTasks, allChannels, retryValidInMinutes);
    }

    private Task rebootTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        return new RebootTask(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
    }

    private Task resetAllCountersTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        return new ResetAllCountersTask(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
    }

    private Task resetCounterTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        ArrayList<LabelCounter> counters = new ArrayList<LabelCounter>();
        int index = 1;
        while (element.hasAttribute(String.format("counter%d", index))) {
            int counterId = Integer.valueOf(element.getAttribute(String.format("counter%d", index)));
            counters.add(LabelCounter.fromId((int)counterId));
            ++index;
        }
        return new ResetCounterTask(labelId, priority, externalId, replaceWaitingTasks, counters, retryValidInMinutes);
    }

    private Task querySensorTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        ArrayList<LabelSensor> sensors = new ArrayList<LabelSensor>();
        int index = 1;
        while (element.hasAttribute(String.format("sensor%d", index))) {
            int sensorId = Integer.valueOf(element.getAttribute(String.format("sensor%d", index)));
            sensors.add(LabelSensor.fromId((int)sensorId));
            ++index;
        }
        return new QuerySensorTask(labelId, priority, externalId, replaceWaitingTasks, sensors, retryValidInMinutes);
    }

    private Task getConfigTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        ArrayList<LabelConfig> configs = new ArrayList<LabelConfig>();
        int index = 1;
        while (element.hasAttribute(String.format("config%d", index))) {
            int configId = Integer.valueOf(element.getAttribute(String.format("config%d", index)));
            configs.add(LabelConfig.fromId((int)configId));
            ++index;
        }
        return new GetConfigTask(labelId, priority, externalId, replaceWaitingTasks, configs, retryValidInMinutes);
    }

    private Task setConfigTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, Integer retryValidInMinutes) {
        HashMap<LabelConfig, Integer> configs = new HashMap<LabelConfig, Integer>();
        int index = 1;
        while (element.hasAttribute(String.format("config%d", index))) {
            int configId = Integer.valueOf(element.getAttribute(String.format("config%d", index)));
            int value = Integer.valueOf(element.getAttribute(String.format("value%d", index)));
            configs.put(LabelConfig.fromId((int)configId), value);
            ++index;
        }
        return new SetConfigTask(labelId, priority, externalId, replaceWaitingTasks, configs, retryValidInMinutes);
    }
}

