/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LabelXMLSerializer
implements XMLSerializer<LabelId> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Document document, Collection<LabelId> labels) {
        Element element = document.createElement("labels");
        for (LabelId label : labels) {
            Element labelElement = document.createElement("label");
            labelElement.setAttribute("id", label.getLabelIdString());
            element.appendChild(labelElement);
        }
        document.appendChild(element);
        return document;
    }

    public Document toXML(Collection<LabelId> labels) {
        Document document = this.xmlToolkit.newDocument();
        return this.toXML(document, labels);
    }

    public Collection<LabelId> parseXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        NodeList labelNodes = root.getElementsByTagName("label");
        ArrayList<LabelId> labels = new ArrayList<LabelId>(labelNodes.getLength());
        for (int index = 0; index < labelNodes.getLength(); ++index) {
            Element labelElement = (Element)labelNodes.item(index);
            LabelId label = LabelId.fromString(labelElement.getAttribute("id"));
            labels.add(label);
        }
        return labels;
    }
}

