/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.labelstatistics.LabelStatistics;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.text.PercentageFormatter;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LabelStatisticsXMLSerializer
implements XMLSerializer<List<LabelStatistics>> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(List<LabelStatistics> labelStatisticsList) {
        Document document = this.xmlToolkit.newDocument();
        return this.toXML(document, labelStatisticsList);
    }

    public Document toXML(Document document, List<LabelStatistics> labelStatisticsList) {
        int totalLabels = labelStatisticsList.get(0).getTotalLabels();
        Element labelStatisticsElement = document.createElement("LabelStatisticsList");
        labelStatisticsElement.setAttribute("totalLabels", Integer.toString(totalLabels));
        for (LabelStatistics info : labelStatisticsList) {
            this.appendLabelInfo(document, labelStatisticsElement, info, totalLabels);
        }
        document.appendChild(labelStatisticsElement);
        return document;
    }

    private void appendLabelInfo(Document document, Element labelStatisticsElement, LabelStatistics info, int totalLabels) {
        Element element = document.createElement("LabelStatistics");
        element.setAttribute("category", info.getCategory().getIdentifier());
        element.setAttribute("identifier", info.getIdentifier());
        element.setAttribute("description", info.getDescription());
        element.setAttribute("count", String.format("%d", info.getCount()));
        element.setAttribute("percentage", PercentageFormatter.format((int)info.getCount(), (int)totalLabels));
        labelStatisticsElement.appendChild(element);
    }
}

