/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.joda.time.DateTime;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LabelSerialXMLSerializer {
    private final XMLToolkit toolkit = new XMLToolkit();

    public Collection<LabelInfo> parseXML(InputStream inputStream) throws SerializeException {
        ArrayList<LabelInfo> labelInfos = new ArrayList<LabelInfo>();
        Element root = this.toolkit.getDocumentRootFromInputStream(inputStream);
        NodeList nodeList = root.getChildNodes();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Node item = nodeList.item(index);
            if (!(item instanceof Element)) continue;
            Element element = (Element)nodeList.item(index);
            long label = Long.valueOf(element.getElementsByTagName("LabelSerial").item(0).getTextContent());
            ConnectionStatus status = ConnectionStatus.valueOf((String)element.getElementsByTagName("ConnectionStatus").item(0).getTextContent().toUpperCase());
            PowerStatus powerStatus = PowerStatus.valueOf((String)(element.getElementsByTagName("PowerStatus").getLength() > 0 ? element.getElementsByTagName("PowerStatus").item(0).getTextContent().toUpperCase() : "UNKNOWN"));
            Integer rssi = element.getElementsByTagName("RSSI").getLength() > 0 ? Integer.valueOf(element.getElementsByTagName("RSSI").item(0).getTextContent()) : null;
            Integer lqi = element.getElementsByTagName("LQI").getLength() > 0 ? Integer.valueOf(element.getElementsByTagName("LQI").item(0).getTextContent()) : null;
            Version firmware = element.getElementsByTagName("FirmwareVersion").getLength() > 0 ? Version.fromString((String)element.getElementsByTagName("FirmwareVersion").item(0).getTextContent()) : null;
            SyncQuality sync = element.getElementsByTagName("SyncQuality").getLength() > 0 ? SyncQuality.valueOf((String)element.getElementsByTagName("SyncQuality").item(0).getTextContent().toUpperCase()) : null;
            LabelErrors errors = element.getElementsByTagName("LabelErrors").getLength() > 0 ? LabelErrors.valueOf((String)element.getElementsByTagName("LabelErrors").item(0).getTextContent()) : null;
            Page page = element.getElementsByTagName("CurrentPage").getLength() > 0 ? Page.valueOf((int)Integer.valueOf(element.getElementsByTagName("CurrentPage").item(0).getTextContent())) : null;
            Integer apId = element.getElementsByTagName("AccessPointId").getLength() > 0 ? Integer.valueOf(element.getElementsByTagName("AccessPointId").item(0).getTextContent()) : null;
            DateTime wakeupTime = element.getElementsByTagName("WakeupTime").getLength() > 0 ? DateTime.parse((String)element.getElementsByTagName("WakeupTime").item(0).getTextContent()) : null;
            LabelInfo labelInfo = new LabelInfo(new LabelId(label), null, new HashSet<String>());
            labelInfo.setConnectionStatus(status);
            labelInfo.setPowerStatus(powerStatus);
            labelInfo.setRssi(rssi);
            labelInfo.setLqi(lqi);
            labelInfo.setFirmwareVersion(firmware);
            labelInfo.setSyncQuality(sync);
            labelInfo.setLabelErrors(errors);
            labelInfo.setCurrentPage(page);
            labelInfo.setAccessPointId(apId);
            labelInfo.setWakeupTime(wakeupTime);
            labelInfos.add(labelInfo);
        }
        return labelInfos;
    }
}

