/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LabelRegistrationXMLSerializer
implements XMLSerializer<LabelId> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Document document, Collection<LabelRegistration> registrations) {
        Element listElement = document.createElement("labels");
        for (LabelRegistration registration : registrations) {
            Element labelElement = document.createElement("label");
            labelElement.setAttribute("id", registration.getLabelId().getLabelIdString());
            if (registration.hasPin()) {
                labelElement.setAttribute("pin", registration.getPin().toBase64());
            }
            listElement.appendChild(labelElement);
            for (String tag : registration.getTags()) {
                Element tagElement = document.createElement("tag");
                tagElement.setAttribute("name", tag);
                labelElement.appendChild(tagElement);
            }
        }
        document.appendChild(listElement);
        return document;
    }

    public Document toXML(Collection<LabelRegistration> registrations) {
        Document document = this.xmlToolkit.newDocument();
        return this.toXML(document, registrations);
    }

    public Collection<LabelRegistration> parseXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        NodeList labelNodes = root.getElementsByTagName("label");
        ArrayList<LabelRegistration> registrations = new ArrayList<LabelRegistration>(labelNodes.getLength());
        for (int index = 0; index < labelNodes.getLength(); ++index) {
            Element labelElement = (Element)labelNodes.item(index);
            LabelId label = LabelId.fromString(labelElement.getAttribute("id"));
            Pin pin = labelElement.hasAttribute("pin") ? Pin.fromBase64((String)labelElement.getAttribute("pin")) : null;
            NodeList tagNodes = labelElement.getElementsByTagName("tag");
            HashSet<String> tags = new HashSet<String>();
            for (int tagIndex = 0; tagIndex < tagNodes.getLength(); ++tagIndex) {
                Element tagElement = (Element)tagNodes.item(tagIndex);
                String tag = tagElement.getAttribute("name");
                tags.add(tag);
            }
            registrations.add(new LabelRegistration(label, pin, tags));
        }
        return registrations;
    }
}

