/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.LabelInitialization;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LabelInitializationXMLSerializer
implements XMLSerializer<LabelInitialization> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document createRecord(LabelInitialization labelInitialization) {
        Document document = this.xmlToolkit.newDocument();
        Element labelInfoElement = document.createElement("LabelInfo");
        if (labelInitialization.hasLabelType()) {
            Element typeElement = document.createElement("Type");
            typeElement.setTextContent(labelInitialization.getLabelType());
            labelInfoElement.appendChild(typeElement);
        }
        if (labelInitialization.hasRegistrationCode()) {
            Element registrationCodeElement = document.createElement("RegistrationCode");
            registrationCodeElement.setTextContent(labelInitialization.getRegistrationCode().toString());
            labelInfoElement.appendChild(registrationCodeElement);
        }
        if (labelInitialization.hasSerialNumber()) {
            Element serialElement = document.createElement("Serial");
            serialElement.setTextContent(labelInitialization.getSerialNumber());
            labelInfoElement.appendChild(serialElement);
        }
        if (labelInitialization.hasEdition()) {
            Element editionElement = document.createElement("Edition");
            editionElement.setTextContent(labelInitialization.getEdition());
            labelInfoElement.appendChild(editionElement);
        }
        if (labelInitialization.hasOrientation()) {
            Element orientationElement = document.createElement("Orientation");
            orientationElement.setTextContent(String.valueOf(labelInitialization.getOrientation()));
            labelInfoElement.appendChild(orientationElement);
        }
        Element checksumElement = document.createElement("Checksum");
        checksumElement.setTextContent(labelInitialization.getChecksum());
        labelInfoElement.appendChild(checksumElement);
        document.appendChild(labelInfoElement);
        return document;
    }
}

