/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.auxpage.RawAuxPageSource;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import javax.xml.bind.DatatypeConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuxPageSourceXMLSerializer
implements XMLSerializer<RawAuxPageSource> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(RawAuxPageSource auxPageSource) throws SerializeException {
        try {
            Document document = this.xmlToolkit.newDocument();
            Element root = document.createElement("aux-page");
            root.setAttribute("revision", String.format("%02X", auxPageSource.getRevision()));
            if (auxPageSource.getData() != null) {
                root.setTextContent(DatatypeConverter.printHexBinary((byte[])auxPageSource.getData()));
            }
            document.appendChild(root);
            return document;
        }
        catch (IllegalArgumentException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public RawAuxPageSource parseXML(File auxPageSourceFile) throws FileNotFoundException, SerializeException {
        return this.parseXML(this.xmlToolkit.getDocumentRootFromFile(auxPageSourceFile));
    }

    private RawAuxPageSource parseXML(Element root) throws SerializeException {
        try {
            byte revision = (byte)Integer.parseInt(root.getAttribute("revision"), 16);
            byte[] data = DatatypeConverter.parseHexBinary((String)root.getTextContent());
            return new RawAuxPageSource(revision, data);
        }
        catch (NumberFormatException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }
}

