/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Gtin;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ArticleXMLSerializer
implements XMLSerializer<Article> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Collection<Article> articles) {
        Document document = this.xmlToolkit.newDocument();
        Element element = document.createElement("articles");
        for (Article article : articles) {
            Element articleElement = this.articleToXML(document, article);
            element.appendChild(articleElement);
        }
        document.appendChild(element);
        return document;
    }

    public Document toXML(Article article) {
        Document document = this.xmlToolkit.newDocument();
        Element articleElement = this.articleToXML(document, article);
        document.appendChild(articleElement);
        return document;
    }

    public Element articleToXML(Document document, Article article) {
        Element articleElement = document.createElement("article");
        articleElement.setAttribute("articleNumber", article.getArticleNumber().toString());
        for (Gtin gtin : article.getGtins()) {
            Element gtinElement = document.createElement("gtin");
            gtinElement.setAttribute("number", gtin.toString());
            articleElement.appendChild(gtinElement);
        }
        for (Map.Entry entry : article.getValues().entrySet()) {
            Element valueElement = document.createElement("field");
            valueElement.setAttribute("key", (String)entry.getKey());
            valueElement.setAttribute("value", (String)entry.getValue());
            articleElement.appendChild(valueElement);
        }
        return articleElement;
    }

    public List<Article> parseXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        NodeList articleNodes = root.getElementsByTagName("article");
        ArrayList<Article> articles = new ArrayList<Article>(articleNodes.getLength());
        for (int articleIndex = 0; articleIndex < articleNodes.getLength(); ++articleIndex) {
            Element articleElement = (Element)articleNodes.item(articleIndex);
            ArticleNumber articleNumber = ArticleNumber.fromString((String)articleElement.getAttribute("articleNumber"));
            NodeList gtinNodes = articleElement.getElementsByTagName("gtin");
            HashSet<Gtin> gtins = new HashSet<Gtin>();
            for (int gtinIndex = 0; gtinIndex < gtinNodes.getLength(); ++gtinIndex) {
                Element gtinElement = (Element)gtinNodes.item(gtinIndex);
                Gtin gtin = Gtin.fromString((String)gtinElement.getAttribute("number"));
                gtins.add(gtin);
            }
            NodeList valueNodes = articleElement.getElementsByTagName("field");
            HashMap<String, String> values = new HashMap<String, String>();
            for (int valueIndex = 0; valueIndex < valueNodes.getLength(); ++valueIndex) {
                Element valueElement = (Element)valueNodes.item(valueIndex);
                String key = valueElement.getAttribute("key");
                String value = valueElement.getAttribute("value");
                values.put(key, value);
            }
            Article article = new Article(articleNumber, gtins, values);
            articles.add(article);
        }
        return articles;
    }

    public Document newDocument() {
        return this.xmlToolkit.newDocument();
    }
}

