/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.tasks.AbortRequest;
import at.mrdevelopment.esl.tasks.AbortTaskRequest;
import at.mrdevelopment.esl.tasks.AbortTransactionRequest;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AbortRequestXMLSerializer
implements XMLSerializer<AbortRequest> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Collection<AbortRequest> abortRequests) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        Element element = document.createElement("abort-requests");
        for (AbortRequest abortRequest : abortRequests) {
            Element abortElement = document.createElement("abort-request");
            if (abortRequest instanceof AbortTaskRequest) {
                UUID taskId = ((AbortTaskRequest)abortRequest).getTaskId();
                abortElement.setAttribute("task-id", taskId.toString());
            } else if (abortRequest instanceof AbortTransactionRequest) {
                long transactionId = ((AbortTransactionRequest)abortRequest).getTransactionId();
                abortElement.setAttribute("transaction-id", Long.toString(transactionId));
            } else {
                throw new SerializeException("Unsupported abort request of type %s", new Object[]{abortRequest.getClass().getSimpleName()});
            }
            element.appendChild(abortElement);
        }
        document.appendChild(element);
        return document;
    }

    public Collection<AbortRequest> parseXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        NodeList nodes = root.getElementsByTagName("abort-request");
        ArrayList<AbortRequest> abortRequests = new ArrayList<AbortRequest>(nodes.getLength());
        for (int index = 0; index < nodes.getLength(); ++index) {
            Element element = (Element)nodes.item(index);
            if (element.hasAttribute("task-id")) {
                UUID taskId = UUID.fromString(element.getAttribute("task-id"));
                AbortTaskRequest abortRequest = new AbortTaskRequest(taskId);
                abortRequests.add(abortRequest);
                continue;
            }
            if (element.hasAttribute("transaction-id")) {
                long transactionId = Long.parseLong(element.getAttribute("transaction-id"));
                AbortTransactionRequest abortRequest = new AbortTransactionRequest(transactionId);
                abortRequests.add(abortRequest);
                continue;
            }
            throw new SerializeException("Unsupported abort request", new Object[0]);
        }
        return abortRequests;
    }
}

