/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.core.InvalidLEDException;
import at.mrdevelopment.esl.core.InvalidPageException;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.UnsupportedLEDTypeException;
import at.mrdevelopment.esl.core.UpdateCreationException;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.firmware.FirmwareFileInventory;
import at.mrdevelopment.esl.firmware.FirmwareLoader;
import at.mrdevelopment.esl.flashing.BasicLED;
import at.mrdevelopment.esl.flashing.LabelLED;
import at.mrdevelopment.esl.tasks.AbstractAuxPageTask;
import at.mrdevelopment.esl.tasks.BinaryImageTask;
import at.mrdevelopment.esl.tasks.ErrorTask;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.FirmwareTask;
import at.mrdevelopment.esl.tasks.FlashingTask;
import at.mrdevelopment.esl.tasks.ForceChannelScanTask;
import at.mrdevelopment.esl.tasks.GetConfigTask;
import at.mrdevelopment.esl.tasks.ImageRenderingTask;
import at.mrdevelopment.esl.tasks.InitializeTask;
import at.mrdevelopment.esl.tasks.InternalTask;
import at.mrdevelopment.esl.tasks.PingTask;
import at.mrdevelopment.esl.tasks.QueryCounterTask;
import at.mrdevelopment.esl.tasks.QuerySensorTask;
import at.mrdevelopment.esl.tasks.RebootTask;
import at.mrdevelopment.esl.tasks.RefreshDisplayTask;
import at.mrdevelopment.esl.tasks.ResetAllCountersTask;
import at.mrdevelopment.esl.tasks.ResetCounterTask;
import at.mrdevelopment.esl.tasks.ResetTask;
import at.mrdevelopment.esl.tasks.SetConfigTask;
import at.mrdevelopment.esl.tasks.SwitchPageTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.UnlockLabelTask;
import at.mrdevelopment.esl.tasks.UpdateImageFactory;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.TemplateFileNotFoundException;
import at.mrdevelopment.esl.template.WrongImageSizeException;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.updatetask.AuxPageUpdateTask;
import at.mrdevelopment.esl.updatetask.BasicLEDDurationFlashingUpdateTask;
import at.mrdevelopment.esl.updatetask.BasicLEDRepeatCountFlashingUpdateTask;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.updatetask.FirmwareUpdateTask;
import at.mrdevelopment.esl.updatetask.ForceChannelScanUpdateTask;
import at.mrdevelopment.esl.updatetask.GetConfigUpdateTask;
import at.mrdevelopment.esl.updatetask.ImageUpdateTask;
import at.mrdevelopment.esl.updatetask.InitializeUpdateTask;
import at.mrdevelopment.esl.updatetask.PingUpdateTask;
import at.mrdevelopment.esl.updatetask.QueryCounterUpdateTask;
import at.mrdevelopment.esl.updatetask.QuerySensorUpdateTask;
import at.mrdevelopment.esl.updatetask.RebootUpdateTask;
import at.mrdevelopment.esl.updatetask.RefreshDisplayUpdateTask;
import at.mrdevelopment.esl.updatetask.ResetAllCountersUpdateTask;
import at.mrdevelopment.esl.updatetask.ResetCounterUpdateTask;
import at.mrdevelopment.esl.updatetask.SetConfigUpdateTask;
import at.mrdevelopment.esl.updatetask.SwitchPageUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.updatetask.UnlockLabelUpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.AuxPageData;
import at.mrdevelopment.toolkit.FirmwareImage;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.firmware.Firmware;
import at.mrdevelopment.toolkit.image.ImageSerializationException;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class UpdateTaskFactory {
    static ESLLogger logger = ESLLogger.getLogger(UpdateTaskFactory.class);
    private final UpdateImageFactory updateImageFactory;
    private final boolean allowAllPages;
    private final boolean resetToRegistrationPage;
    private final FirmwareLoader firmwareLoader;
    private final FirmwareFileInventory firmwareFileInventory;

    private static byte[] imageToBytes(BufferedImage image) throws UpdateCreationException {
        try {
            return ImageSerializer.toBytes((BufferedImage)image);
        }
        catch (SerializeException exc) {
            throw new UpdateCreationException(UpdateError.ERROR_CODE_IMAGE_CONVERSION);
        }
    }

    public UpdateTaskFactory(UpdateImageFactory updateImageFactory, boolean allowAllPages, boolean resetToRegistrationPage) throws InitializationException {
        this.updateImageFactory = updateImageFactory;
        this.allowAllPages = allowAllPages;
        this.resetToRegistrationPage = resetToRegistrationPage;
        this.firmwareLoader = new FirmwareLoader();
        this.firmwareFileInventory = new FirmwareFileInventory(this.firmwareLoader, new File("data/firmware"));
    }

    public Task renderImageTask(ImageRenderingTask task) {
        try {
            LabelId labelId = task.getLabelId();
            TaskPriority priority = task.getPriority();
            long externalId = task.getExternalId();
            boolean replaceWaitingTasks = task.isReplaceWaitingTasks();
            BufferedImage image = this.updateImageFactory.createImageFromTask(task);
            Page page = task.getPage();
            boolean preload = task.isPreload();
            boolean skipOnEqualImage = task.isSkipOnEqualImage();
            Integer retryValidInMinutes = task.getRetryValidInMinutes();
            return new BinaryImageTask(labelId, priority, externalId, replaceWaitingTasks, image, page, preload, skipOnEqualImage, retryValidInMinutes);
        }
        catch (Throwable exc) {
            return this.handleError(task, exc);
        }
    }

    public ExternalUpdateTask createUpdateTask(ExecutableTask task, UUID taskId) throws UpdateCreationException {
        Address address = task.getLabelId().toAddress();
        LabelType labelType = task.getLabelId().getLabelType();
        TaskPriority priority = task.getPriority();
        if (task instanceof BinaryImageTask) {
            BinaryImageTask binaryImageTask = (BinaryImageTask)task;
            BufferedImage image = binaryImageTask.getImage();
            Page page = binaryImageTask.getPage();
            boolean preload = binaryImageTask.isPreload();
            if (image == null) {
                throw new UpdateCreationException(UpdateError.ERROR_CODE_RESOURCE_NOT_AVAILABLE, "Image for task %s for label %s not available", new Object[]{taskId.toString(), task.getLabelId().getLabelIdString()});
            }
            this.checkDisplaySize(task.getLabelId(), image.getWidth(), image.getHeight());
            this.checkPage(task.getLabelId(), task.getPage(), false);
            image = this.updateImageFactory.getRenderedImageConverter().convert(task.getLabelId(), image);
            BufferedImage rotatedImage = ImageUtils.rotate((BufferedImage)image, (int)labelType.getImageRotation());
            return new ImageUpdateTask(taskId, address, priority, UpdateTaskFactory.imageToBytes(rotatedImage), page, preload);
        }
        if (task instanceof SwitchPageTask) {
            SwitchPageTask switchPageTask = (SwitchPageTask)task;
            this.checkPage(task.getLabelId(), task.getPage(), true);
            return new SwitchPageUpdateTask(taskId, address, priority, switchPageTask.getPage(), switchPageTask.getDurationInMinutes());
        }
        if (task instanceof QuerySensorTask) {
            QuerySensorTask querySensorTask = (QuerySensorTask)task;
            return new QuerySensorUpdateTask(taskId, address, priority, querySensorTask.getSensors());
        }
        if (task instanceof QueryCounterTask) {
            QueryCounterTask queryCounterTask = (QueryCounterTask)task;
            return new QueryCounterUpdateTask(taskId, address, priority, queryCounterTask.getCounters());
        }
        if (task instanceof RefreshDisplayTask) {
            return new RefreshDisplayUpdateTask(taskId, address, priority);
        }
        if (task instanceof ResetAllCountersTask) {
            return new ResetAllCountersUpdateTask(taskId, address, priority);
        }
        if (task instanceof ResetCounterTask) {
            ResetCounterTask resetCounterTask = (ResetCounterTask)task;
            return new ResetCounterUpdateTask(taskId, address, priority, resetCounterTask.getCounters());
        }
        if (task instanceof GetConfigTask) {
            GetConfigTask getConfigTask = (GetConfigTask)task;
            return new GetConfigUpdateTask(taskId, address, priority, getConfigTask.getConfigs());
        }
        if (task instanceof SetConfigTask) {
            SetConfigTask setConfigTask = (SetConfigTask)task;
            return new SetConfigUpdateTask(taskId, address, priority, setConfigTask.getConfigs());
        }
        if (task instanceof InitializeTask) {
            InitializeTask programKeysTask = (InitializeTask)task;
            return new InitializeUpdateTask(taskId, address, priority, programKeysTask.getKeys());
        }
        if (task instanceof ForceChannelScanTask) {
            ForceChannelScanTask forceChannelScanTask = (ForceChannelScanTask)task;
            return new ForceChannelScanUpdateTask(taskId, address, priority, forceChannelScanTask.isScanAllChannels());
        }
        if (task instanceof RebootTask) {
            return new RebootUpdateTask(taskId, address, priority);
        }
        if (task instanceof PingTask) {
            return new PingUpdateTask(taskId, address, priority);
        }
        if (task instanceof FirmwareTask) {
            FirmwareTask firmwareTask = (FirmwareTask)task;
            FirmwareImage firmwareImage = this.loadFirmwareImage(firmwareTask);
            return new FirmwareUpdateTask(taskId, address, priority, firmwareImage);
        }
        if (task instanceof UnlockLabelTask) {
            UnlockLabelTask unlockLabelTask = (UnlockLabelTask)task;
            Puk puk = unlockLabelTask.getPuk();
            return new UnlockLabelUpdateTask(taskId, address, priority, puk);
        }
        if (task instanceof AbstractAuxPageTask) {
            AbstractAuxPageTask auxPageTask = (AbstractAuxPageTask)task;
            AuxPageData auxPageData = auxPageTask.createAuxPageData();
            return new AuxPageUpdateTask(taskId, address, priority, auxPageData);
        }
        if (task instanceof FlashingTask) {
            FlashingTask flashingTask = (FlashingTask)task;
            this.checkLedSupport(flashingTask.getLabelId(), flashingTask.getLabelLED());
            this.checkLed(flashingTask.getLabelLED());
            if (flashingTask.getLabelLED() instanceof BasicLED) {
                BasicLED basicLed = (BasicLED)flashingTask.getLabelLED();
                int color = basicLed.getColor().getValue();
                int pattern = basicLed.getPattern().getValue();
                return basicLed.getDurationInMinutes() > 0 ? new BasicLEDDurationFlashingUpdateTask(taskId, address, priority, color, pattern, basicLed.getDurationInMinutes()) : new BasicLEDRepeatCountFlashingUpdateTask(taskId, address, priority, color, pattern, basicLed.getRepeatCount());
            }
            throw new InvalidLEDException();
        }
        throw new RuntimeException(String.format("Failed to create update task for unknown task type %s", task.getClass().getSimpleName()));
    }

    public Task convertInternalTask(InternalTask task) {
        if (task instanceof ResetTask) {
            LabelType labelType = task.getLabelId().getLabelType();
            return new SwitchPageTask(task.getLabelId(), task.getPriority(), task.getExternalId(), task.isPreload(), this.resetToRegistrationPage ? labelType.getRegistrationPage() : labelType.getResetPage(), task.getRetryValidInMinutes());
        }
        if (task instanceof ImageRenderingTask) {
            ImageRenderingTask imageRenderingTask = (ImageRenderingTask)task;
            if (!task.getLabelId().getLabelType().isValidForSendingImages()) {
                return new ErrorTask(imageRenderingTask, UpdateError.ERROR_CODE_UNSUPPORTED_LABEL_TYPE);
            }
            return this.renderImageTask(imageRenderingTask);
        }
        return new ErrorTask(task, UpdateError.ERROR_CODE_UNSUPPORTED_TASK);
    }

    public ErrorTask handleError(ImageRenderingTask task, Throwable exc) {
        if (exc instanceof UpdateCreationException) {
            UpdateCreationException updateCreationException = (UpdateCreationException)exc;
            return this.createError(task, updateCreationException.getUpdateError(), exc);
        }
        if (exc instanceof BarcodeException) {
            return this.createError(task, UpdateError.ERROR_CODE_BARCODE_CREATION, exc);
        }
        if (exc instanceof TemplateFileNotFoundException) {
            return this.createError(task, UpdateError.ERROR_CODE_TEMPLATE_NOT_FOUND, exc);
        }
        if (exc instanceof ImageSerializationException) {
            return this.createError(task, UpdateError.ERROR_CODE_INTERNAL, exc);
        }
        if (exc instanceof SerializeException) {
            return this.createError(task, UpdateError.ERROR_CODE_TEMPLATE_PARSING, exc);
        }
        if (exc instanceof InternalError) {
            return this.createError(task, UpdateError.ERROR_CODE_INTERNAL, exc);
        }
        if (exc instanceof UnsupportedOperationException) {
            return this.createError(task, UpdateError.ERROR_CODE_UNSUPPORTED_OPERATION, exc);
        }
        if (exc instanceof IOException) {
            return this.createError(task, UpdateError.ERROR_CODE_IO, exc);
        }
        if (exc instanceof ImageRenderingException) {
            return this.createError(task, UpdateError.ERROR_CODE_IMAGE_RENDERING, exc);
        }
        logger.error("Task to label %s with external ID %d failed with unknown error. See stack trace for details.", new Object[]{task.getLabelId(), task.getExternalId()});
        logger.logException(exc);
        return new ErrorTask(task, UpdateError.ERROR_CODE_UNKNOWN);
    }

    private ErrorTask createError(ImageRenderingTask task, UpdateError updateError, Throwable exc) {
        logger.warn("Task to label %s with external ID %d failed with error code %d: %s", new Object[]{task.getLabelId(), task.getExternalId(), updateError.getCode(), exc.getMessage()});
        logger.logExceptionIfDebugEnabled(exc);
        return new ErrorTask(task, updateError);
    }

    private void checkDisplaySize(LabelId labelId, int width, int height) throws WrongImageSizeException {
        LabelType labelType = labelId.getLabelType();
        if (!(labelType.isUnknown() || labelType.getDisplayWidth() == width && labelType.getDisplayHeight() == height)) {
            throw new WrongImageSizeException();
        }
    }

    private void checkPage(LabelId labelId, Page page, boolean pageSwitch) throws InvalidPageException {
        LabelType labelType = labelId.getLabelType();
        if (!page.isValid()) {
            throw new InvalidPageException();
        }
        if (!this.allowAllPages && pageSwitch && page.getPageIndex() >= labelType.getPageCount()) {
            throw new InvalidPageException();
        }
        if (!this.allowAllPages && !pageSwitch && page.getPageIndex() >= labelType.getAvailablePageCount()) {
            throw new InvalidPageException();
        }
    }

    private void checkLedSupport(LabelId labelId, LabelLED labelLED) throws UnsupportedLEDTypeException {
        LabelType labelType = labelId.getLabelType();
        if (labelLED instanceof BasicLED) {
            if (!labelType.hasHardwareFeatures(LabelType.HardwareFeature.BASIC_LED)) {
                throw new UnsupportedLEDTypeException();
            }
        } else {
            throw new UnsupportedLEDTypeException();
        }
    }

    private void checkLed(LabelLED labelLED) throws InvalidLEDException {
        if (labelLED instanceof BasicLED) {
            BasicLED basicLed = (BasicLED)labelLED;
            int duration = basicLed.getDurationInMinutes();
            int count = basicLed.getRepeatCount();
            if (count < 0 || duration < 0) {
                throw new InvalidLEDException();
            }
            if (count != 0 && duration != 0) {
                throw new InvalidLEDException();
            }
            if (count > 31 || duration > Integer.MAX_VALUE) {
                throw new InvalidLEDException();
            }
        } else {
            throw new InvalidLEDException();
        }
    }

    private FirmwareImage loadFirmwareImage(FirmwareTask firmwareTask) throws UpdateCreationException {
        try {
            if (firmwareTask.isUpdateToLatestFirmware()) {
                LabelType labelType = firmwareTask.getLabelId().getLabelType();
                Firmware firmware = this.firmwareFileInventory.getLatestVersion(labelType);
                if (firmware == null) {
                    throw new UpdateCreationException(UpdateError.ERROR_CODE_FIRMWARE_NOT_FOUND);
                }
                return firmware.getFirmwareImage();
            }
            return firmwareTask.getFirmwareSource().getFirmwareImage();
        }
        catch (IOException exc) {
            logger.logException((Throwable)exc);
            throw new UpdateCreationException(UpdateError.ERROR_CODE_IO, (Throwable)exc);
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
            throw new UpdateCreationException(UpdateError.ERROR_CODE_UNKNOWN, (Throwable)exc);
        }
    }
}

