/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.toolkit.math.MathUtils;
import java.util.UUID;
import org.joda.time.DateTime;

public class UpdateResult {
    private final LabelId labelId;
    private final TaskType taskType;
    private final UUID taskId;
    private final long externalId;
    private final Status status;
    private final Integer errorCode;
    private final Integer accessPointId;
    private final DateTime finishedAt;
    private final PowerStatus powerStatus;
    private final Integer rssi;
    private final Integer lqi;
    private final Integer transmissionTime;

    public UpdateResult(LabelId labelId, TaskType taskType, UUID taskId, long externalId, Status status, Integer errorCode, Integer accessPointId, DateTime finishedAt, PowerStatus powerStatus, Integer rssi, Integer lqi, Integer transmissionTime) {
        this.labelId = labelId;
        this.taskType = taskType;
        this.taskId = taskId;
        this.externalId = externalId;
        this.status = status;
        this.errorCode = errorCode;
        this.accessPointId = accessPointId;
        this.finishedAt = finishedAt;
        this.powerStatus = powerStatus;
        this.rssi = rssi;
        this.lqi = lqi;
        this.transmissionTime = transmissionTime;
    }

    public UpdateResult(LabelId labelId, TaskType taskType, UUID taskId, long externalId, Status status, Integer errorCode, DateTime finishedAt) {
        this(labelId, taskType, taskId, externalId, status, errorCode, null, finishedAt, PowerStatus.UNKNOWN, null, null, null);
    }

    public LabelId getLabelId() {
        return this.labelId;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public UUID getTaskId() {
        return this.taskId;
    }

    public long getExternalId() {
        return this.externalId;
    }

    public boolean hasExternalId() {
        return this.externalId != 0L;
    }

    public Status getStatus() {
        return this.status;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public int getStatusCode() {
        return this.status.getCode() + (this.errorCode != null ? this.errorCode : 0);
    }

    public Integer getAccessPointId() {
        return this.accessPointId;
    }

    public DateTime getFinishedAt() {
        return this.finishedAt;
    }

    public PowerStatus getPowerStatus() {
        return this.powerStatus;
    }

    public Integer getRssi() {
        return this.rssi;
    }

    public Integer getLqi() {
        return this.lqi;
    }

    public Integer getTransmissionTime() {
        return this.transmissionTime;
    }

    public boolean isAssigned() {
        return this.accessPointId != null;
    }

    public int getRFQuality() {
        if (this.rssi == null || this.lqi == null) {
            return 0;
        }
        double lqiValue = MathUtils.limitAndNormalize((double)this.lqi.intValue(), (double)0.0, (double)127.0);
        double rssiValue = MathUtils.limitAndNormalize((double)Math.abs(this.rssi), (double)25.0, (double)95.0);
        return (int)(100.0 - (lqiValue * 50.0 + rssiValue * 50.0));
    }
}

