/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.UpdateError;
import java.util.UUID;
import org.joda.time.DateTime;

public class UpdateInfo {
    private UUID taskId;
    private TaskType taskType;
    private Integer page;
    private Status status;
    private UpdateError updateError;
    private DateTime updatedAt;
    private Boolean internal;

    public static UpdateInfo fromUpdateStatus(UpdateStatus updateStatus) {
        TaskRecord taskRecord = updateStatus.getTaskRecord();
        UUID taskId = updateStatus.getTaskId();
        TaskType taskType = taskRecord.getTaskType();
        Integer page = taskRecord.getPage();
        Status status = updateStatus.getStatus();
        UpdateError updateError = updateStatus.getUpdateError();
        DateTime updatedAt = updateStatus.getUpdatedAt();
        Boolean internal = updateStatus.getInternal();
        return new UpdateInfo(taskId, taskType, page, status, updateError, updatedAt, internal);
    }

    public UpdateInfo() {
    }

    public UpdateInfo(UUID taskId, TaskType taskType, Integer page, Status status, UpdateError updateError, DateTime updatedAt, Boolean internal) {
        this.taskId = taskId;
        this.taskType = taskType;
        this.page = page;
        this.status = status;
        this.updateError = updateError;
        this.updatedAt = updatedAt;
        this.internal = internal;
    }

    @Serialize
    public UUID getTaskId() {
        return this.taskId;
    }

    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    @Displayable(name="Task Type", width=3, order=101)
    @Serialize
    public TaskType getTaskType() {
        return this.taskType;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    @Displayable(name="Page", width=1, filter=false, order=102)
    @Serialize
    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    @Displayable(name="Task Status", width=3, order=103)
    @Serialize
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Serialize
    public Integer getErrorCode() {
        return this.updateError != null ? Integer.valueOf(this.updateError.getCode()) : null;
    }

    public void setErrorCode(Integer errorCode) {
        this.updateError = errorCode != null ? UpdateError.valueOf((int)errorCode) : null;
    }

    @Displayable(name="Error Code", width=1, filter=false, order=104)
    public UpdateError getUpdateError() {
        return this.updateError;
    }

    public void setUpdateError(UpdateError updateError) {
        this.updateError = updateError;
    }

    @Displayable(name="Task Updated At", width=3, filter=false, order=105)
    @Serialize
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Boolean getInternal() {
        return this.internal;
    }

    public void setInternal(Boolean internal) {
        this.internal = internal;
    }
}

