/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.type.ArticleNumber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Matching {
    private final LabelId labelId;
    private final List<ArticleNumber> articleNumbers;
    private final String template;

    public static Matching newEmptyMatching(LabelId labelId) {
        return new Matching(labelId, null, null);
    }

    public Matching(LabelId labelId, Collection<ArticleNumber> articleNumbers, String template) {
        this.labelId = labelId;
        this.articleNumbers = articleNumbers != null ? new ArrayList<ArticleNumber>(articleNumbers) : new ArrayList();
        this.template = template;
    }

    public LabelId getLabelId() {
        return this.labelId;
    }

    public Collection<ArticleNumber> getArticleNumbers() {
        return Collections.unmodifiableCollection(this.articleNumbers);
    }

    public ArticleNumber getArticleNumber(int index) {
        return this.articleNumbers.get(index);
    }

    public String getArticleNumbersString() {
        return this.articleNumbers.isEmpty() ? null : StringUtils.join(this.articleNumbers, (String)",");
    }

    public String getTemplate() {
        return this.template;
    }

    public boolean isMultiMatching() {
        return this.articleNumbers.size() > 1;
    }

    public boolean isEmptyMatching() {
        return this.articleNumbers.isEmpty();
    }

    public String toString() {
        return "Matching [labelId=" + this.labelId + ", template=" + this.template + ", articleCount=" + this.articleNumbers.size() + "]";
    }
}

