/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Gtin;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class Article {
    static ESLLogger logger = ESLLogger.getLogger(Article.class);
    private final ArticleNumber articleNumber;
    private final Set<Gtin> gtins;
    private final Map<String, String> fields;

    public static Collection<ArticleNumber> getArticleNumbers(Iterable<Article> articles) {
        return Lists.newArrayList((Iterable)Iterables.transform(articles, (Function)new Function<Article, ArticleNumber>(){

            public ArticleNumber apply(Article input) {
                return input.articleNumber;
            }
        }));
    }

    public static String getArticleNumbersString(Iterable<Article> articles) {
        return StringUtils.join((Collection)Lists.newArrayList((Iterable)Iterables.transform(articles, (Function)new Function<Article, ArticleNumber>(){

            public ArticleNumber apply(Article input) {
                return input.articleNumber;
            }
        })), (String)",");
    }

    public Article(ArticleNumber articleNumber) {
        this(articleNumber, new HashSet<Gtin>(), new HashMap<String, String>());
    }

    public Article(ArticleNumber articleNumber, Set<Gtin> gtins, Map<String, String> fields) {
        this.articleNumber = articleNumber;
        this.gtins = new HashSet<Gtin>(gtins);
        this.fields = new HashMap<String, String>(fields);
    }

    public ArticleNumber getArticleNumber() {
        return this.articleNumber;
    }

    public Set<Gtin> getGtins() {
        return Collections.unmodifiableSet(this.gtins);
    }

    public Map<String, String> getValues() {
        return Collections.unmodifiableMap(this.fields);
    }

    public String getValue(String key) {
        return this.fields.get(key);
    }

    public int getFieldsCount() {
        return this.fields.size();
    }

    public List<String> getFieldsAsSortedStringList() {
        ArrayList<String> fieldsList = new ArrayList<String>(this.fields.size());
        TreeMap<String, String> fieldsSorted = new TreeMap<String, String>(this.fields);
        for (Map.Entry field : fieldsSorted.entrySet()) {
            fieldsList.add(String.format("%s=%s", field.getKey(), field.getValue()));
        }
        return fieldsList;
    }

    public boolean isEqual(Article other) {
        if (other == null) {
            logger.info("Article to compare is null");
            return false;
        }
        if (!this.articleNumber.equals((Object)other.articleNumber)) {
            logger.info("Article numbers not equal");
            return false;
        }
        if (this.gtins.size() != other.gtins.size()) {
            logger.info("Number of GTINs not equal");
            return false;
        }
        if (this.fields.size() != other.fields.size()) {
            logger.info("Number of fields not equal");
            return false;
        }
        if (!((Object)this.gtins).equals(other.gtins)) {
            logger.info("GTINs not equal");
            return false;
        }
        if (!((Object)this.fields).equals(other.fields)) {
            logger.info("Fields not equal");
            return false;
        }
        return true;
    }
}

