/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import java.util.HashMap;
import java.util.Map;

public enum AccessPointUpdateError {
    ERROR_CODE_UNREGISTERED(3, "Access Point not registered"),
    ERROR_CODE_RESOURCE_NOT_AVAILABLE(94, "A required resource is not available"),
    ERROR_CODE_UNSUPPORTED_OPERATION(98, "Operation not supported"),
    ERROR_CODE_UNKNOWN(99, "Unknown error");

    private static final Map<Integer, AccessPointUpdateError> errorsByCode;
    private final int code;
    private final boolean clearRetries;
    private final String description;

    private AccessPointUpdateError(int code, String description) {
        this(code, true, description);
    }

    private AccessPointUpdateError(int code, boolean clearRetries, String description) {
        this.code = code;
        this.clearRetries = clearRetries;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isClearRetries() {
        return this.clearRetries;
    }

    public String getDescription() {
        return this.description;
    }

    public static AccessPointUpdateError valueOf(int errorCode) {
        AccessPointUpdateError updateError = errorsByCode.get(errorCode);
        return updateError != null ? updateError : ERROR_CODE_UNKNOWN;
    }

    static {
        errorsByCode = new HashMap<Integer, AccessPointUpdateError>();
        for (AccessPointUpdateError updateError : AccessPointUpdateError.values()) {
            errorsByCode.put(updateError.code, updateError);
        }
    }
}

