/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.table;

import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.esl.template.TextRenderingElement;
import at.mrdevelopment.esl.template.table.TableDataMetric;
import at.mrdevelopment.esl.template.table.TableMetrics;
import at.mrdevelopment.esl.template.table.TableRowField;
import at.mrdevelopment.esl.template.table.TableRowMetric;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.TableRenderingStringElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@TemplateElementType(type=TemplateNode.TABLE)
public class TableField
extends Element
implements TextRenderingElement {
    private List<TableRowField> tableRowFields = new ArrayList<TableRowField>();
    private final int tableBorder;
    private final Color borderColor;
    private final Color backgroundColor;
    private int width;
    private int height;
    private final int cellpadding;
    private Rectangle tableBounds = null;
    private final int headerBorder;
    private final boolean headerRow;
    private final boolean headerColumn;

    public TableField(Map<String, Option<?>> options) throws OptionException {
        super(options);
        this.width = options.containsKey(Attribute.FIELD_WIDTH.getKey()) && options.get(Attribute.FIELD_WIDTH.getKey()).get() != null ? (Integer)options.get(Attribute.FIELD_WIDTH.getKey()).get() : -1;
        int n = this.height = options.containsKey(Attribute.FIELD_HEIGHT.getKey()) && options.get(Attribute.FIELD_HEIGHT.getKey()).get() != null ? (Integer)options.get(Attribute.FIELD_HEIGHT.getKey()).get() : -1;
        if (this.height < 0) {
            this.height = options.containsKey(Attribute.MAX_HEIGHT.getKey()) && options.get(Attribute.MAX_HEIGHT.getKey()).get() != null ? (Integer)options.get(Attribute.MAX_HEIGHT.getKey()).get() : -1;
        }
        this.tableBorder = (Integer)options.get(Attribute.TABLE_BORDER.getKey()).get();
        this.headerBorder = (Integer)options.get(Attribute.HEADER_BORDER.getKey()).get();
        this.headerRow = (Boolean)options.get(Attribute.HEADER_ROW.getKey()).get();
        this.headerColumn = (Boolean)options.get(Attribute.HEADER_COLUMN.getKey()).get();
        this.borderColor = (Color)options.get(Attribute.BORDER_COLOR.getKey()).get();
        this.backgroundColor = (Color)options.get(Attribute.BACKGROUND_COLOR.getKey()).get();
        this.cellpadding = (Integer)options.get(Attribute.CELL_PADDING.getKey()).get();
        if ((this.headerColumn || this.headerRow) && this.headerBorder < this.tableBorder) {
            throw new OptionException("The option header-border is not allowed to be smaller than table-border.");
        }
    }

    @Override
    public RenderingResult render(int maxWidth, int maxHeight, boolean verbose) {
        ExecutionStatus status = new ExecutionStatus();
        boolean successful = true;
        if (this.width > maxWidth || this.height > maxHeight) {
            successful = false;
            status.addElement((ExecutionStatusElement)new TableRenderingStringElement(String.format("Table width (%d) and/or height (%d) is not within the field width (%d) and/or height (%d)", this.width, this.height, maxWidth, maxHeight), 0));
            this.width = this.width > maxWidth ? maxWidth : this.width;
            this.height = this.height > maxHeight ? maxHeight : this.height;
        }
        TableMetrics tableMetrics = new TableMetrics(this, this.getOptions(), maxWidth, maxHeight);
        BufferedImage image = ImageUtils.createImage((int)tableMetrics.getTableWidth(), (int)tableMetrics.getTableHeight(), (int)2);
        ImageUtils.fillRect((BufferedImage)image, (int)0, (int)0, (int)maxWidth, (int)maxHeight, (Paint)this.getBackgroundColor());
        status.addExecutionStatus(tableMetrics.getStatus());
        for (int index = 0; index < this.tableRowFields.size(); ++index) {
            RenderingResult renderingResult;
            TableRowField tableRowField = this.tableRowFields.get(index);
            if (this.isHeaderRow() && index > 0 && tableRowField.getTableDataFields().size() == this.tableRowFields.get(0).getTableDataFields().size()) {
                for (int columnIndex = 0; columnIndex < tableRowField.getTableDataFields().size(); ++columnIndex) {
                    int offset;
                    TableDataMetric tableDataMetric = tableMetrics.getTableRowMetric(index).getTableDataMetrics().get(columnIndex);
                    if (!this.isHeaderColumn() && columnIndex > 0 || this.isHeaderColumn() && columnIndex > 1) {
                        offset = this.getHeaderBorder() / 2 + this.getTableBorder() / 2;
                        tableDataMetric.setXPos(tableMetrics.getTableRowMetric(0).getTableDataMetrics().get(columnIndex).getXPos() - this.getHeaderBorder() / 2 + this.getTableBorder() / 2);
                        tableDataMetric.setBorderOffset(tableDataMetric.getBorderOffset() - offset);
                    } else if (this.isHeaderColumn() && columnIndex == 1) {
                        tableDataMetric.setXPos(tableMetrics.getTableRowMetric(index - 1).getTableDataMetrics().get(columnIndex).getXPos());
                    } else if (columnIndex == 0) {
                        if (this.isHeaderColumn()) {
                            tableDataMetric.setBorderOffset(tableMetrics.getTableRowMetric(index - 1).getTableDataMetrics().get(columnIndex).getBorderOffset());
                            tableDataMetric.setXPos(tableMetrics.getTableRowMetric(index - 1).getTableDataMetrics().get(columnIndex).getXPos());
                        } else {
                            offset = this.getHeaderBorder() / 2 + this.getTableBorder() / 2;
                            tableDataMetric.setBorderOffset(tableDataMetric.getBorderOffset() - offset);
                        }
                    }
                    if (columnIndex != tableRowField.getTableDataFields().size() - 1) continue;
                    int effectiveWidth = maxWidth - tableDataMetric.getXPos() - this.getTableBorder();
                    tableDataMetric.setBorderOffset(tableDataMetric.getBorderOffset() + (tableDataMetric.getEffectiveWidth() - effectiveWidth));
                }
            }
            TableRowMetric tableRowMetric = tableMetrics.getTableRowMetrics().get(index);
            tableRowField.setTableMetrics(tableMetrics);
            int rowHeight = tableMetrics.getTableRowMetric(index).getHeight();
            if (rowHeight <= 0) {
                rowHeight = tableMetrics.getRemainingHeight();
            }
            successful = !(renderingResult = tableRowField.render(maxWidth, rowHeight, verbose)).isSuccessful() ? false : successful;
            status.addExecutionStatus(renderingResult.getStatus());
            Rectangle rowBounds = renderingResult.getBounds();
            if (rowBounds == null || rowBounds.isEmpty()) continue;
            tableMetrics.setEffectiveTableRowHeight(index, rowBounds.height);
            if (this.tableBounds == null) {
                this.tableBounds = new Rectangle(tableMetrics.getTableWidth(), rowBounds.height);
            } else {
                this.tableBounds.height += rowBounds.height;
            }
            ImageUtils.overlayAt((BufferedImage)image, (BufferedImage)renderingResult.getImage(), (int)0, (int)tableMetrics.getTableRowYPos(index));
            if (tableMetrics.getTableRowHeights().get(index) > 0) continue;
            tableMetrics.setRemainingHeight(tableMetrics.getRemainingHeight() - (rowBounds.height + tableRowMetric.getMaxTopBorder()));
        }
        image = ImageUtils.clipToUsedSize((BufferedImage)image, (Rectangle)this.tableBounds, (int)maxWidth, (int)maxHeight);
        this.tableBounds = new Rectangle(tableMetrics.getTableWidth(), this.tableBounds != null ? this.tableBounds.height : image.getHeight());
        return new RenderingResult(image, status, this.tableBounds, successful);
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Arrays.asList(Attribute.FIELD_WIDTH);
    }

    public void addTableRow(TableRowField tableRowField) {
        this.tableRowFields.add(tableRowField);
    }

    public boolean isHeaderRow() {
        return this.headerRow;
    }

    public boolean isHeaderColumn() {
        return this.headerColumn;
    }

    public int getHeaderBorder() {
        return this.headerBorder;
    }

    public int getTableBorder() {
        return this.tableBorder;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public List<TableRowField> getTableRowFields() {
        return this.tableRowFields;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getCellpadding() {
        return this.cellpadding;
    }

    @Override
    public Rectangle getAlignmentBounds() {
        return this.tableBounds;
    }
}

