/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.table;

import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.esl.template.TextFieldContainer;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.RenderingStringElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.image.VerticalAlignment;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.Size;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@TemplateElementType(type=TemplateNode.TABLE_DATA)
public class TableDataField
extends Element
implements RenderingElement {
    private final TextFieldContainer textFieldContainer;
    private final Paint backgroundColor;
    private Size width;
    private Size height;
    private final int cellpadding;
    private final VerticalAlignment valign;

    public TableDataField(Map<String, Option<?>> options, TextFieldContainer textFieldContainer, int border, Paint borderColor, Paint backgroundColor) throws OptionException {
        super(options);
        this.width = options.containsKey(Attribute.TABLE_WIDTH.getKey()) && options.get(Attribute.TABLE_WIDTH.getKey()).get() != null ? (Size)options.get(Attribute.TABLE_WIDTH.getKey()).get() : new Size("-1");
        this.height = options.containsKey(Attribute.TABLE_HEIGHT.getKey()) && options.get(Attribute.TABLE_HEIGHT.getKey()).get() != null ? (Size)options.get(Attribute.TABLE_HEIGHT.getKey()).get() : new Size("-1");
        this.textFieldContainer = textFieldContainer;
        this.backgroundColor = backgroundColor;
        this.cellpadding = (Integer)options.get(Attribute.CELL_PADDING.getKey()).get();
        this.valign = (VerticalAlignment)options.get(Attribute.VERTICAL_ALIGNMENT.getKey()).get();
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Collections.emptyList();
    }

    public TextFieldContainer getTextFieldContainer() {
        return this.textFieldContainer;
    }

    @Override
    public RenderingResult render(int maxWidth, int maxHeight, boolean verbose) {
        ExecutionStatus status = new ExecutionStatus();
        if (maxWidth <= 0 || maxHeight <= 0) {
            status.addElement((ExecutionStatusElement)new RenderingStringElement(String.format("No space left for table cell (%s)", this.getTextFieldContainer().getText()), ExecutionStatusElement.ErrorLevel.WARNING));
            return new RenderingResult(null, status, null, false);
        }
        BufferedImage image = ImageUtils.createImage((int)maxWidth, (int)maxHeight, (int)2);
        ImageUtils.fillRect((BufferedImage)image, (int)0, (int)0, (int)maxWidth, (int)maxHeight, (Paint)this.backgroundColor);
        RenderingResult renderingResult = this.textFieldContainer.render(maxWidth, maxHeight, verbose);
        ImageUtils.overlayAt((BufferedImage)image, (BufferedImage)renderingResult.getImage(), (int)0, (int)0);
        if (!renderingResult.getBounds().isEmpty()) {
            image = ImageUtils.clipToUsedSize((BufferedImage)image, (Rectangle)renderingResult.getBounds(), (int)maxWidth, (int)maxHeight);
        }
        status.addExecutionStatus(renderingResult.getStatus());
        return new RenderingResult(image, status, renderingResult.getBounds(), renderingResult.isSuccessful());
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.valign;
    }

    public Size getWidth() {
        return this.width;
    }

    public Size getHeight() {
        return this.height;
    }

    public int getCellpadding() {
        return this.cellpadding;
    }
}

