/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.core.LabelTagsLookup;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.WebserviceDatasetRegistry;
import at.mrdevelopment.esl.persistence.dataset.NoTransaction;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.WebserviceDataset;
import at.mrdevelopment.esl.persistence.record.FontRecord;
import at.mrdevelopment.esl.service.ServiceClient;
import at.mrdevelopment.esl.tasks.EnvironmentSource;
import at.mrdevelopment.esl.tasks.TemplateTask;
import at.mrdevelopment.esl.tasks.TemplateXMLTask;
import at.mrdevelopment.esl.template.ESLImage;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.xml.transform.dom.DOMSource;
import org.apache.http.client.ClientProtocolException;

public class RemoteUpdateImageFactory {
    private final ServiceClient serviceClient;
    private final WebserviceDataset<FontRecord> fontDataset;
    private final ServiceAddress serviceAddress;

    public RemoteUpdateImageFactory(ServiceAddress serviceAddress) throws InitializationException, MalformedURLException {
        this.serviceAddress = serviceAddress;
        this.serviceClient = new ServiceClient(serviceAddress);
        if (!serviceAddress.hasCredentials()) {
            this.serviceClient.setCredentials("admin", "admin");
        }
        WebserviceDatasetRegistry datasetRegistry = new WebserviceDatasetRegistry(this.serviceClient.getHttpServiceClient());
        this.fontDataset = datasetRegistry.registerDataset(FontRecord.class);
    }

    public ESLImage createFromTemplateTask(TemplateTask templateTask, ExecutionStatus executionStatus, boolean debug, boolean verbose) throws SerializeException, ImageRenderingException {
        try {
            return new ESLImage(this.serviceClient.queryRenderingImagePreview((TemplateXMLTask)templateTask), executionStatus, verbose);
        }
        catch (WebserviceException exc) {
            executionStatus.addElement((ExecutionStatusElement)new ExceptionElement((Exception)((Object)this.extractException(exc))));
            return new ESLImage(null, executionStatus, verbose);
        }
    }

    public DOMSource buildRecordSource(TemplateTask templateTask) throws ImageRenderingException {
        try {
            return new DOMSource(this.serviceClient.queryRenderingSourcePreview((TemplateXMLTask)templateTask));
        }
        catch (SerializeException exc) {
            throw new ImageRenderingException(exc);
        }
        catch (WebserviceException exc) {
            throw this.extractException(exc);
        }
    }

    public DOMSource buildImageRenderingSource(TemplateTask templateTask, EnvironmentSource environmentSource, LabelTagsLookup labelTagsLookup) throws SerializeException, ImageRenderingException {
        try {
            return new DOMSource(this.serviceClient.queryRenderingImageDocumentPreview((TemplateXMLTask)templateTask));
        }
        catch (WebserviceException exc) {
            throw this.extractException(exc);
        }
    }

    public DOMSource buildImageRenderingSource(TemplateTask templateTask) throws SerializeException, ImageRenderingException {
        return this.buildImageRenderingSource(templateTask, null, null);
    }

    private ImageRenderingException extractException(WebserviceException exception) {
        if (exception.getCause() != null && exception.getCause() instanceof ClientProtocolException) {
            if (exception.getCause().getCause() != null) {
                return new ImageRenderingException(exception.getCause().getCause());
            }
            return new ImageRenderingException(exception.getCause());
        }
        return new ImageRenderingException(exception);
    }

    public Collection<String> queryFonts() throws WebserviceException {
        try {
            this.fontDataset.reload((Transaction<?>)NoTransaction.get()).waitUntilFinished();
            List<FontRecord> fonts = this.fontDataset.queryAll((Transaction<?>)NoTransaction.get());
            return Collections2.transform(fonts, (Function)new Function<FontRecord, String>(){

                public String apply(FontRecord fontRecord) {
                    return fontRecord.getName();
                }
            });
        }
        catch (CancellationException exc) {
            throw new WebserviceException((Throwable)exc);
        }
        catch (DatasetException exc) {
            throw new WebserviceException((Throwable)exc);
        }
        catch (InterruptedException exc) {
            throw new WebserviceException((Throwable)exc);
        }
        catch (ExecutionException exc) {
            throw new WebserviceException((Throwable)exc);
        }
    }

    public ServiceAddress getServiceAddress() {
        return this.serviceAddress;
    }
}

