/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.PolygonDrawingElement;
import at.mrdevelopment.esl.template.PolygonRenderingElement;
import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.BorderStyle;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

@TemplateElementType(type=TemplateNode.POLYGON)
public class PolygonElement
extends Element
implements PolygonDrawingElement {
    private Paint color;
    private Integer border;
    private Paint borderColor;
    private Boolean fill;
    private Polygon polygon;
    private PolygonRenderingElement renderingElement;
    private BorderStyle borderStyle;

    public PolygonElement(Map<String, Option<?>> options) throws OptionException {
        super(options);
        this.color = (Paint)options.get(Attribute.COLOR.getKey()).get();
        this.border = (Integer)options.get(Attribute.BORDER.getKey()).get();
        this.borderColor = (Paint)options.get(Attribute.BORDER_COLOR.getKey()).get();
        this.borderStyle = (BorderStyle)options.get(Attribute.BORDER_STYLE.getKey()).get();
        this.fill = (Boolean)options.get(Attribute.FILL.getKey()).get();
        Point[] pointsArray = (Point[])options.get(Attribute.POINTS.getKey()).get();
        int[] xPositions = new int[pointsArray.length];
        int[] yPositions = new int[pointsArray.length];
        for (int index = 0; index < pointsArray.length; ++index) {
            xPositions[index] = pointsArray[index].x;
            yPositions[index] = pointsArray[index].y;
        }
        this.polygon = new Polygon(xPositions, yPositions, xPositions.length);
        this.renderingElement = new PolygonRenderingElement(this);
    }

    @Override
    public RenderingElement getRenderingElement() {
        return this.renderingElement;
    }

    @Override
    public Polygon getPolygon() {
        return this.polygon;
    }

    @Override
    public Paint getColor() {
        return this.color;
    }

    @Override
    public Rectangle getBounds() {
        return this.polygon.getBounds();
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Arrays.asList(Attribute.POINTS);
    }

    @Override
    public int getBorder() {
        return this.border;
    }

    @Override
    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    @Override
    public boolean hasBorder() {
        return this.border > 0;
    }

    @Override
    public Paint getBorderColor() {
        return this.borderColor;
    }

    @Override
    public boolean isFilled() {
        return this.fill;
    }
}

