/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.Pair;
import at.mrdevelopment.esl.template.BarcodeField;
import at.mrdevelopment.esl.template.DrawingElement;
import at.mrdevelopment.esl.template.Ellipse;
import at.mrdevelopment.esl.template.Field;
import at.mrdevelopment.esl.template.FieldOutOfBoundsException;
import at.mrdevelopment.esl.template.ImageField;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.ImageTemplate;
import at.mrdevelopment.esl.template.LabelField;
import at.mrdevelopment.esl.template.Line;
import at.mrdevelopment.esl.template.PolygonElement;
import at.mrdevelopment.esl.template.Rect;
import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.esl.template.TemplateTree;
import at.mrdevelopment.esl.template.TemplateTreeNode;
import at.mrdevelopment.esl.template.TextField;
import at.mrdevelopment.esl.template.TextFieldContainer;
import at.mrdevelopment.esl.template.Triangle;
import at.mrdevelopment.esl.template.css.CSSInterpreter;
import at.mrdevelopment.esl.template.table.TableDataField;
import at.mrdevelopment.esl.template.table.TableField;
import at.mrdevelopment.esl.template.table.TableRowField;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.TemplateDefinitionTree;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.DitheringThreshold;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.string.CustomStringTokenizer;
import at.mrdevelopment.toolkit.text.LineWrap;
import at.mrdevelopment.toolkit.text.ListElement;
import at.mrdevelopment.toolkit.text.ListItem;
import at.mrdevelopment.toolkit.text.OrderedListElement;
import at.mrdevelopment.toolkit.text.SingleLineSpan;
import at.mrdevelopment.toolkit.text.SingleLineWord;
import at.mrdevelopment.toolkit.text.Span;
import at.mrdevelopment.toolkit.text.TextElement;
import at.mrdevelopment.toolkit.text.UnorderedListElement;
import at.mrdevelopment.toolkit.text.Word;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageXMLSerializer
implements XMLSerializer<ImageTemplate> {
    static ESLLogger logger = ESLLogger.getLogger(ImageXMLSerializer.class);
    private static final String XSD = "image.xsd";
    private final XMLToolkit xmlToolkit;
    private final CustomStringTokenizer customStringTokenizer;
    private Map<TemplateNode, Integer> templateNodeCounts = new HashMap<TemplateNode, Integer>();
    private CSSInterpreter cssInterpreter;

    public ImageXMLSerializer(boolean useSecureProcessing) throws InitializationException {
        this.xmlToolkit = new XMLToolkit(XSD, useSecureProcessing);
        this.customStringTokenizer = new CustomStringTokenizer();
        this.cssInterpreter = new CSSInterpreter();
    }

    public DOMSource transformTemplate(Source xsltSource, Source xmlSource) throws SerializeException {
        DOMResult result = new DOMResult();
        this.xmlToolkit.transform(xsltSource, xmlSource, (Result)result);
        return new DOMSource(result.getNode());
    }

    public ImageTemplate parseImage(File workingDirectory, DOMSource imageSource) throws SerializeException, ImageRenderingException {
        return this.parseImage(workingDirectory, imageSource, null);
    }

    public ImageTemplate parseImage(File workingDirectory, DOMSource imageSource, ExecutionStatus executionStatus) throws SerializeException, ImageRenderingException {
        Element root = this.xmlToolkit.getDocumentRoot(imageSource);
        return this.parseImage(root, workingDirectory, executionStatus);
    }

    public ImageTemplate parseImage(Element root, File workingDirectory, ExecutionStatus executionStatus) throws SerializeException, ImageRenderingException {
        if (root == null) {
            throw new SerializeException("Document cannot be empty", new Object[0]);
        }
        this.templateNodeCounts.clear();
        TemplateDefinitionTree.TemplateDefinitionNode rootTemplateNode = TemplateDefinitionTree.getTree().getRoot();
        Pair<Map<String, Option<?>>, Map<String, Option<?>>> parentOptions = this.parseOptions(rootTemplateNode.getTemplateNode(), root, new HashMap(), executionStatus);
        TemplateTree templateTree = new TemplateTree(new TemplateTreeNode(TemplateNode.ROOT_IMAGE, (Map)parentOptions.getFirst(), null, root));
        NodeList childNodes = root.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < childNodes.getLength(); ++nodeIndex) {
            if (childNodes.item(nodeIndex).getNodeType() != 1) continue;
            for (int i = 0; i < rootTemplateNode.getChilds().size(); ++i) {
                TemplateDefinitionTree.TemplateDefinitionNode childDefinitionNode = (TemplateDefinitionTree.TemplateDefinitionNode)rootTemplateNode.getChilds().get(i);
                if (!childDefinitionNode.getTemplateNode().getKey().equals(childNodes.item(nodeIndex).getNodeName())) continue;
                this.parseChilds(childDefinitionNode, (Element)childNodes.item(nodeIndex), (Map)parentOptions.getSecond(), templateTree.getRoot(), executionStatus);
            }
        }
        this.applyCSS(root, templateTree, workingDirectory, executionStatus);
        try {
            return this.parseImageTemplate(templateTree, workingDirectory, executionStatus);
        }
        catch (OptionException exc) {
            throw new ImageRenderingException(exc);
        }
    }

    private ImageTemplate parseImageTemplate(TemplateTree templateTree, File workingDirectory, ExecutionStatus executionStatus) throws OptionException {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<DrawingElement> drawingElements = new ArrayList<DrawingElement>();
        Map<String, Option<?>> rootOptions = templateTree.getRoot().getOptions();
        if (rootOptions.get(Attribute.WIDTH.getKey()).get() == null || rootOptions.get(Attribute.HEIGHT.getKey()).get() == null) {
            throw new OptionException("Attributes width and height have to be set in root image");
        }
        int width = (Integer)rootOptions.get(Attribute.WIDTH.getKey()).get();
        int height = (Integer)rootOptions.get(Attribute.HEIGHT.getKey()).get();
        int rotation = (Integer)rootOptions.get(Attribute.ROTATION.getKey()).get();
        boolean invert = (Boolean)rootOptions.get(Attribute.INVERT.getKey()).get();
        Color backgroundColor = (Color)rootOptions.get(Attribute.BACKGROUND_COLOR.getKey()).get();
        String backgroundImagePath = rootOptions.get(Attribute.BACKGROUND_IMAGE.getKey()).get() != null ? (String)rootOptions.get(Attribute.BACKGROUND_IMAGE.getKey()).get() : null;
        Integer clipWidth = (Integer)rootOptions.get(Attribute.CLIP_WIDTH.getKey()).get();
        Integer clipHeight = (Integer)rootOptions.get(Attribute.CLIP_HEIGHT.getKey()).get();
        Integer clipX = (Integer)rootOptions.get(Attribute.CLIP_X.getKey()).get();
        Integer clipY = (Integer)rootOptions.get(Attribute.CLIP_Y.getKey()).get();
        boolean useColors = (Boolean)rootOptions.get(Attribute.COLORS.getKey()).get();
        boolean ditheringEnabled = (Boolean)rootOptions.get(Attribute.DITHERING.getKey()).get();
        DitheringThreshold ditheringThreshold = rootOptions.get(Attribute.DITHERING_THRESHOLD.getKey()).get() != null ? (DitheringThreshold)rootOptions.get(Attribute.DITHERING_THRESHOLD.getKey()).get() : null;
        Rectangle clippingRegion = null;
        if (clipWidth != null && clipHeight != null && clipX != null && clipY != null) {
            clippingRegion = new Rectangle(clipX, clipY, clipWidth, clipHeight);
        }
        if (backgroundImagePath != null) {
            backgroundImagePath = FilenameUtils.concat((String)workingDirectory.getAbsolutePath(), (String)backgroundImagePath);
        }
        File backgroundImageFile = backgroundImagePath != null ? new File(backgroundImagePath) : null;
        int currentField = 0;
        for (TemplateTreeNode treeNode : templateTree.getRoot().getChilds()) {
            try {
                if (treeNode.getTemplateNode().equals((Object)TemplateNode.FIELD)) {
                    fields.add(this.parseField(null, treeNode, workingDirectory, width, height, executionStatus));
                } else if (treeNode.getTemplateNode().equals((Object)TemplateNode.LINE)) {
                    drawingElements.add(this.parseLine(treeNode));
                } else if (treeNode.getTemplateNode().equals((Object)TemplateNode.RECT)) {
                    drawingElements.add(this.parseRect(treeNode));
                } else if (treeNode.getTemplateNode().equals((Object)TemplateNode.TRIANGLE)) {
                    drawingElements.add(this.parseTriangle(treeNode));
                } else if (treeNode.getTemplateNode().equals((Object)TemplateNode.ELLIPSE)) {
                    drawingElements.add(this.parseEllipse(treeNode));
                } else if (treeNode.getTemplateNode().equals((Object)TemplateNode.POLYGON)) {
                    drawingElements.add(this.parsePolygon(treeNode));
                }
            }
            catch (OptionException exc) {
                exc.setFieldId(currentField);
                throw exc;
            }
            ++currentField;
        }
        return new ImageTemplate(templateTree, backgroundColor, backgroundImageFile, width, height, rotation, clippingRegion, invert, useColors, ditheringEnabled, ditheringThreshold, fields, drawingElements);
    }

    private void applyCSS(Element root, TemplateTree templateTree, File workingDirectory, ExecutionStatus executionStatus) {
        block10: {
            NodeList cssNodeList = root.getElementsByTagName("css");
            if (cssNodeList.getLength() > 0) {
                for (int index = 0; index < cssNodeList.getLength(); ++index) {
                    Element cssElement = (Element)cssNodeList.item(index);
                    if (!cssElement.hasAttribute("href")) continue;
                    try {
                        this.cssInterpreter.interpret(templateTree, FilenameUtils.concat((String)workingDirectory.getAbsolutePath(), (String)cssElement.getAttribute("href")));
                        continue;
                    }
                    catch (FileNotFoundException exc) {
                        if (logger.isDebugEnabled()) {
                            logger.warn("Cannot find referenced CSS file in %s", new Object[]{workingDirectory.getAbsolutePath()});
                            logger.logException((Throwable)exc);
                        }
                        if (executionStatus == null) continue;
                        executionStatus.addElement((ExecutionStatusElement)new ExceptionElement((Exception)exc));
                        continue;
                    }
                    catch (IOException exc) {
                        if (logger.isDebugEnabled()) {
                            logger.warn("Exception during loading css file in %s", new Object[]{workingDirectory.getAbsolutePath()});
                            logger.logException((Throwable)exc);
                        }
                        if (executionStatus == null) continue;
                        executionStatus.addElement((ExecutionStatusElement)new ExceptionElement((Exception)exc));
                    }
                }
                try {
                    templateTree.propagateOptions();
                }
                catch (OptionException exc) {
                    if (logger.isDebugEnabled()) {
                        logger.warn("Error propagating options after CSS interpretation.");
                        logger.logException((Throwable)exc);
                    }
                    if (executionStatus == null) break block10;
                    executionStatus.addElement((ExecutionStatusElement)new ExceptionElement((Exception)((Object)exc)));
                }
            }
        }
    }

    private Triangle parseTriangle(TemplateTreeNode treeNode) throws OptionException {
        return this.createTriangle(treeNode.getOptions());
    }

    private Rect parseRect(TemplateTreeNode treeNode) throws OptionException {
        return this.createRect(treeNode.getOptions());
    }

    private Line parseLine(TemplateTreeNode treeNode) throws OptionException {
        return this.createLine(treeNode.getOptions());
    }

    private Ellipse parseEllipse(TemplateTreeNode treeNode) throws OptionException {
        return this.createEllipse(treeNode.getOptions());
    }

    private PolygonElement parsePolygon(TemplateTreeNode treeNode) throws OptionException {
        return this.createPolygon(treeNode.getOptions());
    }

    private Field parseField(Field parentField, TemplateTreeNode treeNode, File workingDirectory, int width, int height, ExecutionStatus executionStatus) throws OptionException {
        Map<String, Option<?>> fieldOptions = treeNode.getOptions();
        RenderingElement renderingElement = null;
        Field field = new Field(parentField, fieldOptions);
        for (TemplateTreeNode templateTreeNode : treeNode.getChilds()) {
            if (renderingElement == null) {
                if (templateTreeNode.getTemplateNode().equals((Object)TemplateNode.IMAGE)) {
                    renderingElement = this.parseImageField(templateTreeNode.getOptions(), workingDirectory);
                } else if (templateTreeNode.getTemplateNode().equals((Object)TemplateNode.TEXT) || treeNode.getChilds().get(0).getTemplateNode().equals((Object)TemplateNode.LABEL)) {
                    renderingElement = this.parseTextFields(width, height, treeNode, workingDirectory);
                } else if (templateTreeNode.getTemplateNode().equals((Object)TemplateNode.TABLE)) {
                    renderingElement = this.parseTableField(templateTreeNode, width, height, workingDirectory);
                } else if (templateTreeNode.getTemplateNode().equals((Object)TemplateNode.BARCODE)) {
                    try {
                        renderingElement = this.parseBarcodeField(templateTreeNode);
                    }
                    catch (BarcodeException exc) {
                        logger.logException((Throwable)exc);
                    }
                }
            }
            if (templateTreeNode.getTemplateNode().equals((Object)TemplateNode.LINE)) {
                field.addDrawingElement(this.parseLine(templateTreeNode));
            } else if (templateTreeNode.getTemplateNode().equals((Object)TemplateNode.RECT)) {
                field.addDrawingElement(this.parseRect(templateTreeNode));
            } else if (templateTreeNode.getTemplateNode().equals((Object)TemplateNode.TRIANGLE)) {
                field.addDrawingElement(this.parseTriangle(templateTreeNode));
            } else if (templateTreeNode.getTemplateNode().equals((Object)TemplateNode.ELLIPSE)) {
                field.addDrawingElement(this.parseEllipse(templateTreeNode));
            } else if (templateTreeNode.getTemplateNode().equals((Object)TemplateNode.POLYGON)) {
                field.addDrawingElement(this.parsePolygon(templateTreeNode));
            }
            if (!templateTreeNode.getTemplateNode().equals((Object)TemplateNode.FIELD)) continue;
            try {
                field.addNestedField(this.parseField(field, templateTreeNode, workingDirectory, field.getWidth(), field.getHeight() == -1 ? field.getMaxHeight() : field.getHeight(), executionStatus));
            }
            catch (FieldOutOfBoundsException exc) {
                if (logger.isDebugEnabled()) {
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
                if (executionStatus == null) continue;
                executionStatus.addElement((ExecutionStatusElement)new ExceptionElement((Exception)exc));
                field.setSuccessful(false);
            }
        }
        field.setRenderingElement(renderingElement);
        return field;
    }

    private void parseChilds(TemplateDefinitionTree.TemplateDefinitionNode definitionNode, Node element, Map<String, Option<?>> inheritatedOptions, TemplateTreeNode parent, ExecutionStatus executionStatus) {
        if (!definitionNode.getTemplateNode().isMultipleOccurrences() && this.templateNodeCounts.containsKey(definitionNode.getTemplateNode()) && this.templateNodeCounts.get(definitionNode.getTemplateNode()) > 1) {
            return;
        }
        if (!this.templateNodeCounts.containsKey(definitionNode.getTemplateNode())) {
            this.templateNodeCounts.put(definitionNode.getTemplateNode(), 1);
        } else {
            int count = this.templateNodeCounts.get(definitionNode.getTemplateNode());
            this.templateNodeCounts.put(definitionNode.getTemplateNode(), ++count);
        }
        Pair<Map<String, Option<?>>, Map<String, Option<?>>> parentOptions = this.parseOptions(definitionNode.getTemplateNode(), element, inheritatedOptions, executionStatus);
        TemplateTreeNode templateTreeNode = new TemplateTreeNode(definitionNode.getTemplateNode(), (Map)parentOptions.getFirst(), parent, element);
        parent.addChild(templateTreeNode);
        HashMap optionsToInheritate = new HashMap();
        optionsToInheritate.putAll(inheritatedOptions);
        optionsToInheritate.putAll((Map)parentOptions.getSecond());
        NodeList childNodes = element.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < childNodes.getLength(); ++nodeIndex) {
            for (int i = 0; i < definitionNode.getChilds().size(); ++i) {
                TemplateDefinitionTree.TemplateDefinitionNode childDefinitionNode = (TemplateDefinitionTree.TemplateDefinitionNode)definitionNode.getChilds().get(i);
                if (!childDefinitionNode.getTemplateNode().getKey().equals(childNodes.item(nodeIndex).getNodeName())) continue;
                this.parseChilds(childDefinitionNode, childNodes.item(nodeIndex), optionsToInheritate, templateTreeNode, executionStatus);
            }
        }
    }

    private Pair<Map<String, Option<?>>, Map<String, Option<?>>> parseOptions(TemplateNode templateNode, Node node, Map<String, Option<?>> inheritatedOptions, ExecutionStatus executionStatus) {
        HashMap<String, Option> options = new HashMap<String, Option>();
        HashMap<String, Option> optionsToInheritate = new HashMap<String, Option>();
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            for (Attribute attribute : templateNode.getAttributeList()) {
                try {
                    Option option = attribute.createOption();
                    if (element.hasAttribute(attribute.getKey())) {
                        option.setValueFromString(element.getAttribute(attribute.getKey()));
                    } else if (inheritatedOptions.containsKey(attribute.getKey())) {
                        option.setValueFromString(inheritatedOptions.get(attribute.getKey()).getValueAsString(), false);
                    }
                    if (attribute.isInheritate()) {
                        optionsToInheritate.put(attribute.getKey(), option);
                    }
                    options.put(attribute.getKey(), option);
                }
                catch (Exception exc) {
                    if (logger.isDebugEnabled()) {
                        logger.logExceptionIfDebugEnabled((Throwable)exc);
                    }
                    if (executionStatus == null) continue;
                    executionStatus.addElement((ExecutionStatusElement)new ExceptionElement(exc));
                }
            }
        }
        return new Pair(options, optionsToInheritate);
    }

    private RenderingElement parseTableField(TemplateTreeNode tableNode, int width, int height, File workingDirectory) throws OptionException {
        TableField tableField = new TableField(tableNode.getOptions());
        TemplateTreeNode tableRowNode = null;
        while ((tableRowNode = tableNode.getChilds().poll()) != null) {
            TableRowField tableRowField = new TableRowField(tableRowNode.getOptions(), tableField.getTableBorder(), tableField.getBorderColor(), tableField.getBackgroundColor());
            TemplateTreeNode tableDataNode = null;
            while ((tableDataNode = tableRowNode.getChilds().poll()) != null) {
                TableDataField tableDataField = new TableDataField(tableDataNode.getOptions(), this.parseTextFields(width, height, tableDataNode, workingDirectory), tableField.getTableBorder(), tableField.getBorderColor(), tableField.getBackgroundColor());
                tableRowField.addTableData(tableDataField);
            }
            tableField.addTableRow(tableRowField);
        }
        return tableField;
    }

    private TextFieldContainer parseTextFields(int width, int height, TemplateTreeNode treeNode, File workingDirectory) throws OptionException {
        TextFieldContainer container = new TextFieldContainer(treeNode.getOptions());
        for (TemplateTreeNode childNode : treeNode.getChilds()) {
            if (childNode.getTemplateNode().equals((Object)TemplateNode.TEXT)) {
                container.addTextField(this.parseTextField((Element)childNode.getNode(), width, height, childNode, workingDirectory));
                continue;
            }
            if (!childNode.getTemplateNode().equals((Object)TemplateNode.LABEL)) continue;
            container.addTextField(this.parseLabelField((Element)childNode.getNode(), width, height, childNode));
        }
        return container;
    }

    private TextField parseLabelField(Element element, int width, int height, TemplateTreeNode labelNode) throws OptionException {
        LabelField labelField = new LabelField(labelNode.getOptions(), height);
        TemplateTreeNode childNode = null;
        while ((childNode = labelNode.getChilds().poll()) != null) {
            List<TextElement> textElements = this.createSingleLineTextElement(labelNode, childNode);
            for (TextElement textElement : textElements) {
                labelField.addTextElement(textElement);
            }
        }
        return labelField;
    }

    private TextField parseTextField(Element element, int width, int height, TemplateTreeNode textNode, File workingDirectory) throws OptionException {
        TextField textField = new TextField(textNode.getOptions(), height);
        TemplateTreeNode childNode = null;
        while ((childNode = textNode.getChilds().poll()) != null) {
            List<TextElement> textElements = this.createTextElement(textField, textNode, childNode, workingDirectory);
            boolean isListElement = false;
            for (TextElement textElement : textElements) {
                textField.addTextElement(textElement);
                isListElement = isListElement ? isListElement : textElement instanceof ListElement;
            }
            if (!isListElement || textNode.getChilds().size() <= 0) continue;
            textField.addTextElement((TextElement)Word.newlineWord(textNode.getOptions()));
        }
        return textField;
    }

    private ListElement parseList(TemplateTreeNode parentNode, boolean ordered, File workingDirectory) throws OptionException {
        OrderedListElement list = ordered ? new OrderedListElement(parentNode.getOptions(), workingDirectory) : new UnorderedListElement(parentNode.getOptions(), workingDirectory);
        TemplateTreeNode liNode = null;
        while ((liNode = parentNode.getChilds().poll()) != null) {
            ListItem listItem = new ListItem(liNode.getOptions());
            TemplateTreeNode childNode = null;
            while ((childNode = liNode.getChilds().poll()) != null) {
                List<TextElement> textElements = this.createAndParseTextElement(liNode, childNode, listItem.getLineWrap(), workingDirectory);
                for (TextElement textElement : textElements) {
                    listItem.addTextElement(textElement);
                }
            }
            list.addElement(listItem);
        }
        return list;
    }

    private Span parseSpan(TemplateTreeNode spanNode, File workingDirectory) throws OptionException {
        Span span = new Span(spanNode.getOptions());
        TemplateTreeNode childNode = null;
        while ((childNode = spanNode.getChilds().poll()) != null) {
            List<TextElement> textElements = this.createAndParseTextElement(spanNode, childNode, span.getLineWrap(), workingDirectory);
            for (TextElement textElement : textElements) {
                span.addTextElement(textElement);
            }
        }
        return span;
    }

    private Span parseSingleLineSpan(TemplateTreeNode childNode) throws OptionException {
        SingleLineSpan span = new SingleLineSpan(childNode.getOptions());
        try {
            span.addTextElement((TextElement)new SingleLineWord(childNode.getNode().getTextContent(), childNode.getOptions()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return span;
    }

    private BarcodeField parseBarcodeField(TemplateTreeNode barcodeNode) throws BarcodeException, OptionException {
        Element element = (Element)barcodeNode.getNode();
        String code = element.getTextContent().trim();
        String type = barcodeNode.getOptions().get(Attribute.BARCODE_TYPE.getKey()).getValueAsString();
        if (type == null || type.isEmpty()) {
            throw new OptionException("No barcode type specified");
        }
        TemplateNode barcodeTemplateNode = (TemplateNode)TemplateDefinitionTree.getBarcodeTypes().get(type);
        if (barcodeTemplateNode == null) {
            throw new OptionException("No barcode of type " + type + " found");
        }
        Pair<Map<String, Option<?>>, Map<String, Option<?>>> barcodeOptions = this.parseOptions(barcodeTemplateNode, element, new HashMap(), null);
        return new BarcodeField(code, barcodeNode.getOptions(), (Map)barcodeOptions.getFirst());
    }

    private ImageField parseImageField(Map<String, Option<?>> options, File workingDirectory) throws OptionException {
        return new ImageField(options, workingDirectory);
    }

    private List<TextElement> createTextElement(TextField textField, TemplateTreeNode parentNode, TemplateTreeNode node, File workingDirectory) throws OptionException {
        List<TextElement> textElements = this.createAndParseTextElement(parentNode, node, textField.getLineWrap(), workingDirectory);
        if ((node.getTemplateNode().equals((Object)TemplateNode.UL) || node.getTemplateNode().equals((Object)TemplateNode.OL)) && !textField.span.getLeaves().isEmpty()) {
            ArrayList<TextElement> elements = new ArrayList<TextElement>();
            elements.add((TextElement)Word.newlineWord(parentNode.getOptions()));
            elements.addAll(textElements);
            return elements;
        }
        return textElements;
    }

    private List<TextElement> createAndParseTextElement(TemplateTreeNode parentNode, TemplateTreeNode node, LineWrap lineWrap, File workingDirectory) throws OptionException {
        if (node.getTemplateNode().equals((Object)TemplateNode.PLAIN_TEXT)) {
            List tokens = this.customStringTokenizer.tokenize(node.getNode().getTextContent(), lineWrap);
            ArrayList<TextElement> textElements = new ArrayList<TextElement>();
            for (String token : tokens) {
                try {
                    textElements.add((TextElement)new Word(token, parentNode.getOptions()));
                }
                catch (IllegalArgumentException exc) {}
            }
            return textElements;
        }
        if (node.getTemplateNode().equals((Object)TemplateNode.SPAN)) {
            return Collections.singletonList(this.parseSpan(node, workingDirectory));
        }
        if (node.getTemplateNode().equals((Object)TemplateNode.BR)) {
            this.customStringTokenizer.reset();
            return Collections.singletonList(Word.newlineWord(parentNode.getOptions()));
        }
        if (node.getTemplateNode().equals((Object)TemplateNode.UL) || node.getTemplateNode().equals((Object)TemplateNode.OL)) {
            ListElement list = this.parseList(node, node.getTemplateNode().equals((Object)TemplateNode.OL), workingDirectory);
            return Collections.singletonList(list);
        }
        return null;
    }

    private List<TextElement> createSingleLineTextElement(TemplateTreeNode parentNode, TemplateTreeNode node) throws OptionException {
        if (node.getTemplateNode().equals((Object)TemplateNode.PLAIN_TEXT)) {
            List tokens = this.customStringTokenizer.tokenize(node.getNode().getTextContent(), LineWrap.NONE);
            ArrayList<TextElement> textElements = new ArrayList<TextElement>();
            for (String token : tokens) {
                try {
                    textElements.add((TextElement)new SingleLineWord(token, parentNode.getOptions()));
                }
                catch (IllegalArgumentException exc) {}
            }
            return textElements;
        }
        if (node.getTemplateNode().equals((Object)TemplateNode.SPAN)) {
            return Collections.singletonList(this.parseSingleLineSpan(node));
        }
        return null;
    }

    private Triangle createTriangle(Map<String, Option<?>> options) throws OptionException {
        return new Triangle(options);
    }

    private Rect createRect(Map<String, Option<?>> rectOptions) throws OptionException {
        return new Rect(rectOptions);
    }

    private Line createLine(Map<String, Option<?>> lineOptions) throws OptionException {
        return new Line(lineOptions);
    }

    private Ellipse createEllipse(Map<String, Option<?>> options) throws OptionException {
        return new Ellipse(options);
    }

    private PolygonElement createPolygon(Map<String, Option<?>> options) throws OptionException {
        return new PolygonElement(options);
    }
}

