/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.custom.RenderingResultConnector;
import at.mrdevelopment.esl.tasks.TemplateTask;
import at.mrdevelopment.esl.template.DefaultImageRenderingEngine;
import at.mrdevelopment.esl.template.DefaultImageRenderingEngineConfiguration;
import at.mrdevelopment.esl.template.ESLImage;
import at.mrdevelopment.esl.template.FileTemplateSource;
import at.mrdevelopment.esl.template.ImageRenderingEngineConfiguration;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.ImageTemplate;
import at.mrdevelopment.esl.template.TemplateSource;
import at.mrdevelopment.esl.type.ImageRenderingResult;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.imagotag.rendering.ImageRenderingEngine;
import com.imagotag.rendering.RenderingEngineException;
import java.awt.image.BufferedImage;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.io.FilenameUtils;

public class ImageRenderingEngineWrapper {
    static ESLLogger logger = ESLLogger.getLogger(ImageRenderingEngineWrapper.class);
    private final ImageRenderingEngine renderingEngine;
    private final DefaultImageRenderingEngine defaultRenderingEngine;
    private final ImageRenderingEngineConfiguration configuration;
    private final Set<RenderingResultConnector> connectors = new LinkedHashSet<RenderingResultConnector>();

    public ImageRenderingEngineWrapper(ImageRenderingEngine renderingEngine) throws InitializationException {
        this(renderingEngine, new DefaultImageRenderingEngineConfiguration());
    }

    public ImageRenderingEngineWrapper(ImageRenderingEngine renderingEngine, ImageRenderingEngineConfiguration configuration) throws InitializationException {
        if (renderingEngine == null) {
            throw new InitializationException("No rendering engine loaded", new Object[0]);
        }
        this.configuration = configuration;
        this.defaultRenderingEngine = new DefaultImageRenderingEngine(false);
        this.renderingEngine = renderingEngine;
    }

    public ImageTemplate createImageTemplate(Source recordSource, TemplateSource templateSource, ExecutionStatus executionStatus) throws RenderingEngineException, ImageRenderingException, SerializeException {
        if (this.renderingEngine instanceof DefaultImageRenderingEngine) {
            return ((DefaultImageRenderingEngine)this.renderingEngine).createImageTemplate(recordSource, templateSource, executionStatus);
        }
        throw new RenderingEngineException(String.format("Method not supported by rendering engine %s", this.renderingEngine.getName()));
    }

    public ESLImage createESLImage(ImageTemplate imageTemplate, boolean debug, boolean verbose) throws RenderingEngineException, ImageRenderingException {
        return this.createESLImage(this.renderingEngine, imageTemplate, debug, verbose);
    }

    private ESLImage createESLImage(ImageRenderingEngine renderingEngine, ImageTemplate imageTemplate, boolean debug, boolean verbose) throws RenderingEngineException, ImageRenderingException {
        if (renderingEngine instanceof DefaultImageRenderingEngine) {
            return ((DefaultImageRenderingEngine)renderingEngine).createESLImage(imageTemplate, debug, verbose);
        }
        throw new RenderingEngineException(String.format("Method not supported by rendering engine %s", renderingEngine.getName()));
    }

    public String getName() {
        return this.renderingEngine.getName();
    }

    public String getVersion() {
        return this.renderingEngine.getVersion();
    }

    public BufferedImage renderImage(Source recordSource, TemplateTask templateTask) throws RenderingEngineException, ImageRenderingException, SerializeException {
        TemplateSource templateSource = templateTask.getTemplateSource();
        String templateName = templateSource instanceof FileTemplateSource ? ((FileTemplateSource)templateSource).getTemplateFilename() : null;
        BufferedImage image = null;
        if (this.shouldUseDefaultRenderingEngine(this.renderingEngine, templateName)) {
            ImageTemplate imageTemplate = this.defaultRenderingEngine.createImageTemplate(recordSource, templateSource, null);
            ESLImage eslImage = this.createESLImage(this.defaultRenderingEngine, imageTemplate, logger.isDebugEnabled(), false);
            if (eslImage != null) {
                image = eslImage.getImage();
            }
        } else if (templateSource instanceof FileTemplateSource) {
            FileTemplateSource fileTemplateSource = (FileTemplateSource)templateSource;
            image = this.renderingEngine.renderImage(recordSource, fileTemplateSource.getTemplateFilename());
        }
        if (image == null) {
            throw new RenderingEngineException(String.format("Template source not supported by rendering engine %s: %s", this.renderingEngine.getName(), templateSource.getClass().getSimpleName()));
        }
        ImageRenderingResult renderingResult = new ImageRenderingResult(templateTask, recordSource, image, templateName);
        this.notifyConnectors(renderingResult);
        return image;
    }

    private boolean shouldUseDefaultRenderingEngine(ImageRenderingEngine renderingEngine, String templateName) {
        return renderingEngine instanceof DefaultImageRenderingEngine || this.configuration.isUseDefaultRenderingForXslExtension() && templateName != null && FilenameUtils.isExtension((String)templateName, (String[])new String[]{"xsl", "XSL"});
    }

    private void notifyConnectors(ImageRenderingResult renderingResult) {
        for (RenderingResultConnector connector : this.connectors) {
            connector.notifyRenderingFinished(renderingResult);
        }
    }

    public DOMSource buildImageRenderingSource(DOMSource recordSource, Source templateSource) throws RenderingEngineException, SerializeException {
        if (this.renderingEngine instanceof DefaultImageRenderingEngine) {
            return ((DefaultImageRenderingEngine)this.renderingEngine).buildImageRenderingSource(recordSource, templateSource);
        }
        throw new RenderingEngineException(String.format("Method not supported by rendering engine %s", this.renderingEngine.getName()));
    }

    public void registerRenderingResultConnector(RenderingResultConnector connector) {
        this.connectors.add(connector);
    }
}

