/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.Ellipse;
import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.image.ImageUtils;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;

public class EllipseRenderingElement
implements RenderingElement {
    private final Ellipse ellipse;

    public EllipseRenderingElement(Ellipse ellipse) {
        this.ellipse = ellipse;
    }

    @Override
    public RenderingResult render(int maxWidth, int maxHeight, boolean verbose) {
        ExecutionStatus status = new ExecutionStatus();
        BufferedImage image = ImageUtils.createImage((int)maxWidth, (int)maxHeight, (int)2);
        Graphics2D graphics = image.createGraphics();
        graphics.setPaint(this.ellipse.getColor());
        Rectangle bounds = this.ellipse.getBounds();
        Ellipse2D.Float ellipse2d = new Ellipse2D.Float(bounds.x, bounds.y, bounds.width, bounds.height);
        if (this.ellipse.isFilled()) {
            graphics.fill(ellipse2d);
        }
        graphics.setPaint(this.ellipse.getBorderColor());
        graphics.setStroke(this.ellipse.hasBorder() ? this.ellipse.getBorderStyle().getStroke(this.ellipse.getBorder()) : new BasicStroke(1.0f));
        graphics.draw(ellipse2d);
        graphics.dispose();
        return new RenderingResult(image, status, ellipse2d.getBounds(), true);
    }
}

