/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.DrawingElement;
import at.mrdevelopment.esl.template.EllipseRenderingElement;
import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.BorderStyle;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

@TemplateElementType(type=TemplateNode.ELLIPSE)
public class Ellipse
extends Element
implements DrawingElement {
    private Paint color;
    private Integer border;
    private Paint borderColor;
    private Boolean fill;
    private Rectangle bounds;
    private EllipseRenderingElement renderingElement;
    private BorderStyle borderStyle;

    public Ellipse(Map<String, Option<?>> options) throws OptionException {
        super(options);
        this.color = (Paint)options.get(Attribute.COLOR.getKey()).get();
        this.border = (Integer)options.get(Attribute.BORDER.getKey()).get();
        this.borderColor = (Paint)options.get(Attribute.BORDER_COLOR.getKey()).get();
        this.borderStyle = (BorderStyle)options.get(Attribute.BORDER_STYLE.getKey()).get();
        this.fill = (Boolean)options.get(Attribute.FILL.getKey()).get();
        int xPos = (Integer)options.get(Attribute.X.getKey()).get();
        int yPos = (Integer)options.get(Attribute.Y.getKey()).get();
        int width = (Integer)options.get(Attribute.WIDTH.getKey()).get();
        int height = (Integer)options.get(Attribute.HEIGHT.getKey()).get();
        this.bounds = new Rectangle(xPos, yPos, width, height);
        this.renderingElement = new EllipseRenderingElement(this);
    }

    @Override
    public RenderingElement getRenderingElement() {
        return this.renderingElement;
    }

    @Override
    public Paint getColor() {
        return this.color;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getBorder() {
        return this.border;
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public boolean hasBorder() {
        return this.border > 0;
    }

    public Paint getBorderColor() {
        return this.borderColor;
    }

    public boolean isFilled() {
        return this.fill;
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Arrays.asList(Attribute.X, Attribute.Y, Attribute.WIDTH, Attribute.HEIGHT);
    }
}

