/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.TemplateUtils;
import at.mrdevelopment.esl.template.UtilsDescription;
import at.mrdevelopment.esl.template.UtilsParameter;
import at.mrdevelopment.toolkit.math.ChecksumCalculator;
import at.mrdevelopment.toolkit.text.Const;
import at.mrdevelopment.toolkit.text.TextUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DefaultTemplateUtils
implements TemplateUtils {
    public static final Map<String, String> replacementMap = new HashMap<String, String>();

    @UtilsDescription(description="Returns the given string with each character converted to upper case.")
    public String toUpperCase(@UtilsParameter(description="The string to convert to upper case") String str) {
        return StringUtils.upperCase((String)str);
    }

    @UtilsDescription(description="Returns the given string with each character converted to lower case.")
    public String toLowerCase(@UtilsParameter(description="The string to convert to lower case") String str) {
        return StringUtils.lowerCase((String)str);
    }

    @UtilsDescription(description="Capitalizes a String changing the first letter to title case, no other letters are changed.")
    public String capitalize(@UtilsParameter(description="The string to convert to capitalize") String str) {
        return StringUtils.capitalize((String)str);
    }

    @UtilsDescription(description="Uncapitalizes a String changing the first letter to lower case, no other letters are changed.")
    public String uncapitalize(@UtilsParameter(description="The string to convert to uncapitalize") String str) {
        return StringUtils.uncapitalize((String)str);
    }

    @UtilsDescription(description="Extracts the initial letters from each word in the String.")
    public String initials(@UtilsParameter(description="The string to convert") String str) {
        return WordUtils.initials((String)str);
    }

    @UtilsDescription(description="Capitalizes a all words for the given input")
    public String capitalizeWords(@UtilsParameter(description="The string to convert to capitalize") String str) {
        return WordUtils.capitalize((String)str);
    }

    @UtilsDescription(description="Swaps the case of all words for the given input")
    public String swapCase(@UtilsParameter(description="The string to swap the case") String str) {
        return WordUtils.swapCase((String)str);
    }

    @UtilsDescription(description="Removes leading zeros")
    public String stripLeadingZeros(@UtilsParameter(description="The string to remove zeros from") String str) {
        return StringUtils.stripStart((String)str, (String)"0");
    }

    @UtilsDescription(description="Deletes all whitespaces from a String.")
    public String deleteWhitespace(@UtilsParameter(description="The string to delete whitespaces from.") String str) {
        return StringUtils.deleteWhitespace((String)str);
    }

    @UtilsDescription(description="Converts a String to lower case.")
    public String lowerCase(@UtilsParameter(description="The String to lower case") String str) {
        return StringUtils.lowerCase((String)str);
    }

    @UtilsDescription(description="Removes leading and trailing whitespace")
    public String trim(@UtilsParameter(description="The String to trim") String str) {
        return StringUtils.trim((String)str);
    }

    @UtilsDescription(description="Replaces all occurrences of a String within another String.")
    public String replace(@UtilsParameter(description="Text to search and replace in") String text, @UtilsParameter(description="The string to search for") String searchString, @UtilsParameter(description="The String to replace it with") String replacement) {
        return StringUtils.replace((String)text, (String)searchString, (String)replacement);
    }

    @UtilsDescription(description="Checks if String contains a search String.")
    public String contains(@UtilsParameter(description="Text to check") String str, @UtilsParameter(description="Text to find") String searchStr) {
        return String.valueOf(StringUtils.contains((String)str, (String)searchStr));
    }

    @UtilsDescription(description="Abbreviates a String using ellipses. This will turn \"Now is the time for all good men\" into \"Now is the time for...\".")
    public String abbreviate(@UtilsParameter(description="Text to abbreviate") String str, @UtilsParameter(description="Maximum length of result String (minimum 4)") String maxWidth) {
        return StringUtils.abbreviate((String)str, (int)Integer.valueOf(maxWidth));
    }

    @UtilsDescription(description="Splits the provided text.")
    public String split(@UtilsParameter(description="The text to split.") String str, @UtilsParameter(description="The characters used as the delimiters") String delimiter, @UtilsParameter(description="The index of the splitted array to return") String index) {
        String[] splitted = StringUtils.split((String)str, (String)delimiter);
        int i = Integer.valueOf(index);
        if (i < splitted.length) {
            return splitted[i];
        }
        return "";
    }

    @UtilsDescription(description="Returns the current date in the given format.")
    public String getCurrentDate(@UtilsParameter(description="The format description to format the date") String format) {
        return DateTimeFormat.forPattern((String)format).print((ReadableInstant)DateTime.now());
    }

    @UtilsDescription(description="Returns a non-breaking whitespace character in order to control auto wrapping. (char code: 160)")
    public String getNonBreakingSpace() {
        return Const.NON_BREAKING_DELIMITER;
    }

    @UtilsDescription(description="Returns the current operating system. (WINDOWS|LINUX|MAC|OTHER)")
    public String getOperatingSystem() {
        String osProperty = System.getProperty("os.name").toLowerCase();
        if (osProperty.indexOf("windows") > -1) {
            return "WINDOWS";
        }
        if (osProperty.indexOf("linux") > -1) {
            return "LINUX";
        }
        if (osProperty.indexOf("mac") > -1) {
            return "MAC";
        }
        return "OTHER";
    }

    @UtilsDescription(description="Returns whether the given font is available on the current system or not. (true|false)")
    public String isFontAvailable(@UtilsParameter(description="The font name as string") String font) {
        return BooleanUtils.toString((boolean)TextUtils.isFontAvailable((String)font), (String)"true", (String)"false");
    }

    @UtilsDescription(description="Returns the absolute path to the current working directory")
    public String getCurrentWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    @UtilsDescription(description="Replaces all umlauts in the given string (\u00e4->ae, \u00f6->oe, \u00fc->ue)")
    public String replaceUmlauts(@UtilsParameter(description="Text to search and replace in") String text) {
        for (Map.Entry<String, String> entry : replacementMap.entrySet()) {
            text = StringUtils.replace((String)text, (String)entry.getValue(), (String)entry.getKey());
        }
        return text;
    }

    @UtilsDescription(description="Replaces the umlaut-replacments with umlauts (ae->\u00e4, oe->\u00f6, ue->\u00fc)")
    public String insertUmlauts(@UtilsParameter(description="Text to search and replace in") String text) {
        for (Map.Entry<String, String> entry : replacementMap.entrySet()) {
            text = StringUtils.replace((String)text, (String)entry.getKey(), (String)entry.getValue());
        }
        return text;
    }

    @UtilsDescription(description="Parses the given date string using the given input format and outputs a date string corresponding to the output format.\ny: year, D: day of year, M: month of year, d: day of month, H: hour of day, m: minute of hour, s: second of minute, z: time zone, E: day of week, w: week of weekyear ")
    public String formatDate(@UtilsParameter(description="The date string to format") String dateString, @UtilsParameter(description="The format for parsing the input date string") String inputFormat, @UtilsParameter(description="The format for the output date string") String outputFormat) {
        try {
            DateTimeFormatter inputFormatter = DateTimeFormat.forPattern((String)inputFormat);
            DateTimeFormatter outputFormatter = DateTimeFormat.forPattern((String)outputFormat);
            return outputFormatter.print((ReadableInstant)inputFormatter.parseDateTime(dateString));
        }
        catch (Exception exc) {
            return exc.getMessage();
        }
    }

    @UtilsDescription(description="Formats the given number with the specified format. The formatting uses the Java implementation of the String.format() method. For more information see: http://docs.oracle.com/javase/tutorial/java/data/numberformat.html")
    public String formatNumber(@UtilsParameter(description="The number to format") String numberString, @UtilsParameter(description="The format string") String formatString) {
        try {
            return String.format(formatString, Double.valueOf(numberString).intValue());
        }
        catch (Exception exc) {
            return exc.getMessage();
        }
    }

    @UtilsDescription(description="Formats the given string with the specified format. The formatting uses the Java implementation of the String.format() method")
    public String format(@UtilsParameter(description="The string to format") String string, @UtilsParameter(description="The format string") String formatString) {
        try {
            return String.format(formatString, string);
        }
        catch (Exception exc) {
            return exc.getMessage();
        }
    }

    @UtilsDescription(description="Calculates the checksum for the given input number")
    public String calculateChecksum(@UtilsParameter(description="The number to calculate the checksum for") String input, @UtilsParameter(description="Multiplier for all even numbers (usually 1)") String evenMultiplier, @UtilsParameter(description="Multiplier for all odd numbers (e.g. 3)") String oddMultiplier, @UtilsParameter(description="The modular to calculate the checksum (e.g. 10 for EANs)") String modular, @UtilsParameter(description="The radix of the input and result (10 for decimal, 16 for hex)") String radix) {
        return ChecksumCalculator.calculateChecksum((String)input, (String)evenMultiplier, (String)oddMultiplier, (String)modular, (String)radix);
    }

    @UtilsDescription(description="Calculates the base price for the given price, compare size and actual size. The result is rounded half up with '.' as decimal separator")
    public String calculateBasePrice(@UtilsParameter(description="The actual price") String price, @UtilsParameter(description="The actual size for the given price") String size, @UtilsParameter(description="The size the result should be calculated for") String compareSize) {
        double dPrice = Double.valueOf(price);
        double dCompareSize = Double.valueOf(compareSize);
        double dSize = Double.valueOf(size);
        if (dSize > 0.0 && dCompareSize > 0.0) {
            double basePrice = dPrice / dSize * dCompareSize;
            return DefaultTemplateUtils.priceToString(basePrice);
        }
        return "";
    }

    private static String priceToString(double basePrice) {
        BigDecimal bigDecimal = new BigDecimal(basePrice);
        bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
        DecimalFormat format = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        format.setMinimumFractionDigits(2);
        format.setMaximumFractionDigits(2);
        format.setDecimalSeparatorAlwaysShown(true);
        return format.format(bigDecimal.doubleValue());
    }

    static {
        replacementMap.put("ae", "\u00e4");
        replacementMap.put("oe", "\u00f6");
        replacementMap.put("ue", "\u00fc");
        replacementMap.put("Ae", "\u00c4");
        replacementMap.put("Oe", "\u00d6");
        replacementMap.put("Ue", "\u00dc");
    }
}

