/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.DebugESLImage;
import at.mrdevelopment.esl.template.DefaultTemplateUtils;
import at.mrdevelopment.esl.template.ESLImage;
import at.mrdevelopment.esl.template.FileTemplateSource;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.ImageTemplate;
import at.mrdevelopment.esl.template.ImageXMLSerializer;
import at.mrdevelopment.esl.template.TemplateSource;
import at.mrdevelopment.esl.template.TemplateUtilsFactory;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.imagotag.rendering.ImageRenderingEngine;
import com.imagotag.rendering.RenderingEngineException;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;

public class DefaultImageRenderingEngine
implements ImageRenderingEngine {
    static ESLLogger logger = ESLLogger.getLogger(DefaultImageRenderingEngine.class);
    private static final String ENGINE_NAME = "default";
    private final Version version;
    private final ImageXMLSerializer templateXMLSerializer;
    private final TemplateUtilsFactory templateUtilsFactory;

    public DefaultImageRenderingEngine(boolean useSecureProcessing) throws InitializationException {
        this.templateXMLSerializer = new ImageXMLSerializer(useSecureProcessing);
        this.templateUtilsFactory = new TemplateUtilsFactory();
        this.templateUtilsFactory.registerTemplateUtils(new DefaultTemplateUtils());
        Info info = null;
        try {
            info = Info.load(DefaultImageRenderingEngine.class);
        }
        catch (SerializeException exc) {
            logger.warn("Could not load version information of rendering engine: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        catch (InitializationException exc) {
            logger.warn("Could not load version information of rendering engine: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        this.version = info != null ? info.getVersion() : Version.UNDEFINED;
    }

    public String getName() {
        return ENGINE_NAME;
    }

    public String getVersion() {
        return String.format("%s (%d)", this.version.getVersionString(), this.version.getBuild());
    }

    public BufferedImage renderImage(Source recordSource, String template) throws RenderingEngineException {
        try {
            ImageTemplate imageTemplate = this.createImageTemplate(recordSource, new FileTemplateSource(new File(template)), null);
            ESLImage eslImage = this.createESLImage(imageTemplate, false, false);
            return eslImage.getImage();
        }
        catch (ImageRenderingException exc) {
            throw new RenderingEngineException((Throwable)((Object)exc));
        }
        catch (SerializeException exc) {
            throw new RenderingEngineException((Throwable)exc);
        }
    }

    public ImageTemplate createImageTemplate(Source recordSource, TemplateSource template, ExecutionStatus executionStatus) throws SerializeException, ImageRenderingException {
        Source templateSource = template.getSource();
        File workingDirectory = template.getWorkingDirectory();
        DOMSource imageSource = this.templateXMLSerializer.transformTemplate(templateSource, recordSource);
        this.templateUtilsFactory.applyUtils(((Document)imageSource.getNode()).getDocumentElement(), executionStatus);
        return this.templateXMLSerializer.parseImage(workingDirectory, imageSource, executionStatus);
    }

    public ESLImage createESLImage(ImageTemplate imageTemplate, boolean debug, boolean verbose) throws ImageRenderingException {
        ESLImage eslImage;
        ESLImage eSLImage = eslImage = debug ? new DebugESLImage(imageTemplate, verbose) : new ESLImage(imageTemplate, verbose);
        if (logger.isDebugEnabled()) {
            for (ExecutionStatusElement element : eslImage.getStatus().getElements()) {
                logger.warn("Warning during image rendering: %s", new Object[]{element.getElement()});
            }
        } else if (!eslImage.isSuccessful()) {
            logger.warn("At least one warning occurred during rendering image from template.");
        }
        return eslImage;
    }

    public DOMSource buildImageRenderingSource(DOMSource recordSource, Source templateSource) throws SerializeException {
        return this.templateXMLSerializer.transformTemplate(templateSource, recordSource);
    }
}

