/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.barcode.Barcode;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.BarcodeFactory;
import at.mrdevelopment.toolkit.barcode.BarcodeRenderingResult;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

@TemplateElementType(type=TemplateNode.BARCODE)
public class BarcodeField
extends Element
implements RenderingElement {
    public static final String TYPE = "barcode";
    protected String code;
    protected Barcode barcode;
    protected BarcodeFactory barcodeFactory = new BarcodeFactory();

    public BarcodeField(String code, Map<String, Option<?>> options, Map<String, Option<?>> barcodeOptions) throws OptionException, BarcodeException {
        super(options);
        this.code = code;
        String type = null;
        Option<?> typeOption = null;
        if (options.containsKey(Attribute.BARCODE_TYPE.getKey())) {
            typeOption = options.get(Attribute.BARCODE_TYPE.getKey());
            type = typeOption.getValueAsString();
        }
        if (type == null) {
            throw new BarcodeException("No barcode type specified!");
        }
        this.barcode = this.barcodeFactory.getBarcode(type, barcodeOptions);
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Arrays.asList(Attribute.BARCODE_TYPE);
    }

    public Option<?> getOption(String attributeKey) throws BarcodeException, OptionException {
        return this.barcode.getOptionContainer().getOption(attributeKey);
    }

    public String getType() {
        return this.barcode.getIdentifier();
    }

    @Override
    public RenderingResult render(int maxWidth, int maxHeight, boolean verbose) {
        this.barcode.setVerboseEnabled(verbose);
        BarcodeRenderingResult barcodeResult = this.barcode.render(this.code, maxWidth, maxHeight);
        ExecutionStatus status = barcodeResult.getStatus();
        RenderingResult result = new RenderingResult(barcodeResult.getImage(), status, barcodeResult.isSuccessful());
        return result;
    }
}

