/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SetConfigTask
extends ExecutableTask {
    private final Map<LabelConfig, Integer> configs;

    public SetConfigTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Map<LabelConfig, Integer> configs) {
        this(labelId, priority, externalId, replaceWaitingTasks, configs, null);
    }

    public SetConfigTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Map<LabelConfig, Integer> configs, Integer retryValidInMinutes) {
        super(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
        this.configs = new HashMap<LabelConfig, Integer>(configs);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.SET_CONFIG;
    }

    public Map<LabelConfig, Integer> getConfigs() {
        return Collections.unmodifiableMap(this.configs);
    }

    @Override
    public String getData() {
        return Joiner.on((String)";").join((Iterable)Collections2.transform(this.configs.keySet(), (Function)new Function<LabelConfig, String>(){

            public String apply(LabelConfig labelConfig) {
                return String.format("%d=%d", labelConfig.getConfigId(), SetConfigTask.this.configs.get(labelConfig));
            }
        }));
    }

    @Override
    public boolean isLocked() {
        return true;
    }
}

