/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ResetCounterTask
extends ExecutableTask {
    private final Set<LabelCounter> counters;

    public ResetCounterTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Collection<LabelCounter> counters) {
        this(labelId, priority, externalId, replaceWaitingTasks, counters, null);
    }

    public ResetCounterTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Collection<LabelCounter> counters, Integer retryValidInMinutes) {
        super(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
        this.counters = new HashSet<LabelCounter>(counters);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.RESET_COUNTER;
    }

    public Collection<LabelCounter> getCounters() {
        return Collections.unmodifiableCollection(this.counters);
    }

    @Override
    public String getData() {
        return Joiner.on((String)";").join((Iterable)Collections2.transform(this.counters, (Function)new Function<LabelCounter, Integer>(){

            public Integer apply(LabelCounter labelCounter) {
                return labelCounter.getCounterId();
            }
        }));
    }

    @Override
    public boolean isLocked() {
        return true;
    }
}

