/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class QuerySensorTask
extends ExecutableTask {
    private final Collection<LabelSensor> sensors;

    public QuerySensorTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Collection<LabelSensor> sensors) {
        this(labelId, priority, externalId, replaceWaitingTasks, sensors, null);
    }

    public QuerySensorTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Collection<LabelSensor> sensors, Integer retryValidInMinutes) {
        super(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
        this.sensors = new ArrayList<LabelSensor>(sensors);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.QUERY_SENSOR;
    }

    public Collection<LabelSensor> getSensors() {
        return Collections.unmodifiableCollection(this.sensors);
    }

    @Override
    public String getData() {
        return Joiner.on((String)";").join((Iterable)Collections2.transform(this.sensors, (Function)new Function<LabelSensor, Integer>(){

            public Integer apply(LabelSensor labelSensor) {
                return labelSensor.getSensorId();
            }
        }));
    }
}

