/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class QueryCounterTask
extends ExecutableTask {
    private final Collection<LabelCounter> counters;

    public QueryCounterTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Collection<LabelCounter> counters) {
        this(labelId, priority, externalId, replaceWaitingTasks, counters, null);
    }

    public QueryCounterTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Collection<LabelCounter> counters, Integer retryValidInMinutes) {
        super(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
        this.counters = new ArrayList<LabelCounter>(counters);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.QUERY_COUNTER;
    }

    public Collection<LabelCounter> getCounters() {
        return Collections.unmodifiableCollection(this.counters);
    }

    @Override
    public String getData() {
        return Joiner.on((String)";").join((Iterable)Collections2.transform(this.counters, (Function)new Function<LabelCounter, Integer>(){

            public Integer apply(LabelCounter labelCounter) {
                return labelCounter.getCounterId();
            }
        }));
    }
}

