/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.service;

import at.mrdevelopment.esl.service.DefaultServiceClientRequestStrategy;
import at.mrdevelopment.esl.service.LegacyServiceClientRequestStrategy;
import at.mrdevelopment.esl.service.ServiceClientRequestStrategy;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class ServiceClientRequestStrategyFactory {
    static ESLLogger logger = ESLLogger.getLogger(ServiceClientRequestStrategyFactory.class);

    public static ServiceClientRequestStrategy getStrategyForVersion(Version version) throws InitializationException {
        try {
            if (!version.equals((Object)Version.UNDEFINED) && version.isEqualOlder(LegacyServiceClientRequestStrategy.VERSION)) {
                logger.debug("Loading request strategy for server with version %s", new Object[]{version});
                return new LegacyServiceClientRequestStrategy();
            }
        }
        catch (InitializationException exc) {
            logger.warn("Failed to create request strategy for server with version %s", new Object[]{version});
        }
        return new DefaultServiceClientRequestStrategy();
    }
}

