/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.service;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.ServiceStatusProvider;
import at.mrdevelopment.esl.core.TasksSubmittedNotify;
import at.mrdevelopment.esl.core.tag.LabelTagsUpdate;
import at.mrdevelopment.esl.persistence.RecordXMLSerializer;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.persistence.record.Template;
import at.mrdevelopment.esl.persistence.record.TransactionStatusInfo;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.service.DefaultServiceClientRequestStrategy;
import at.mrdevelopment.esl.service.ServiceClientRequestStrategy;
import at.mrdevelopment.esl.service.ServiceClientRequestStrategyFactory;
import at.mrdevelopment.esl.tasks.AbortRequest;
import at.mrdevelopment.esl.tasks.TemplateXMLTask;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.Matching;
import at.mrdevelopment.esl.type.Tag;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.xml.AbortRequestXMLSerializer;
import at.mrdevelopment.esl.xml.ArticleXMLSerializer;
import at.mrdevelopment.esl.xml.LabelRegistrationXMLSerializer;
import at.mrdevelopment.esl.xml.LabelXMLSerializer;
import at.mrdevelopment.esl.xml.MatchingXMLSerializer;
import at.mrdevelopment.esl.xml.ServiceStatusXMLSerializer;
import at.mrdevelopment.esl.xml.TagsUpdateXMLSerializer;
import at.mrdevelopment.esl.xml.TaskXMLSerializer;
import at.mrdevelopment.esl.xml.TransactionXMLSerializer;
import at.mrdevelopment.toolkit.ConversionUtils;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.HttpServiceClient;
import at.mrdevelopment.toolkit.http.HttpServiceClientConfiguration;
import at.mrdevelopment.toolkit.http.IgnoreResponseHandler;
import at.mrdevelopment.toolkit.http.RequestUser;
import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.problem.Problem;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.EntityTemplate;
import org.w3c.dom.Document;

public class ServiceClient
implements ServiceStatusProvider,
Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(ServiceClient.class);
    private final HttpServiceClient httpServiceClient;
    private final ServiceStatusXMLSerializer xmlServiceStatus;
    private final TaskXMLSerializer tasksSerializer;
    private final AbortRequestXMLSerializer abortRequestSerializer;
    private final LabelRegistrationXMLSerializer labelRegistrationSerializer;
    private final LabelXMLSerializer labelSerializer;
    private final TagsUpdateXMLSerializer tagsUpdateSerializer;
    private final TransactionXMLSerializer transactionSerializer;
    private final MatchingXMLSerializer matchingSerializer;
    private final ArticleXMLSerializer articleSerializer;
    private final RecordXMLSerializer<TransactionStatusInfo> transactionStatusSerializer;
    private final RecordXMLSerializer<UpdateStatus> updateStatusSerializer;
    private final RecordXMLSerializer<Tag> tagSerializer;
    private final RecordXMLSerializer<Template> templateSerializer;
    private ServiceClientRequestStrategy requestStrategy;
    private final XMLContentProducerFactory contentProducerFactory;
    private final Object serviceStatusLock = new Object();
    private String username;
    private ServiceStatus serviceStatus;

    public ServiceClient(String host, int port, boolean useSSL) throws InitializationException {
        this(host, port, useSSL, null, HttpServiceClientConfiguration.createDefaultConfiguration());
    }

    public ServiceClient(ServiceAddress serviceAddress) throws InitializationException {
        this(serviceAddress, HttpServiceClientConfiguration.createDefaultConfiguration());
    }

    public ServiceClient(ServiceAddress serviceAddress, HttpServiceClientConfiguration httpServiceClientConfiguration) throws InitializationException {
        this(serviceAddress.getHost(), serviceAddress.getPort(), serviceAddress.useSSL(), serviceAddress.getPath(), httpServiceClientConfiguration);
        if (serviceAddress.getUsername() != null && serviceAddress.getPassword() != null) {
            this.setCredentials(serviceAddress.getUsername(), serviceAddress.getPassword());
        }
    }

    public ServiceClient(String host, int port, boolean useSSL, HttpServiceClientConfiguration httpServiceClientConfiguration) throws InitializationException {
        this(host, port, useSSL, null, httpServiceClientConfiguration);
    }

    public ServiceClient(String host, int port, boolean useSSL, String pathPrefix, HttpServiceClientConfiguration httpServiceClientConfiguration) throws InitializationException {
        this.httpServiceClient = new HttpServiceClient(host, port, useSSL, pathPrefix, httpServiceClientConfiguration, true);
        this.xmlServiceStatus = new ServiceStatusXMLSerializer();
        this.tasksSerializer = new TaskXMLSerializer();
        this.abortRequestSerializer = new AbortRequestXMLSerializer();
        this.labelRegistrationSerializer = new LabelRegistrationXMLSerializer();
        this.labelSerializer = new LabelXMLSerializer();
        this.tagsUpdateSerializer = new TagsUpdateXMLSerializer();
        this.matchingSerializer = new MatchingXMLSerializer();
        this.articleSerializer = new ArticleXMLSerializer();
        this.transactionSerializer = new TransactionXMLSerializer();
        this.transactionStatusSerializer = new RecordXMLSerializer<TransactionStatusInfo>(TransactionStatusInfo.class);
        this.updateStatusSerializer = new RecordXMLSerializer<UpdateStatus>(UpdateStatus.class);
        this.tagSerializer = new RecordXMLSerializer<Tag>(Tag.class);
        this.templateSerializer = new RecordXMLSerializer<Template>(Template.class);
        this.contentProducerFactory = XMLContentProducerFactory.newInstance();
        this.requestStrategy = new DefaultServiceClientRequestStrategy();
    }

    public void setCredentials(String username, String password) {
        this.username = username;
        this.httpServiceClient.setCredentials(username, password);
    }

    public HttpServiceClient getHttpServiceClient() {
        return this.httpServiceClient;
    }

    public String getHost() {
        return this.httpServiceClient.getHost();
    }

    public int getPort() {
        return this.httpServiceClient.getPort();
    }

    public void queryServiceStatus() throws WebserviceException, SerializeException, IOException {
        HttpGet request = new HttpGet("/service/status.xml");
        this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void handleResponse(HttpResponse response) throws Exception {
                Object object = ServiceClient.this.serviceStatusLock;
                synchronized (object) {
                    InputStream inputStream = response.getEntity().getContent();
                    ServiceClient.this.serviceStatus = ServiceClient.this.xmlServiceStatus.parseXML(inputStream);
                    ServiceClient.this.loadRequestStrategy(ServiceClient.this.serviceStatus);
                }
                return null;
            }
        });
    }

    private void loadRequestStrategy(ServiceStatus serviceStatus) {
        String versionString = serviceStatus.getPropertyValue("version");
        if (versionString != null && !versionString.isEmpty()) {
            Version version = Version.fromString((String)versionString);
            try {
                this.requestStrategy = ServiceClientRequestStrategyFactory.getStrategyForVersion(version);
            }
            catch (InitializationException exc) {
                logger.debug("Unable to change request strategy");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validServiceStatus() {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            return this.serviceStatus != null;
        }
    }

    public void sendTasks(TaskOrder taskOrder, int partitionSize, final TasksSubmittedNotify tasksSubmittedNotify) throws SerializeException, WebserviceException {
        Iterable<TaskOrder> partitions = taskOrder.getPartitions(partitionSize);
        for (final TaskOrder tasksPartition : partitions) {
            Document document = this.tasksSerializer.toXML(tasksPartition);
            HttpPost request = new HttpPost("/service/tasks/add.xml");
            request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
            this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

                public Void handleResponse(HttpResponse response) throws Exception {
                    InputStream inputStream = response.getEntity().getContent();
                    TaskTransaction transaction = ServiceClient.this.transactionSerializer.parseXML(inputStream);
                    tasksSubmittedNotify.tasksSubmitted(transaction, tasksPartition.getSize());
                    return null;
                }
            });
        }
    }

    public void sendTasks(TaskOrder taskOrder, TasksSubmittedNotify tasksSubmittedNotify) throws SerializeException, WebserviceException {
        this.sendTasks(taskOrder, 100000, tasksSubmittedNotify);
    }

    public void sendAbortRequests(List<AbortRequest> abortRequests) throws SerializeException, WebserviceException {
        Document document = this.abortRequestSerializer.toXML(abortRequests);
        HttpPost request = new HttpPost("/service/abort.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    public void registerLabels(final List<LabelRegistration> registrations, final TasksSubmittedNotify tasksSubmittedNotify) throws SerializeException, WebserviceException {
        Document document = this.labelRegistrationSerializer.toXML(registrations);
        for (LabelRegistration registration : registrations) {
            logger.info("Registering label %s with tags %s", new Object[]{registration.getLabelId(), StringUtils.join(registration.getTags(), (String)", ")});
        }
        HttpPost request = new HttpPost("/service/labels/register.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequestAsync((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

            public Void handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                TaskTransaction transaction = ServiceClient.this.transactionSerializer.parseXML(inputStream);
                tasksSubmittedNotify.tasksSubmitted(transaction, registrations.size());
                return null;
            }
        });
    }

    public void unregisterLabels(final List<LabelId> labels, final TasksSubmittedNotify tasksSubmittedNotify) throws SerializeException, WebserviceException {
        Document document = this.labelSerializer.toXML(labels);
        HttpPost request = new HttpPost("/service/labels/unregister.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequestAsync((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

            public Void handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                TaskTransaction transaction = ServiceClient.this.transactionSerializer.parseXML(inputStream);
                tasksSubmittedNotify.tasksSubmitted(transaction, labels.size());
                return null;
            }
        });
    }

    public void updateLabelTags(List<LabelTagsUpdate> tagsUpdates) throws SerializeException, WebserviceException {
        Document document = this.tagsUpdateSerializer.toXML(tagsUpdates);
        HttpPost request = new HttpPost("/service/labels/tags/update.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    public void modifyMatchings(final List<Matching> matchings, final TasksSubmittedNotify tasksSubmittedNotify) throws SerializeException, WebserviceException {
        Document document = this.matchingSerializer.toXML(matchings);
        HttpPost request = new HttpPost("/service/matching/modify.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequestAsync((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

            public Void handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                TaskTransaction transaction = ServiceClient.this.transactionSerializer.parseXML(inputStream);
                tasksSubmittedNotify.tasksSubmitted(transaction, matchings.size());
                return null;
            }
        });
    }

    public void storeArticle(Article article, final TasksSubmittedNotify tasksSubmittedNotify) throws SerializeException, WebserviceException {
        Document document = this.articleSerializer.toXML(Collections.singleton(article));
        HttpPost request = new HttpPost("/service/article/store.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequestAsync((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

            public Void handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                TaskTransaction transaction = ServiceClient.this.transactionSerializer.parseXML(inputStream);
                tasksSubmittedNotify.tasksSubmitted(transaction, 0);
                return null;
            }
        });
    }

    public void updateTemplate(String template, final TasksSubmittedNotify tasksSubmittedNotify) {
        HttpPost request = new HttpPost(String.format("/service/template/update/%s.xml", template));
        this.httpServiceClient.executeRequestAsync((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

            public Void handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                TaskTransaction transaction = ServiceClient.this.transactionSerializer.parseXML(inputStream);
                tasksSubmittedNotify.tasksSubmitted(transaction, 0);
                return null;
            }
        });
    }

    public Document queryTemplateSource(String template) throws WebserviceException {
        HttpGet request = new HttpGet(String.format("/service/template/source/%s", template));
        return (Document)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Document>(){

            public Document handleResponse(HttpResponse response) throws Exception {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                return builder.parse(response.getEntity().getContent());
            }
        });
    }

    public Document queryRenderingSourcePreview(TemplateXMLTask task) throws SerializeException, WebserviceException {
        Document document = this.tasksSerializer.toXML(task);
        HttpPost request = new HttpPost("/service/rendering/preview/source.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        return (Document)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Document>(){

            public Document handleResponse(HttpResponse response) throws Exception {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                return builder.parse(response.getEntity().getContent());
            }
        });
    }

    public Document queryRenderingImageDocumentPreview(TemplateXMLTask task) throws SerializeException, WebserviceException {
        Document document = this.tasksSerializer.toXML(task);
        HttpPost request = new HttpPost("/service/rendering/preview/image.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        return (Document)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Document>(){

            public Document handleResponse(HttpResponse response) throws Exception {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                return builder.parse(response.getEntity().getContent());
            }
        });
    }

    public BufferedImage queryRenderingImagePreview(TemplateXMLTask task) throws SerializeException, WebserviceException {
        Document document = this.tasksSerializer.toXML(task);
        HttpPost request = new HttpPost("/service/rendering/preview/image.png");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        return (BufferedImage)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<BufferedImage>(){

            public BufferedImage handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                return ImageSerializer.readImage((InputStream)inputStream);
            }
        });
    }

    public BufferedImage queryUpdateImage(UUID taskId) throws WebserviceException, IOException {
        HttpGet request = new HttpGet(String.format("/service/updatestatus/image/%s.png", taskId));
        return (BufferedImage)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<BufferedImage>(){

            public BufferedImage handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                return ImageSerializer.readImage((InputStream)inputStream);
            }
        });
    }

    public Collection<UpdateStatus> queryUpdateStatus() throws WebserviceException {
        return this.queryUpdateStatus("/service/updatestatus/index.xml");
    }

    public Collection<UpdateStatus> queryUpdateStatus(LabelId labelId) throws WebserviceException {
        return this.queryUpdateStatus(String.format("/service/updatestatus/label/%s.xml", labelId.getLabelIdString()));
    }

    public Collection<UpdateStatus> queryUpdateStatus(TaskTransaction transaction) throws WebserviceException {
        return this.queryUpdateStatus(String.format("/service/updatestatus/transaction/%d.xml", transaction.getId()));
    }

    private Collection<UpdateStatus> queryUpdateStatus(String url) throws WebserviceException {
        HttpGet request = new HttpGet(url);
        return (Collection)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Collection<UpdateStatus>>(){

            public Collection<UpdateStatus> handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                List<UpdateStatus> result = ServiceClient.this.updateStatusSerializer.parseXML(inputStream);
                return result;
            }
        });
    }

    public Collection<LabelInfo> queryLabelInfo() throws WebserviceException {
        return this.requestStrategy.queryLabelInfos(this.httpServiceClient);
    }

    public TransactionStatusInfo queryTransactionStatus(TaskTransaction transaction) throws WebserviceException {
        HttpGet request = new HttpGet(String.format("/service/transaction/status/%d.xml", transaction.getId()));
        return (TransactionStatusInfo)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<TransactionStatusInfo>(){

            public TransactionStatusInfo handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                List transactionStatusList = ServiceClient.this.transactionStatusSerializer.parseXML(inputStream);
                return (TransactionStatusInfo)transactionStatusList.get(0);
            }
        });
    }

    public SortedSet<String> queryLabelTags() throws WebserviceException {
        HttpGet request = new HttpGet("/service/tags.xml");
        return (SortedSet)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<SortedSet<String>>(){

            public SortedSet<String> handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                List<Tag> tags = ServiceClient.this.tagSerializer.parseXML(inputStream);
                return Tag.toStrings(tags);
            }
        });
    }

    public SortedSet<String> queryTemplates() throws WebserviceException {
        HttpGet request = new HttpGet("/service/template/index.xml");
        return (SortedSet)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<SortedSet<String>>(){

            public SortedSet<String> handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                List<Template> templates = ServiceClient.this.templateSerializer.parseXML(inputStream);
                return Template.toStrings(templates);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWaitingLabelsCount() {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            return this.serviceStatus.getNumericValue("waiting-tasks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getErrorLabelsCount() {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            return this.serviceStatus.getNumericValue("error-tasks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxMemory() {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            try {
                return ConversionUtils.toByte((String)this.serviceStatus.getPropertyValue("max-memory"));
            }
            catch (Exception exc) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFreeMemory() {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            try {
                return ConversionUtils.toByte((String)this.serviceStatus.getPropertyValue("free-memory"));
            }
            catch (Exception exc) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalMemory() {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            try {
                return ConversionUtils.toByte((String)this.serviceStatus.getPropertyValue("total-memory"));
            }
            catch (Exception exc) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getThreadCount() {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            return Long.parseLong(this.serviceStatus.getPropertyValue("threads"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserId getUser() {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            String username = this.serviceStatus.getPropertyValue("username");
            Role role = Role.valueOf((String)this.serviceStatus.getPropertyValue("role"));
            return new RequestUser(role, username);
        }
    }

    public String getUsername() {
        return this.username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Problem> getProblems() {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            return this.serviceStatus.getProblems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Commitable> boolean hasRecordClassRegistered(Class<T> recordClass) {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            String recordClassesString = this.serviceStatus.getPropertyValue("registered-records");
            if (recordClassesString == null) {
                return false;
            }
            List<String> recordClasses = Arrays.asList(StringUtils.split((String)recordClassesString, (String)", "));
            return recordClasses.contains(recordClass.getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Commitable> List<String> getCustomFields(Class<T> recordClass) {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            String customFieldsString = this.serviceStatus.getPropertyValue("custom-fields." + recordClass.getSimpleName());
            if (customFieldsString == null) {
                return new ArrayList<String>(0);
            }
            return Arrays.asList(StringUtils.split((String)customFieldsString, (String)", "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceStatus getServiceStatus() {
        Object object = this.serviceStatusLock;
        synchronized (object) {
            return this.serviceStatus;
        }
    }

    public void shutdown() {
        this.httpServiceClient.close();
    }
}

