/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing.gui;

import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.gui.editor.AddressEditor;
import at.mrdevelopment.esl.processing.gui.EditConfigManager;
import at.mrdevelopment.esl.processing.gui.LabelConfigTab;
import at.mrdevelopment.esl.processing.model.ServiceAddressListModel;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.apache.commons.lang.StringUtils;

public class EditConfigView {
    static ESLLogger logger = ESLLogger.getLogger(EditConfigView.class);
    private EditConfigManager editConfigManager;
    private AddressEditor ipAddressEditor;
    private JList accessPointList;
    private ServiceAddressListModel accessPointListModel;
    private LabelConfigTab labelConfigTab;

    public EditConfigView(EditConfigManager editConfigManager) {
        this.editConfigManager = editConfigManager;
    }

    private JPanel initializeAccessPointTabComponents() {
        JPanel accessPointPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout());
        this.ipAddressEditor = new AddressEditor();
        topPanel.add(this.ipAddressEditor.getEditorComponent());
        JButton addAccessPointButton = new JButton("+");
        addAccessPointButton.setMargin(new Insets(1, 5, 1, 5));
        addAccessPointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditConfigView.this.onAddAccessPointButton();
            }
        });
        topPanel.add(addAccessPointButton);
        this.accessPointList = new JList(this.accessPointListModel);
        this.accessPointList.setSelectionMode(0);
        this.accessPointList.setPrototypeCellValue("255.255.255.255 (selected)");
        this.accessPointList.setFixedCellHeight(18);
        JPanel bottomPanel = new JPanel(new FlowLayout());
        JButton setDefaultButton = new JButton("Set Selected");
        setDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditConfigView.this.onSetDefaultButton();
            }
        });
        bottomPanel.add(setDefaultButton);
        JButton removeAccessPointButton = new JButton("Remove");
        removeAccessPointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditConfigView.this.onRemoveAccessPointButton();
            }
        });
        bottomPanel.add(removeAccessPointButton);
        accessPointPanel.add((Component)new JScrollPane(this.accessPointList, 22, 30), "Center");
        accessPointPanel.add((Component)topPanel, "North");
        accessPointPanel.add((Component)bottomPanel, "South");
        return accessPointPanel;
    }

    protected void onRemoveAccessPointButton() {
        this.accessPointListModel.removeServiceAddress(this.accessPointList.getSelectedIndex());
    }

    private void initializeAccessPointModel() throws FileNotFoundException, SerializeException {
        this.accessPointListModel = new ServiceAddressListModel();
        Map<String, Collection<ServiceAddress>> accessPoints = this.editConfigManager.loadAccessPoints();
        for (String type : accessPoints.keySet()) {
            for (ServiceAddress serviceAddress : accessPoints.get(type)) {
                this.accessPointListModel.addServiceAddress(serviceAddress);
                if (!type.equals("selected")) continue;
                this.accessPointListModel.setSelected(serviceAddress);
            }
        }
        if (this.accessPointListModel.getSelected() == null && this.accessPointListModel.getSize() > 0) {
            this.accessPointListModel.setSelected(this.accessPointListModel.getServiceAddress(0));
        }
    }

    protected void onSetDefaultButton() {
        if (this.accessPointList.getSelectedIndex() >= 0) {
            this.accessPointListModel.setSelected(this.accessPointListModel.getServiceAddress(this.accessPointList.getSelectedIndex()));
        }
    }

    protected void onAddAccessPointButton() {
        this.ipAddressEditor.validate();
        if (!this.ipAddressEditor.hasErrors()) {
            String address = this.ipAddressEditor.getValue();
            String[] splitted = StringUtils.split((String)address, (String)":");
            int port = 8080;
            if (splitted.length > 0) {
                if (splitted.length == 2) {
                    port = Integer.valueOf(splitted[1]);
                }
                address = splitted[0];
                this.accessPointListModel.addServiceAddress(new ServiceAddress(false, address, port));
            }
            if (this.accessPointListModel.getSize() == 1) {
                this.accessPointListModel.setSelected(this.accessPointListModel.getServiceAddress(0));
            }
        }
    }

    public void show(JFrame parentFrame) {
        try {
            try {
                this.initializeAccessPointModel();
            }
            catch (FileNotFoundException exc) {
                logger.warn("Access point file not found");
            }
            catch (SerializeException exc) {
                logger.warn("Error parsing access point file");
            }
            JTabbedPane tabPane = new JTabbedPane();
            this.labelConfigTab = new LabelConfigTab(this.editConfigManager.loadLabels());
            tabPane.add("Labels", this.labelConfigTab.getPanel());
            tabPane.add("Access Point", this.initializeAccessPointTabComponents());
            final JDialog dialog = new JDialog(parentFrame, "Configuration", true);
            dialog.setDefaultCloseOperation(2);
            dialog.setLayout(new BorderLayout());
            dialog.setResizable(false);
            JPanel buttonPanel = new JPanel(new FlowLayout());
            JButton saveButton = new JButton("Save");
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditConfigView.this.onSaveButton(dialog);
                }
            });
            buttonPanel.add(saveButton);
            dialog.add((Component)tabPane, "Center");
            dialog.add((Component)buttonPanel, "South");
            dialog.pack();
            dialog.setLocationRelativeTo(parentFrame);
            dialog.setVisible(true);
        }
        catch (Throwable exc) {
            logger.error("Failed to load label or access point configuration file");
            logger.logException(exc);
            JOptionPane.showMessageDialog(parentFrame, "Failed to load configuration files", "Error saving config", 0);
        }
    }

    public void onSaveButton(JDialog dialog) {
        try {
            this.saveLabels();
            this.saveAccessPoints();
        }
        catch (SerializeException exc) {
            logger.error("Failed to save label or access point configuration file");
            logger.logException((Throwable)exc);
            JOptionPane.showMessageDialog(dialog, "Failed to save configuration files", "Error saving config", 0);
        }
        dialog.dispose();
    }

    private void saveAccessPoints() throws SerializeException {
        HashMap<String, Collection<ServiceAddress>> accessPointMap = new HashMap<String, Collection<ServiceAddress>>();
        List accessPoints = this.accessPointListModel.getServiceAddresses();
        for (ServiceAddress serviceAddress : accessPoints) {
            if (this.accessPointListModel.getSelected().equals(serviceAddress)) {
                ArrayList<ServiceAddress> selectedList = new ArrayList<ServiceAddress>();
                selectedList.add(serviceAddress);
                accessPointMap.put("selected", selectedList);
                continue;
            }
            if (!accessPointMap.containsKey("not selected")) {
                accessPointMap.put("not selected", new ArrayList());
            }
            ((Collection)accessPointMap.get("not selected")).add(serviceAddress);
        }
        this.editConfigManager.storeAccessPoints(accessPointMap);
    }

    private void saveLabels() throws SerializeException {
        this.editConfigManager.storeLabels(this.labelConfigTab.getLabels());
    }
}

