/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing;

import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.UpdateTaskListener;
import at.mrdevelopment.esl.core.WakeupListener;
import at.mrdevelopment.esl.processing.AddTaskListener;
import at.mrdevelopment.esl.processing.LabelInfoListener;
import at.mrdevelopment.esl.processing.ServiceStatusListener;
import at.mrdevelopment.esl.processing.ServiceTypeChecker;
import at.mrdevelopment.esl.processing.SimpleAccessPointUpdateTaskGenerator;
import at.mrdevelopment.esl.processing.SimpleESLServerProcessing;
import at.mrdevelopment.esl.processing.TaskAbortedListener;
import at.mrdevelopment.esl.processing.TaskErrorListener;
import at.mrdevelopment.esl.processing.UpdateTaskGenerator;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.InitializationException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class SimpleUpdateTaskGenerator
implements UpdateTaskGenerator {
    public static final String DEFAULT_USERNAME = "admin";
    public static final String DEFAULT_PASSWORD = "admin";
    private UpdateTaskGenerator updateTaskGenerator;
    private boolean sendAcceptAllLabels = false;
    private boolean runInBackground = true;
    private boolean isAccessPoint = true;
    private ServiceAddress serviceAddress;

    public SimpleUpdateTaskGenerator(String connectionString) throws InitializationException {
        this(connectionString, true, false);
    }

    public SimpleUpdateTaskGenerator(String connectionString, boolean runInBackground, boolean sendAcceptAllLabels) throws InitializationException {
        ServiceTypeChecker serviceTypeChecker = new ServiceTypeChecker(connectionString);
        try {
            serviceTypeChecker.checkType();
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
        this.isAccessPoint = serviceTypeChecker.isAccessPoint();
        this.serviceAddress = serviceTypeChecker.getServiceAddress();
        if (this.isAccessPoint) {
            this.initializeAccessPoint(this.serviceAddress);
        } else {
            this.initializeServer(this.serviceAddress);
        }
    }

    private void initializeAccessPoint(ServiceAddress serviceAddress) throws InitializationException {
        this.updateTaskGenerator = new SimpleAccessPointUpdateTaskGenerator(serviceAddress.getConnectionString(), 0, this.runInBackground, this.sendAcceptAllLabels);
    }

    private void initializeServer(ServiceAddress serviceAddress) throws InitializationException {
        this.updateTaskGenerator = new SimpleESLServerProcessing(serviceAddress.getHost(), serviceAddress.getPort(), serviceAddress.useSSL(), serviceAddress.hasCredentials() ? serviceAddress.getUsername() : "admin", serviceAddress.hasCredentials() ? serviceAddress.getPassword() : "admin", 0, true, false);
    }

    @Override
    public void taskGenerated(Collection<? extends Task> task, int retryCount) {
        this.updateTaskGenerator.taskGenerated(task, retryCount);
    }

    @Override
    public int getCurrentPingIntervalInMinutes() {
        return this.updateTaskGenerator.getCurrentPingIntervalInMinutes();
    }

    @Override
    public void removeAllLabelsFromAccessPoint() {
        this.updateTaskGenerator.removeAllLabelsFromAccessPoint();
    }

    @Override
    public void removeAllWaitingTasksFromAccessPoint() {
        this.updateTaskGenerator.removeAllWaitingTasksFromAccessPoint();
    }

    @Override
    public void start() {
        this.updateTaskGenerator.start();
    }

    public void shutdown() {
        this.updateTaskGenerator.shutdown();
    }

    @Override
    public Collection<Task> getWaitingTasks() {
        return this.updateTaskGenerator.getWaitingTasks();
    }

    @Override
    public void setLabelsForSendingRoamingTable(List<Address> addresses, boolean forceSendRoamingTable) {
        this.updateTaskGenerator.setLabelsForSendingRoamingTable(addresses, forceSendRoamingTable);
    }

    @Override
    public void addTasks(Collection<? extends Task> tasks) {
        this.updateTaskGenerator.addTasks(tasks);
    }

    @Override
    public void setPingIntervalInMinutes(int pingIntervalInMinutes) {
        this.updateTaskGenerator.setPingIntervalInMinutes(pingIntervalInMinutes);
    }

    @Override
    public void setRoamingValidTimeInMinutes(int roamingValidTimeInMinutes) {
        this.updateTaskGenerator.setRoamingValidTimeInMinutes(roamingValidTimeInMinutes);
    }

    @Override
    public Task getTaskForTaskId(UUID taskId) {
        return this.updateTaskGenerator.getTaskForTaskId(taskId);
    }

    public boolean isAccessPoint() {
        return this.isAccessPoint;
    }

    public ServiceAddress getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    public void setRunWithoutTasks(boolean runWithoutTasks) {
        this.updateTaskGenerator.setRunWithoutTasks(runWithoutTasks);
    }

    @Override
    public boolean isFinished() {
        return this.updateTaskGenerator.isFinished();
    }

    public void registerUpdateTaskListener(UpdateTaskListener listener) {
        this.updateTaskGenerator.registerUpdateTaskListener(listener);
    }

    public void unregisterUpdateTaskListener(UpdateTaskListener listener) {
        this.updateTaskGenerator.unregisterUpdateTaskListener(listener);
    }

    public void registerWakeupListener(WakeupListener listener) {
        this.updateTaskGenerator.registerWakeupListener(listener);
    }

    public void unregisterWakeupListener(WakeupListener listener) {
        this.updateTaskGenerator.unregisterWakeupListener(listener);
    }

    public void notifyReceivedWakeup(WakeupStatistic wakeupStatistic) {
        this.updateTaskGenerator.notifyReceivedWakeup(wakeupStatistic);
    }

    public void notifyReceivedJoinRequest(JoinRequest joinRequest) {
        this.updateTaskGenerator.notifyReceivedJoinRequest(joinRequest);
    }

    @Override
    public void unregisterServiceStatusListener(ServiceStatusListener listener) {
        this.updateTaskGenerator.unregisterServiceStatusListener(listener);
    }

    @Override
    public void registerServiceStatusListener(ServiceStatusListener listener) {
        this.updateTaskGenerator.registerServiceStatusListener(listener);
    }

    @Override
    public void unregisterAddTaskListener(AddTaskListener listener) {
        this.updateTaskGenerator.unregisterAddTaskListener(listener);
    }

    @Override
    public void registerAddTaskListener(AddTaskListener listener) {
        this.updateTaskGenerator.registerAddTaskListener(listener);
    }

    @Override
    public void unregisterTaskErrorListener(TaskErrorListener listener) {
        this.updateTaskGenerator.unregisterTaskErrorListener(listener);
    }

    @Override
    public void registerTaskErrorListener(TaskErrorListener listener) {
        this.updateTaskGenerator.registerTaskErrorListener(listener);
    }

    @Override
    public void unregisterTaskAbortedListener(TaskAbortedListener listener) {
        this.updateTaskGenerator.unregisterTaskAbortedListener(listener);
    }

    @Override
    public void registerTaskAbortedListener(TaskAbortedListener listener) {
        this.updateTaskGenerator.registerTaskAbortedListener(listener);
    }

    @Override
    public void setProcessingIterations(int maxProcessingIterations) {
        this.updateTaskGenerator.setProcessingIterations(maxProcessingIterations);
    }

    @Override
    public void registerLabelInfoListener(LabelInfoListener listener) {
        this.updateTaskGenerator.registerLabelInfoListener(listener);
    }

    @Override
    public void unregisterLabelInfoListener(LabelInfoListener listener) {
        this.updateTaskGenerator.unregisterLabelInfoListener(listener);
    }

    @Override
    public void abortTasks(Collection<UUID> taskIds) {
        this.updateTaskGenerator.abortTasks(taskIds);
    }
}

