/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing;

import at.mrdevelopment.esl.accesspoint.AccessPointReplyCallback;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceClient;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceFactory;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.core.AbstractESLProcessing;
import at.mrdevelopment.esl.core.DefaultReloadRunner;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.PeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ReloadRunner;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.UpdateCreationException;
import at.mrdevelopment.esl.core.UpdateTaskListener;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.processing.SimpleAccessPointCommunication;
import at.mrdevelopment.esl.processing.SimpleTransaction;
import at.mrdevelopment.esl.tasks.AbortRequest;
import at.mrdevelopment.esl.tasks.ErrorTask;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.InternalTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.UpdateImageFactory;
import at.mrdevelopment.esl.type.TaskQueueEntry;
import at.mrdevelopment.esl.type.TaskQueueEntryPriorityComparator;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.updatetask.UpdateTaskFactory;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.ChannelTableEntry;
import at.mrdevelopment.esl.wireless.RoamingAssignment;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class SimpleESLProcessing
extends AbstractESLProcessing
implements AccessPointReplyCallback {
    static ESLLogger logger = ESLLogger.getLogger(SimpleESLProcessing.class);
    private static int DEFAULT_PING_INTERVALL_IN_MINUTES = 1;
    private static int DEFAULT_ROAMING_VALID_TIME_IN_MINUTES = 10;
    private static final Version OLD_VERSION = Version.fromString((String)"1.0.4");
    private static final int REMOVABLE_TASK_CACHE_COUNT = 1000;
    private AccessPointService accessPointService;
    private WirelessChannel wirelessChannel = null;
    protected UpdateTaskFactory updateTaskFactory = new UpdateTaskFactory(new UpdateImageFactory(), true, false);
    private Map<UUID, Task> waitingTasks = new ConcurrentHashMap<UUID, Task>();
    private boolean allowRetries = true;
    protected int maxProcessingIterations = 0;
    private int currentProcessingIteration = 0;
    private boolean runWithoutTasks = false;
    private List<Address> labelAddresses = new ArrayList<Address>();
    private boolean runInBackGround = false;
    private List<UpdateTaskListener> updateTaskListeners = new LinkedList<UpdateTaskListener>();
    private long sendRoamingTableInterval = 180000L;
    private long lastRoamingTableSent = 0L;
    private boolean forceSendRoamingTable = false;
    private int roamingValidTimeInMinutes;
    private int pingIntervalInMinutes;
    private boolean sendAcceptAllLabels = false;
    private Collection<UUID> tasksToAbort = Sets.newSetFromMap(new ConcurrentHashMap());
    private final SimpleAccessPointCommunication communication;
    private final PriorityBlockingQueue<TaskQueueEntry> scheduledTasks = new PriorityBlockingQueue<TaskQueueEntry>(100, new TaskQueueEntryPriorityComparator());
    private final ConcurrentHashMap<UUID, ExternalUpdateTask> currentUpdateTasks = new ConcurrentHashMap();
    private long taskTimeoutMillis = 0L;
    private Set<UUID> removableTasks = Sets.newSetFromMap(new ConcurrentHashMap());

    public SimpleESLProcessing(String accessPointConnectionString) throws InitializationException {
        this(accessPointConnectionString, true, 0, false, false, DEFAULT_ROAMING_VALID_TIME_IN_MINUTES, DEFAULT_PING_INTERVALL_IN_MINUTES, false);
    }

    public SimpleESLProcessing(String accessPointConnectionString, boolean allowRetries, int maxProcessingIterations, boolean runWithoutTasks, boolean runInBackGround, boolean sendAcceptAllLabels, long taskTimeoutMillis) throws InitializationException {
        this(accessPointConnectionString, allowRetries, maxProcessingIterations, runWithoutTasks, runInBackGround, DEFAULT_ROAMING_VALID_TIME_IN_MINUTES, DEFAULT_PING_INTERVALL_IN_MINUTES, sendAcceptAllLabels);
        this.taskTimeoutMillis = taskTimeoutMillis;
    }

    public SimpleESLProcessing(String accessPointConnectionString, boolean allowRetries, int maxProcessingIterations, boolean runWithoutTasks, boolean runInBackGround, boolean sendAcceptAllLabels) throws InitializationException {
        this(accessPointConnectionString, allowRetries, maxProcessingIterations, runWithoutTasks, runInBackGround, DEFAULT_ROAMING_VALID_TIME_IN_MINUTES, DEFAULT_PING_INTERVALL_IN_MINUTES, sendAcceptAllLabels);
    }

    public SimpleESLProcessing(String accessPointConnectionString, boolean allowRetries, int maxProcessingIterations, boolean runWithoutTasks, boolean runInBackGround, int roamingValidTimeInMinutes, int pingIntervalInMinutes, boolean sendAcceptAllLabels) throws InitializationException {
        this.allowRetries = allowRetries;
        this.sendAcceptAllLabels = sendAcceptAllLabels;
        this.runWithoutTasks = runWithoutTasks;
        this.runInBackGround = runInBackGround;
        this.roamingValidTimeInMinutes = roamingValidTimeInMinutes;
        this.pingIntervalInMinutes = pingIntervalInMinutes;
        this.maxProcessingIterations = maxProcessingIterations;
        try {
            AccessPointServiceFactory accessPointServiceFactory = new AccessPointServiceFactory();
            ServiceAddress accessPointAddress = accessPointServiceFactory.loadAddress(accessPointConnectionString);
            Collection<AccessPointService> accessPointServices = accessPointServiceFactory.createServiceInstances(Collections.singleton(accessPointAddress), false);
            this.accessPointService = new ArrayList<AccessPointService>(accessPointServices).get(0);
            this.communication = new SimpleAccessPointCommunication(this, this.accessPointService);
        }
        catch (InitializationException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    @Override
    public void start() {
        if (this.hasProcessingTasks()) {
            throw new IllegalStateException("Processing already started");
        }
        this.createProcessingTasks();
        if (this.runInBackGround) {
            ReloadRunner.startInBackground((ReloadRunner)new DefaultReloadRunner((PeriodicTasksExecutor)this, 5000L), (boolean)true);
        } else {
            ReloadRunner.startInCurrentThread((ReloadRunner)new DefaultReloadRunner((PeriodicTasksExecutor)this, 5000L));
        }
    }

    protected void createProcessingTasks() {
        this.addProcessingTask(new ESLProcessingTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Exception {
                if (SimpleESLProcessing.this.maxProcessingIterations <= 0 || SimpleESLProcessing.this.currentProcessingIteration < SimpleESLProcessing.this.maxProcessingIterations) {
                    SimpleESLProcessing.this.currentProcessingIteration++;
                    SimpleESLProcessing.this.accessPointService.queryServiceStatus(SimpleESLProcessing.this);
                    List list = SimpleESLProcessing.this.labelAddresses;
                    synchronized (list) {
                        long currentTime = System.currentTimeMillis();
                        if (SimpleESLProcessing.this.forceSendRoamingTable || (SimpleESLProcessing.this.labelAddresses.size() > 0 || SimpleESLProcessing.this.sendAcceptAllLabels) && currentTime - SimpleESLProcessing.this.lastRoamingTableSent >= SimpleESLProcessing.this.sendRoamingTableInterval) {
                            try {
                                SimpleESLProcessing.this.accessPointService.sendRoamingTable(SimpleESLProcessing.this.createRoamingTable());
                                SimpleESLProcessing.this.lastRoamingTableSent = currentTime;
                                SimpleESLProcessing.this.forceSendRoamingTable = false;
                            }
                            catch (Exception exc) {
                                logger.warn("Failed to send roaming table");
                                logger.logExceptionIfDebugEnabled((Throwable)exc);
                            }
                        }
                    }
                    logger.info("%d waiting tasks", new Object[]{SimpleESLProcessing.this.waitingTasks.size()});
                    SimpleESLProcessing.this.accessPointService.queryAssignedLabels(SimpleESLProcessing.this);
                    if (!SimpleESLProcessing.this.tasksToAbort.isEmpty()) {
                        try {
                            SimpleESLProcessing.this.abortTasks();
                        }
                        catch (WebserviceException exc) {
                            logger.warn("Unable to abort tasks: %s", new Object[]{exc.getMessage()});
                            logger.logExceptionIfDebugEnabled((Throwable)exc);
                            SimpleESLProcessing.this.tasksToAbort.clear();
                        }
                    }
                    if (SimpleESLProcessing.this.waitingTasks.size() > 0) {
                        SimpleESLProcessing.this.accessPointService.queryUpdateTasks(SimpleESLProcessing.this);
                        SimpleESLProcessing.this.timeoutTasks();
                    }
                    SimpleESLProcessing.this.processScheduledTasks();
                } else {
                    logger.info("Processing stopped after %d iterations", new Object[]{SimpleESLProcessing.this.currentProcessingIteration});
                    SimpleESLProcessing.this.shutdown();
                }
            }
        });
    }

    private void timeoutTasks() {
        if (this.taskTimeoutMillis > 0L) {
            DateTime now = DateTime.now();
            ArrayList<UUID> abortTasks = new ArrayList<UUID>();
            for (Map.Entry<UUID, ExternalUpdateTask> entry : this.currentUpdateTasks.entrySet()) {
                if (!entry.getValue().getCreatedAtTime().plusMillis((int)this.taskTimeoutMillis).isBefore((ReadableInstant)now)) continue;
                abortTasks.add(entry.getKey());
            }
            if (abortTasks.size() > 0) {
                this.addTasksToAbort(abortTasks);
            }
        }
    }

    protected void abortTasks() throws WebserviceException, SerializeException, DatasetException {
        for (UUID taskId : this.tasksToAbort) {
            this.communication.scheduleTaskForAborting(taskId);
        }
        this.tasksToAbort.clear();
    }

    @Override
    public void processServiceStatus(AccessPointService accessPointService, AccessPointServiceStatus serviceStatus) {
        if (serviceStatus.getVersion().isEqualOlder(OLD_VERSION) && accessPointService instanceof AccessPointServiceClient) {
            ((AccessPointServiceClient)accessPointService).setUseOldVersionXMLSerialization(true);
        }
        try {
            this.wirelessChannel = serviceStatus.getChannel();
        }
        catch (RuntimeException exc) {
            logger.warn("Communicating with an Access Point without channel, using default channel 0");
            this.wirelessChannel = WirelessChannel.CHANNEL_0;
        }
        try {
            this.communication.processWorkload(serviceStatus);
        }
        catch (Exception exc) {
            logger.warn("Failed to send scheduled abort requests, remove requetss or update tasks");
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    @Override
    public void failedToQueryAccessPoint(AccessPointService accessPointService) {
    }

    @Override
    public void processUpdateTasks(int accessPointId, Collection<ExternalUpdateTask> receivedUpdateTasks) throws DatasetException {
        this.processUpdateTasksImpl(accessPointId, receivedUpdateTasks);
    }

    public void processUpdateTasksImpl(int accessPointId, Collection<ExternalUpdateTask> receivedUpdateTasks) {
        for (ExternalUpdateTask receivedUpdateTask : receivedUpdateTasks) {
            Task waitingTask = this.waitingTasks.get(receivedUpdateTask.getTaskId());
            if (waitingTask != null) {
                this.updateWaitingTask(waitingTask, receivedUpdateTask);
                continue;
            }
            if (!this.removableTasks.contains(receivedUpdateTask.getTaskId())) continue;
            logger.info("Retry task removal for task %s for label %s", new Object[]{receivedUpdateTask.getTaskId().toString(), receivedUpdateTask.getAddress().toString()});
            this.communication.scheduleTaskForRemoval(receivedUpdateTask.getTaskId());
        }
    }

    @Override
    public void processLabelEvents(int accessPointId, Collection<LabelEvent> labelEvents) {
    }

    @Override
    public void scheduleTask(TaskTransaction transaction, Task task) {
        if (task == null) {
            logger.warn("Task is not allowed to be null");
        } else {
            this.scheduledTasks.add(new TaskQueueEntry(transaction, task));
        }
    }

    @Override
    public void scheduleAbortRequest(AbortRequest abortRequest) {
    }

    public void addTasks(Collection<? extends Task> tasks) {
        SimpleTransaction transaction = new SimpleTransaction(0L);
        for (Task task : tasks) {
            this.scheduleTask((TaskTransaction)transaction, task);
        }
    }

    @Override
    public void shutdown() {
        this.removeWaitingTasks();
        this.runWithoutTasks = false;
        super.shutdown();
    }

    private void removeWaitingTasks() {
        if (!this.waitingTasks.isEmpty()) {
            for (UUID taskId : this.waitingTasks.keySet()) {
                this.communication.scheduleTaskForRemoval(taskId);
            }
        }
    }

    public boolean isFinished() {
        return this.waitingTasks.isEmpty() && !this.runWithoutTasks;
    }

    @Override
    public void processTask(TaskTransaction taskTransaction, Task task, Transaction<?> transaction) {
        if (task instanceof ErrorTask) {
            ErrorTask errorTask = (ErrorTask)task;
            this.processErrorTask(taskTransaction, errorTask, transaction);
        } else if (task instanceof InternalTask) {
            InternalTask internalTask = (InternalTask)task;
            Task convertedTask = this.updateTaskFactory.convertInternalTask(internalTask);
            this.processTask(taskTransaction, convertedTask, transaction);
        } else if (task instanceof ExecutableTask) {
            ExecutableTask executableTask = (ExecutableTask)task;
            this.processExecutableTask(taskTransaction, executableTask, transaction);
        } else {
            ErrorTask errorTask = new ErrorTask(task, UpdateError.ERROR_CODE_UNSUPPORTED_TASK);
            this.processTask(taskTransaction, errorTask, transaction);
        }
    }

    @Override
    public void processAbortRequest(AbortRequest abortRequest, Transaction<?> transaction) {
    }

    protected void processExecutableTask(TaskTransaction taskTransaction, ExecutableTask task, Transaction<?> transaction) {
        UUID taskId = UUID.randomUUID();
        if (task.getExternalId() > 0L) {
            taskId = new UUID(task.getExternalId(), taskId.getLeastSignificantBits());
        }
        try {
            ExternalUpdateTask updateTask = this.updateTaskFactory.createUpdateTask(task, taskId);
            this.scheduleUpdateTask(taskTransaction, task, updateTask);
        }
        catch (UpdateCreationException exc) {
            ErrorTask errorTask = new ErrorTask(task, exc.getUpdateError());
            this.processErrorTask(taskTransaction, errorTask, transaction);
        }
    }

    @Override
    public void processErrorTask(TaskTransaction taskTransaction, ErrorTask errorTask, Transaction<?> transaction) {
        logger.error("Error code %d during processing of task for label %s", new Object[]{errorTask.getUpdateError(), errorTask.getLabelId()});
    }

    public void scheduleUpdateTask(TaskTransaction transaction, Task task, ExternalUpdateTask updateTask) throws UpdateCreationException {
        this.waitingTasks.put(updateTask.getTaskId(), task);
        this.communication.scheduleUpdateTask(transaction, task, updateTask);
        this.notifyUpdateTaskAdded(updateTask);
    }

    protected void notifyUpdateTaskAdded(ExternalUpdateTask updateTask) {
        this.currentUpdateTasks.put(updateTask.getTaskId(), updateTask);
        for (UpdateTaskListener listener : this.updateTaskListeners) {
            listener.updateTaskAdded(updateTask);
        }
    }

    private void notifyUpdateTaskChanged(ExternalUpdateTask updateTask) {
        if (updateTask.isFinished()) {
            this.currentUpdateTasks.remove(updateTask.getTaskId());
        }
        for (UpdateTaskListener listener : this.updateTaskListeners) {
            listener.updateTaskChanged(updateTask);
        }
    }

    protected void processScheduledTasks() {
        while (!this.scheduledTasks.isEmpty()) {
            TaskQueueEntry entry = this.scheduledTasks.poll();
            this.processTask(entry.getTransaction(), entry.getTask(), new Transaction<UpdateStatus>(){

                public void commit() throws DatasetException {
                }

                public void rollback() throws DatasetException {
                }

                public void closeSession() throws DatasetException {
                }

                public boolean isCommitted() {
                    return false;
                }
            });
        }
    }

    protected void updateWaitingTask(Task task, ExternalUpdateTask updateTask) {
        UpdateTaskStatus status = updateTask.getStatus();
        this.notifyUpdateTaskChanged(updateTask);
        if (status.isFinished()) {
            logger.info("Task to label %s %s", new Object[]{updateTask.getAddress(), status});
            this.waitingTasks.remove(updateTask.getTaskId());
            this.communication.scheduleTaskForRemoval(updateTask.getTaskId());
            if (this.removableTasks.size() >= 1000) {
                this.removableTasks.remove(this.removableTasks.iterator().next());
            }
            this.removableTasks.add(updateTask.getTaskId());
            if (status.isUnsuccessful() && this.allowRetries) {
                logger.info("Retrying failed task to label %s", new Object[]{updateTask.getAddress()});
                this.addTasks(Collections.singleton(task));
            }
        }
    }

    protected void processingSendingScheduledTaskError(Transaction<?> transaction) {
        ArrayList<UUID> waitingTasksToRemove = new ArrayList<UUID>();
        for (UUID taskId : this.waitingTasks.keySet()) {
            if (!(this.waitingTasks.get(taskId) instanceof ExecutableTask)) continue;
            ExecutableTask waitingTask = (ExecutableTask)this.waitingTasks.get(taskId);
            try {
                ExternalUpdateTask updateTask = this.updateTaskFactory.createUpdateTask(waitingTask, taskId);
                updateTask.changeStatus(UpdateTaskStatus.ERROR, UpdateError.ERROR_CODE_HTTP_COMMUNICATION);
                this.notifyUpdateTaskChanged(updateTask);
                if (this.allowRetries) {
                    logger.info("Retrying failed task to label %s", new Object[]{updateTask.getAddress()});
                    this.addTasks(Collections.singleton(waitingTask));
                    continue;
                }
                waitingTasksToRemove.add(taskId);
            }
            catch (UpdateCreationException exc) {
                SimpleTransaction taskTransaction = new SimpleTransaction(0L);
                ErrorTask errorTask = new ErrorTask(waitingTask, exc.getUpdateError());
                this.waitingTasks.remove(taskId);
                this.processErrorTask((TaskTransaction)taskTransaction, errorTask, transaction);
            }
        }
        for (UUID taskId : waitingTasksToRemove) {
            this.waitingTasks.remove(taskId);
        }
    }

    protected void removeAllTasksFromAccessPoint() {
        for (UUID taskId : this.waitingTasks.keySet()) {
            this.communication.scheduleTaskForRemoval(taskId);
        }
    }

    public void setRunWithoutTasks(boolean runWithoutTasks) {
        this.runWithoutTasks = runWithoutTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLabelForSendingRoamingTable(Address address) {
        List<Address> list = this.labelAddresses;
        synchronized (list) {
            this.labelAddresses.add(address);
        }
        this.forceSendRoamingTable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabelsForSendingRoamingTable(List<Address> addresses, boolean forceSendRoamingTable) {
        List<Address> list = this.labelAddresses;
        synchronized (list) {
            this.labelAddresses.clear();
            this.labelAddresses.addAll(addresses);
        }
        this.forceSendRoamingTable = forceSendRoamingTable;
    }

    private RoamingTable createRoamingTable() {
        ArrayList<RoamingAssignment> roamingAssignments = new ArrayList<RoamingAssignment>(this.labelAddresses.size());
        for (Address address : this.labelAddresses) {
            LabelType labelType = new LabelId(address).getLabelType();
            roamingAssignments.add(new RoamingAssignment(address, null, labelType, this.accessPointService.getAccessPointId()));
        }
        Set<ChannelTableEntry> channelTable = Collections.singleton(new ChannelTableEntry(this.accessPointService.getAccessPointId(), this.wirelessChannel));
        return new RoamingTable(0, this.roamingValidTimeInMinutes, this.pingIntervalInMinutes, channelTable, roamingAssignments, this.sendAcceptAllLabels, false, true, Key.emptyKey(), SyncProfile.RETAIL_DEFAULT);
    }

    public void registerUpdateTaskListener(UpdateTaskListener listener) {
        this.updateTaskListeners.add(listener);
    }

    public Collection<Task> getWaitingTasks() {
        return this.waitingTasks.values();
    }

    public Task getTaskForTaskId(UUID taskId) {
        return this.waitingTasks.get(taskId);
    }

    protected void removeAllLabelsFromAccessPoint() {
        try {
            this.accessPointService.sendRoamingTable(new RoamingTable());
        }
        catch (WebserviceException exc) {
            logger.warn("Failed to send empty roaming table");
        }
        catch (SerializeException exc) {
            logger.warn("Failed to send empty roaming table");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer labelCountForSendingRoamingTable() {
        int count = 0;
        List<Address> list = this.labelAddresses;
        synchronized (list) {
            count = this.labelAddresses.size();
        }
        return count;
    }

    public void setPingIntervalInMinutes(int pingIntervalInMinutes) {
        this.pingIntervalInMinutes = pingIntervalInMinutes;
    }

    public int getPingIntervalInMinutes() {
        return this.pingIntervalInMinutes;
    }

    public void setRoamingValidTimeInMinutes(int roamingValidTimeInMinutes) {
        this.roamingValidTimeInMinutes = roamingValidTimeInMinutes;
    }

    public int getRoamingValidTimeInMinutes() {
        return this.roamingValidTimeInMinutes;
    }

    public WirelessChannel getChannel() {
        return this.wirelessChannel;
    }

    public int getAccessPointId() {
        return this.accessPointService.getAccessPointId();
    }

    public static ExternalUpdateTask convertToUpdateTask(Task task, UUID taskId, UpdateTaskFactory updateTaskFactory) {
        if (task instanceof InternalTask) {
            task = updateTaskFactory.convertInternalTask((InternalTask)task);
        }
        if (task instanceof ExecutableTask) {
            try {
                return updateTaskFactory.createUpdateTask((ExecutableTask)task, taskId);
            }
            catch (UpdateCreationException exc) {
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                return new ExternalUpdateTask(taskId, task.getLabelId().toAddress(), task.getPriority()){};
            }
        }
        return new ExternalUpdateTask(taskId, task.getLabelId().toAddress(), task.getPriority()){};
    }

    protected void addTasksToAbort(Collection<UUID> taskIds) {
        this.tasksToAbort.addAll(taskIds);
    }

    public boolean hasTasksToAbort() {
        return !this.tasksToAbort.isEmpty();
    }
}

