/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing;

import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.UpdateTaskListener;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.processing.AddTaskListener;
import at.mrdevelopment.esl.processing.LabelInfoListener;
import at.mrdevelopment.esl.processing.ServiceStatusListener;
import at.mrdevelopment.esl.processing.SimpleESLProcessing;
import at.mrdevelopment.esl.processing.TaskAbortedListener;
import at.mrdevelopment.esl.processing.TaskErrorListener;
import at.mrdevelopment.esl.processing.UpdateTaskGenerator;
import at.mrdevelopment.esl.tasks.ErrorTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.toolkit.InitializationException;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;

public class SimpleAccessPointUpdateTaskGenerator
extends SimpleESLProcessing
implements UpdateTaskGenerator {
    private int currentPingIntervalInMinutes;
    private Set<ServiceStatusListener> serviceStatusListeners = new CopyOnWriteArraySet<ServiceStatusListener>();
    private Set<AddTaskListener> addTaskListeners = new CopyOnWriteArraySet<AddTaskListener>();
    private Set<TaskErrorListener> taskErrorListeners = new CopyOnWriteArraySet<TaskErrorListener>();
    private Set<TaskAbortedListener> taskAbortedListeners = new CopyOnWriteArraySet<TaskAbortedListener>();

    public SimpleAccessPointUpdateTaskGenerator(String accessPointConnectionString, int maxProcessingIterations, boolean runInBackground, boolean sendAcceptAllLabels) throws InitializationException {
        super(accessPointConnectionString, false, maxProcessingIterations, true, runInBackground, sendAcceptAllLabels);
    }

    @Override
    public void processWakeupStatistics(Collection<WakeupStatistic> receivedWakeupStatistics) {
        for (WakeupStatistic wakeupStatistic : receivedWakeupStatistics) {
            this.notifyReceivedWakeup(wakeupStatistic);
        }
    }

    @Override
    public void addTasks(Collection<? extends Task> tasks) {
        super.addTasks(tasks);
    }

    @Override
    public void processJoinRequests(Collection<JoinRequest> joinRequests) {
    }

    @Override
    public void failedToQueryAccessPoint(AccessPointService accessPointService) {
        if (this.serviceStatusListeners != null) {
            for (ServiceStatusListener serviceStatusListener : this.serviceStatusListeners) {
                serviceStatusListener.notifyServiceStatus(null);
            }
        }
    }

    @Override
    public void processErrorTask(TaskTransaction taskTransaction, ErrorTask errorTask, Transaction<?> transaction) {
        UUID taskId = UUID.randomUUID();
        ExternalUpdateTask updateTask = new ExternalUpdateTask(taskId, errorTask.getLabelId().toAddress(), errorTask.getPriority()){};
        updateTask.changeStatus(UpdateTaskStatus.ERROR, errorTask.getUpdateError());
        this.notifyErrorTaskAdded(errorTask, errorTask, updateTask);
    }

    private void notifyErrorTaskAdded(Task task, ErrorTask errorTask, ExternalUpdateTask updateTask) {
        if (this.taskErrorListeners != null) {
            for (TaskErrorListener listener : this.taskErrorListeners) {
                listener.notifyErrorTaskAdded(task, errorTask, updateTask);
            }
        }
    }

    @Override
    public void removeAllWaitingTasksFromAccessPoint() {
        this.removeAllTasksFromAccessPoint();
    }

    @Override
    public void removeAllLabelsFromAccessPoint() {
        super.removeAllLabelsFromAccessPoint();
    }

    @Override
    public void taskGenerated(Collection<? extends Task> tasks, int retryCount) {
        this.addTasks(tasks);
        this.notifyAddTaskListener(tasks, retryCount);
    }

    private void notifyAddTaskListener(Collection<? extends Task> tasks, int retryCount) {
        for (AddTaskListener listener : this.addTaskListeners) {
            listener.taskAdded(tasks, retryCount);
        }
    }

    public void unregisterUpdateTaskListener(UpdateTaskListener listener) {
    }

    @Override
    public void processServiceStatus(AccessPointService accessPointService, AccessPointServiceStatus serviceStatus) {
        this.currentPingIntervalInMinutes = serviceStatus.getPingIntervall();
        if (this.serviceStatusListeners != null) {
            for (ServiceStatusListener serviceStatusListener : this.serviceStatusListeners) {
                serviceStatusListener.notifyServiceStatus(serviceStatus.getServiceStatus());
            }
        }
        super.processServiceStatus(accessPointService, serviceStatus);
    }

    @Override
    public int getCurrentPingIntervalInMinutes() {
        return this.currentPingIntervalInMinutes;
    }

    @Override
    public void unregisterServiceStatusListener(ServiceStatusListener serviceStatusListener) {
        this.serviceStatusListeners.remove(serviceStatusListener);
    }

    @Override
    public void registerServiceStatusListener(ServiceStatusListener listener) {
        this.serviceStatusListeners.add(listener);
    }

    @Override
    public void unregisterAddTaskListener(AddTaskListener listener) {
        this.addTaskListeners.remove(listener);
    }

    @Override
    public void registerAddTaskListener(AddTaskListener listener) {
        this.addTaskListeners.add(listener);
    }

    @Override
    public void unregisterTaskErrorListener(TaskErrorListener listener) {
        this.taskErrorListeners.remove(listener);
    }

    @Override
    public void registerTaskErrorListener(TaskErrorListener listener) {
        this.taskErrorListeners.add(listener);
    }

    @Override
    public void unregisterTaskAbortedListener(TaskAbortedListener listener) {
        this.taskAbortedListeners.remove(listener);
    }

    @Override
    public void registerTaskAbortedListener(TaskAbortedListener listener) {
        this.taskAbortedListeners.add(listener);
    }

    @Override
    public void setProcessingIterations(int maxProcessingIterations) {
        this.maxProcessingIterations = maxProcessingIterations;
    }

    @Override
    public void registerLabelInfoListener(LabelInfoListener listener) {
    }

    @Override
    public void unregisterLabelInfoListener(LabelInfoListener listener) {
    }

    @Override
    public void abortTasks(Collection<UUID> taskIds) {
        super.addTasksToAbort(taskIds);
    }
}

