/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing;

import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.accesspoint.AccessPointWorkload;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.processing.SimpleESLProcessing;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SimpleAccessPointCommunication {
    static ESLLogger logger = ESLLogger.getLogger(SimpleAccessPointCommunication.class);
    private static final int ACCESSPOINT_MAX_SEND_TASKS_COUNT = 10000;
    private static final int ACCESSPOINT_MAX_SEND_TASKS_SIZE = 0x100000;
    private static final int ACCESSPOINT_MAX_TOTAL_TASKS_COUNT = 50000;
    private static final int ACCESSPOINT_MAX_TOTAL_TASKS_SIZE = 0x600000;
    private static final int MAX_TASK_BATCH_COUNT = 1000;
    private final AccessPointService accessPointService;
    private final AccessPointWorkload accessPointWorkload = new AccessPointWorkload();
    private final ConcurrentLinkedQueue<ExternalUpdateTask> unassignedUpdateTasks = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<UUID> tasksToAbort = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<UUID> tasksToRemove = new ConcurrentLinkedQueue();
    private final Map<UUID, Task> taskMapping = new ConcurrentHashMap<UUID, Task>();
    private final Map<UUID, TaskTransaction> transactionMapping = new ConcurrentHashMap<UUID, TaskTransaction>();
    private final SimpleESLProcessing processing;

    public SimpleAccessPointCommunication(SimpleESLProcessing processing, AccessPointService accessPointService) {
        this.accessPointService = accessPointService;
        this.processing = processing;
    }

    public void scheduleUpdateTask(TaskTransaction transaction, Task task, ExternalUpdateTask updateTask) {
        this.unassignedUpdateTasks.add(updateTask);
        this.taskMapping.put(updateTask.getTaskId(), task);
        this.transactionMapping.put(updateTask.getTaskId(), transaction);
    }

    private void handleUnassignedTaskAbort(ExternalUpdateTask updateTask) {
        updateTask.changeStatus(UpdateTaskStatus.CANCELED, null);
        this.tasksToAbort.remove(updateTask.getTaskId());
        this.taskMapping.remove(updateTask.getTaskId());
        this.transactionMapping.remove(updateTask.getTaskId());
        this.processing.processUpdateTasksImpl(this.accessPointService.getAccessPointId(), Collections.singleton(updateTask));
    }

    private void handleUnassignedTaskRemoval(ExternalUpdateTask updateTask) {
        this.tasksToRemove.remove(updateTask.getTaskId());
    }

    private boolean taskScheduledForAbort(UUID taskId) {
        return this.tasksToAbort.contains(taskId);
    }

    private boolean taskScheduledForRemoval(UUID taskId) {
        return this.tasksToRemove.contains(taskId);
    }

    public void scheduleTaskForRemoval(UUID taskId) {
        if (this.taskMapping.containsKey(taskId)) {
            this.tasksToRemove.add(taskId);
        }
        this.accessPointWorkload.scheduleTaskForRemoval(taskId);
    }

    public void scheduleTaskForAborting(UUID taskId) {
        if (this.taskMapping.containsKey(taskId)) {
            this.tasksToAbort.add(taskId);
        }
        this.accessPointWorkload.scheduleTaskForAborting(taskId);
    }

    public synchronized void processWorkload(AccessPointServiceStatus serviceStatus) throws WebserviceException, SerializeException {
        if (serviceStatus != null && !this.unassignedUpdateTasks.isEmpty()) {
            boolean canAssignUpdateTasks;
            int currentTaskCount = serviceStatus.getTasksCount();
            int currentTaskSize = serviceStatus.getTasksSize();
            logger.debug("%d unassigned tasks", new Object[]{this.unassignedUpdateTasks.size()});
            boolean bl = canAssignUpdateTasks = this.accessPointWorkload.getScheduledUpdateTaskCount() < 10000 && this.accessPointWorkload.getScheduledUpdateTaskSize() < 0x100000 && currentTaskCount < 50000 && currentTaskSize < 0x600000;
            if (canAssignUpdateTasks) {
                while (this.accessPointWorkload.getScheduledUpdateTaskCount() < 10000 && this.accessPointWorkload.getScheduledUpdateTaskSize() < 0x100000 && currentTaskCount < 50000 && currentTaskSize < 0x600000 && this.unassignedUpdateTasks.size() > 0 && currentTaskCount < 1000) {
                    ExternalUpdateTask updateTask = this.unassignedUpdateTasks.poll();
                    if (this.taskScheduledForRemoval(updateTask.getTaskId())) {
                        this.handleUnassignedTaskRemoval(updateTask);
                        continue;
                    }
                    if (this.taskScheduledForAbort(updateTask.getTaskId())) {
                        this.handleUnassignedTaskAbort(updateTask);
                        continue;
                    }
                    this.accessPointWorkload.scheduleUpdateTask(updateTask);
                    this.taskMapping.remove(updateTask.getTaskId());
                    this.transactionMapping.remove(updateTask.getTaskId());
                    ++currentTaskCount;
                    currentTaskSize += updateTask.getSize();
                }
                logger.debug("Sending %d (%d) scheduled tasks to access point %d (tasks: %d, size: %d)", new Object[]{this.accessPointWorkload.getScheduledUpdateTaskCount(), this.accessPointWorkload.getScheduledUpdateTaskSize(), this.accessPointService.getAccessPointId(), currentTaskCount, currentTaskSize});
            }
        }
        List<ExternalUpdateTask> scheduledUpdateTasks = this.accessPointWorkload.getScheduledUpdateTasks();
        this.accessPointService.sendAbortRequests(this.accessPointWorkload.getTasksToAbort());
        this.accessPointService.sendRemoveRequests(this.accessPointWorkload.getTasksToRemove());
        if (!scheduledUpdateTasks.isEmpty()) {
            this.accessPointService.sendTasks(scheduledUpdateTasks);
        }
        this.accessPointWorkload.clear();
        if (this.unassignedUpdateTasks.isEmpty()) {
            this.taskMapping.clear();
            this.transactionMapping.clear();
            this.tasksToAbort.clear();
            this.tasksToRemove.clear();
        }
    }
}

