/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryUpdatePermissions;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Editable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.esl.persistence.record.KeepDeletedRecord;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.security.AuthenticationUser;
import at.mrdevelopment.toolkit.security.Password;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ESL_USER")
public class User
extends KeepDeletedRecord
implements UserId {
    public static final String USERNAME = "USERNAME";
    public static final String FIRST_NAME = "FIRST_NAME";
    public static final String LAST_NAME = "LAST_NAME";
    public static final String MAIL_ADDRESS = "MAIL_ADDRESS";
    public static final String ROLE = "ROLE";
    public static final String PASSWORD_HASH = "PASSWORD_HASH";
    public static final String API_ACCESS = "API_ACCESS";
    public static final String API_TOKEN = "API_TOKEN";
    private static final Boolean DEFAULT_API_ACCESS = true;
    private String username;
    private String firstName;
    private String lastName;
    private String mailAddress;
    private Role role;
    private String passwordHash;
    private Boolean apiAccess;
    private String apiToken;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryUpdatePermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryUpdatePermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public User() {
        this.role = Role.READONLY;
    }

    public User(String username, String firstName, String lastName, String mailAddress, Role role, String passwordHash, Boolean apiAccess, String apiToken) {
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.mailAddress = mailAddress;
        this.role = role;
        this.passwordHash = passwordHash;
        this.apiAccess = apiAccess;
        this.apiToken = apiToken;
    }

    @Column(name="USERNAME", nullable=false, unique=true)
    @Displayable(name="User", width=2, order=1)
    @Editable(createOnly=true)
    @Serialize
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Column(name="FIRST_NAME", nullable=true)
    @Displayable(name="First Name", width=3, order=2)
    @Editable
    @Serialize
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LAST_NAME", nullable=true)
    @Displayable(name="Last Name", width=4, order=3)
    @Editable
    @Serialize
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="MAIL_ADDRESS", nullable=true)
    @Displayable(name="E-Mail", width=4, order=4)
    @Editable
    @Serialize
    public String getMailAddress() {
        return this.mailAddress;
    }

    public void setMailAddress(String mailAddress) {
        this.mailAddress = mailAddress;
    }

    @Column(name="ROLE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @Displayable(name="Role", width=2, order=5)
    @Editable
    @Serialize
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @Column(name="PASSWORD_HASH", nullable=false)
    @Displayable(name="Password", width=1, order=6, hide=true)
    @UserType(value=Password.class)
    @Editable(createOnly=true)
    @Serialize
    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    @Column(name="API_ACCESS")
    @Displayable(name="API Access", width=1, order=7)
    @Editable
    @Serialize
    public Boolean getApiAccess() {
        return this.apiAccess == null ? DEFAULT_API_ACCESS : this.apiAccess;
    }

    public void setApiAccess(Boolean apiAccess) {
        this.apiAccess = apiAccess;
    }

    @Column(name="API_TOKEN", nullable=true)
    @Displayable(name="API Token", width=1, order=8)
    @Editable
    @Serialize
    public String getApiToken() {
        return this.apiToken;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    @Transient
    public AuthenticationUser getAuthenticationUser() {
        return new AuthenticationUser(this.username, this.passwordHash);
    }

    @Override
    @Transient
    public String getIdentifier() {
        return this.username;
    }

    @Override
    @Transient
    public String getName() {
        return this.username;
    }

    @Transient
    public boolean isAuthorized() {
        return true;
    }
}

