/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryDeletePermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.IncludeDisplayables;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.esl.persistence.record.UpdateRecord;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="ESL_UPDATE_HISTORY")
public class UpdateStatus
extends Record
implements UpdateRecord {
    public static final String TASK_RECORD_ID = "ESL_TASK_ID";
    public static final String TASK_ID = "TASK_ID";
    public static final String STATUS = "STATUS";
    public static final String ERROR_CODE = "ERROR_CODE";
    public static final String ACCESS_POINT_ID = "ACCESS_POINT_ID";
    public static final String RSSI = "RSSI";
    public static final String LQI = "LQI";
    public static final String TRANSMISSION_TIME = "TRANSMISSION_TIME";
    public static final String POWER_STATUS = "POWER_STATUS";
    public static final String RETRIES_LEFT = "RETRIES_LEFT";
    public static final String INTERNAL = "INTERNAL";
    private TaskRecord taskRecord;
    private UUID taskId;
    private Status status;
    private UpdateError updateError;
    private Integer accessPointId;
    private PowerStatus powerStatus;
    private Integer rssi;
    private Integer lqi;
    private Integer transmissionTime;
    private Integer retriesLeft;
    private Boolean internal;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryDeletePermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public UpdateStatus() {
    }

    public UpdateStatus(TaskRecord taskRecord, UUID taskId, Status status, UpdateError updateError, Integer retriesLeft) {
        this.taskRecord = taskRecord;
        this.taskId = taskId;
        this.status = status;
        this.updateError = updateError;
        this.retriesLeft = retriesLeft;
        this.internal = taskRecord.getInternal();
    }

    @Column(name="CREATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Index(name="IDX_ESL_UPDATE_HISTORY_CREATED")
    @Serialize
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE})
    @JoinColumn(name="ESL_TASK_ID")
    @IncludeDisplayables
    @Serialize(recursive=true, archive=true)
    @ForeignKey(name="none")
    @NotFound(action=NotFoundAction.IGNORE)
    public TaskRecord getTaskRecord() {
        return this.taskRecord;
    }

    public void setTaskRecord(TaskRecord taskRecord) {
        this.taskRecord = taskRecord;
    }

    @Override
    @Column(name="STATUS", nullable=false)
    @Index(name="IDX_STATUS")
    @Enumerated(value=EnumType.STRING)
    @Displayable(name="Task Status", width=4, order=50)
    @Serialize(archive=true)
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Column(name="ERROR_CODE", nullable=true)
    @Serialize(archive=true)
    public Integer getErrorCode() {
        return this.updateError != null ? Integer.valueOf(this.updateError.getCode()) : null;
    }

    public void setErrorCode(Integer errorCode) {
        this.updateError = errorCode != null ? UpdateError.valueOf((int)errorCode) : null;
    }

    @Displayable(name="Error Code", width=1, filter=false, order=51)
    @Transient
    public UpdateError getUpdateError() {
        return this.updateError;
    }

    public void setUpdateError(UpdateError updateError) {
        this.updateError = updateError;
    }

    @Override
    @Column(name="TASK_ID", nullable=false)
    @Index(name="IDX_TASK_ID")
    @Type(type="uuid-char")
    @Displayable(name="Task ID", width=1, filter=false, order=52)
    @Serialize
    public UUID getTaskId() {
        return this.taskId;
    }

    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    @Column(name="ACCESS_POINT_ID", nullable=true)
    @Displayable(name="AP ID", width=2, order=53)
    @Serialize(archive=true)
    public Integer getAccessPointId() {
        return this.accessPointId;
    }

    public void setAccessPointId(Integer accessPointId) {
        this.accessPointId = accessPointId;
    }

    @Column(name="POWER_STATUS", nullable=true)
    @Serialize(archive=true)
    public PowerStatus getPowerStatus() {
        return this.powerStatus;
    }

    public void setPowerStatus(PowerStatus powerStatus) {
        this.powerStatus = powerStatus;
    }

    @Column(name="RSSI", nullable=true)
    @Displayable(name="RSSI", width=1, filter=false, order=54)
    @Serialize(archive=true)
    public Integer getRssi() {
        return this.rssi;
    }

    public void setRssi(Integer rssi) {
        this.rssi = rssi;
    }

    @Column(name="LQI", nullable=true)
    @Displayable(name="LQI", width=1, filter=false, order=55)
    @Serialize(archive=true)
    public Integer getLqi() {
        return this.lqi;
    }

    public void setLqi(Integer lqi) {
        this.lqi = lqi;
    }

    @Column(name="TRANSMISSION_TIME", nullable=true)
    @Displayable(name="TX Time", width=1, filter=false, order=56)
    @Serialize(archive=true)
    public Integer getTransmissionTime() {
        return this.transmissionTime;
    }

    public void setTransmissionTime(Integer transmissionTime) {
        this.transmissionTime = transmissionTime;
    }

    @Column(name="RETRIES_LEFT", nullable=false)
    @Index(name="IDX_RETRIES_LEFT")
    @Displayable(name="Retries Left", width=1, filter=false, order=57)
    @Serialize(archive=true)
    public Integer getRetriesLeft() {
        return this.retriesLeft;
    }

    public void setRetriesLeft(Integer retriesLeft) {
        this.retriesLeft = retriesLeft;
    }

    @Column(name="INTERNAL", nullable=true)
    @Index(name="IDX_UPDATE_STATUS_INTERNAL")
    @Type(type="org.hibernate.type.NumericBooleanType")
    public Boolean getInternal() {
        return this.internal;
    }

    public void setInternal(Boolean internal) {
        this.internal = internal;
    }

    @Override
    @Transient
    public String getIdentifier() {
        return this.taskId == null ? "New" : this.taskId.toString();
    }

    @Override
    @Transient
    public LabelId getLabelId() {
        return this.taskRecord != null ? this.taskRecord.getLabelId() : null;
    }

    @Override
    @Transient
    public TaskType getTaskType() {
        return this.taskRecord != null ? this.taskRecord.getTaskType() : null;
    }

    @Override
    public void onCreate(UserId user) {
        super.onCreate(user);
        this.taskRecord.onUpdate(user);
    }

    @Transient
    @Serialize
    public DateTime getRetriesValidUntil() {
        if (this.taskRecord != null) {
            return this.taskRecord.getRetryValidUntil();
        }
        return null;
    }
}

