/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="ESL_UPDATE_IMAGE")
public class UpdateImage
implements Serializable {
    public static final String ID = "ID";
    public static final String CREATED_AT = "CREATED_AT";
    public static final String IMAGE = "IMAGE";
    public static final String HASH = "HASH";
    private Long id;
    private DateTime createdAt;
    private byte[] image;
    private byte[] hash;
    private List<TaskRecord> taskRecords = new ArrayList<TaskRecord>(0);

    public UpdateImage() {
    }

    public UpdateImage(byte[] image) throws SerializeException {
        this.setCreatedAt(DateTime.now());
        this.image = image;
        this.hash = ImageSerializer.calculateHash((byte[])image);
    }

    public UpdateImage(BufferedImage image) throws SerializeException {
        this.setCreatedAt(DateTime.now());
        this.image = ImageSerializer.toBase64((BufferedImage)image);
        this.hash = ImageSerializer.calculateHash((byte[])this.image);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="CREATED_AT", nullable=true)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Index(name="IDX_ESL_UPDATE_IMAGE_CREATED")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Column(name="IMAGE", length=48000, nullable=true)
    @Lob
    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    @Column(name="HASH", length=64, nullable=true)
    public byte[] getHash() {
        return this.hash;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    @OneToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE}, fetch=FetchType.LAZY)
    @JoinColumn(name="ESL_UPDATE_IMAGE_ID")
    @Index(name="IDX_ESL_UPDATE_IMAGE_ID", columnNames={"ESL_UPDATE_IMAGE_ID"})
    @ForeignKey(name="none")
    @NotFound(action=NotFoundAction.IGNORE)
    public List<TaskRecord> getTaskRecords() {
        return this.taskRecords;
    }

    public void setTaskRecords(List<TaskRecord> taskRecords) {
        this.taskRecords = taskRecords;
    }

    @Transient
    public BufferedImage getBufferedImage() throws SerializeException {
        return ImageSerializer.fromBase64((byte[])this.image);
    }
}

