/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryDeletePermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.esl.persistence.record.LabelIdRecord;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.persistence.record.TransactionRecord;
import at.mrdevelopment.esl.persistence.record.UpdateImage;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.tasks.ErrorTask;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="ESL_TASK")
public class TaskRecord
extends Record
implements LabelIdRecord {
    public static final String LABEL_SERIAL = "LABEL_SERIAL";
    public static final String TASK_TYPE = "TASK_TYPE";
    public static final String PRIORITY = "PRIORITY";
    public static final String EXTERNAL_ID = "EXTERNAL_ID";
    public static final String PAGE = "PAGE";
    public static final String DATA = "DATA";
    public static final String TRANSACTION_ID = "ESL_TRANSACTION_ID";
    public static final String UPDATE_IMAGE_ID = "ESL_UPDATE_IMAGE_ID";
    public static final String REPLACE_WAITING_TASKS = "REPLACE_WAITING_TASKS";
    public static final String SKIP_ON_EQUAL_IMAGE = "SKIP_ON_EQUAL_IMAGE";
    public static final String INTERNAL = "INTERNAL";
    public static final String RETRY = "RETRY_VALID_UNTIL";
    private Long label;
    private TaskType taskType;
    private TaskPriority priority;
    private Long externalId;
    private Integer page;
    private TransactionRecord transaction;
    private String data;
    private UpdateImage updateImage;
    private Boolean replaceWaitingTasks;
    private Boolean skipOnEqualImage;
    private List<UpdateStatus> updateStatusList = new ArrayList<UpdateStatus>(0);
    private Boolean internal;
    private DateTime retryValidUntil;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryDeletePermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public TaskRecord() {
    }

    public TaskRecord(TransactionRecord transaction, ExecutableTask task, int retries) throws SerializeException {
        this(transaction, (Task)task, retries);
        this.taskType = task.getTaskType();
        this.internal = transaction.getInternal();
    }

    public TaskRecord(TransactionRecord transaction, ErrorTask task) throws SerializeException {
        this(transaction, task, 0);
        this.taskType = task.getTaskType();
        this.internal = transaction.getInternal();
    }

    private TaskRecord(TransactionRecord transaction, Task task, int retries) throws SerializeException {
        this.transaction = transaction;
        this.label = task.getLabelId().getId();
        this.priority = task.getPriority();
        this.externalId = task.getExternalId();
        this.page = task.getPage() != null ? Integer.valueOf(task.getPage().getPageIndex()) : null;
        this.data = task.getData();
        this.updateImage = task.getImage() != null ? new UpdateImage(task.getImage()) : null;
        this.replaceWaitingTasks = task.isReplaceWaitingTasks();
        this.skipOnEqualImage = task.isSkipOnEqualImage();
        this.internal = transaction.getInternal();
        if (task.getRetryValidInMinutes() != null) {
            this.retryValidUntil = DateTime.now().plusMinutes(task.getRetryValidInMinutes().intValue());
        }
    }

    @Column(name="CREATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Index(name="IDX_ESL_TASK_CREATED_AT")
    @Serialize
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Column(name="LABEL_SERIAL", nullable=false)
    @Index(name="IDX_LABEL_SERIAL")
    @Displayable(name="Label ID", width=4, order=1)
    @UserType(value=LabelId.class)
    @Serialize(archive=true)
    public Long getLabel() {
        return this.label;
    }

    public void setLabel(Long label) {
        this.label = label;
    }

    @Column(name="TASK_TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @Displayable(name="Task Type", width=3, order=4)
    @Serialize(archive=true)
    public TaskType getTaskType() {
        return this.taskType;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    @Column(name="PRIORITY", nullable=false)
    @Displayable(name="Priority", width=3, filter=false, order=3)
    @Serialize(archive=true)
    public TaskPriority getPriority() {
        return this.priority;
    }

    public void setPriority(TaskPriority priority) {
        this.priority = priority;
    }

    @Column(name="EXTERNAL_ID", nullable=true)
    @Displayable(name="External ID", width=1, filter=false, order=2)
    @Serialize(archive=true)
    public Long getExternalId() {
        return this.externalId;
    }

    public void setExternalId(Long externalId) {
        this.externalId = externalId;
    }

    @Column(name="PAGE", nullable=true)
    @Displayable(name="Page", width=1, filter=false, order=5)
    @UserType(value=Page.class)
    @Serialize(archive=true)
    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="ESL_TRANSACTION_ID", insertable=true, updatable=false)
    @Index(name="IDX_ESL_TRANSACTION_ID", columnNames={"ESL_TRANSACTION_ID"})
    @ForeignKey(name="none")
    @NotFound(action=NotFoundAction.IGNORE)
    public TransactionRecord getTransaction() {
        return this.transaction;
    }

    public void setTransaction(TransactionRecord transaction) {
        this.transaction = transaction;
    }

    @Column(name="DATA", nullable=true)
    @UserType(value=String.class)
    @Serialize
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ESL_UPDATE_IMAGE_ID")
    @Index(name="IDX_ESL_UPDATE_IMAGE_ID", columnNames={"ESL_UPDATE_IMAGE_ID"})
    @ForeignKey(name="none")
    @NotFound(action=NotFoundAction.IGNORE)
    public UpdateImage getUpdateImage() {
        return this.updateImage;
    }

    public void setUpdateImage(UpdateImage updateImage) {
        this.updateImage = updateImage;
    }

    @Column(name="REPLACE_WAITING_TASKS", nullable=true)
    @Serialize(archive=true)
    public Boolean getReplaceWaitingTasks() {
        return this.replaceWaitingTasks;
    }

    public void setReplaceWaitingTasks(Boolean replaceWaitingTasks) {
        this.replaceWaitingTasks = replaceWaitingTasks;
    }

    @Column(name="SKIP_ON_EQUAL_IMAGE", nullable=true)
    @Serialize(archive=true)
    public Boolean getSkipOnEqualImage() {
        return this.skipOnEqualImage;
    }

    public void setSkipOnEqualImage(Boolean skipOnEqualImage) {
        this.skipOnEqualImage = skipOnEqualImage;
    }

    @OneToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE}, fetch=FetchType.LAZY)
    @JoinColumn(name="ESL_TASK_ID", insertable=false, updatable=false)
    @Index(name="IDX_ESL_TASK_ID", columnNames={"ESL_TASK_ID"})
    @ForeignKey(name="none")
    @NotFound(action=NotFoundAction.IGNORE)
    public List<UpdateStatus> getUpdateStatusList() {
        return this.updateStatusList;
    }

    public void setUpdateStatusList(List<UpdateStatus> updateStatusList) {
        this.updateStatusList = updateStatusList;
    }

    @Column(name="INTERNAL", nullable=true)
    @Index(name="IDX_TASK_INTERNAL")
    @Type(type="org.hibernate.type.NumericBooleanType")
    public Boolean getInternal() {
        return this.internal;
    }

    public void setInternal(Boolean internal) {
        this.internal = internal;
    }

    @Column(name="RETRY_VALID_UNTIL", nullable=true)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Displayable(name="Retry valid until", width=4, filter=false, order=100, ignoreOnRecursion=true)
    @Serialize
    public DateTime getRetryValidUntil() {
        return this.retryValidUntil;
    }

    public void setRetryValidUntil(DateTime retryValidUntil) {
        this.retryValidUntil = retryValidUntil;
    }

    @Transient
    public boolean hasExternalId() {
        return this.externalId != null;
    }

    @Transient
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    @Transient
    public LabelId getLabelId() {
        return new LabelId(this.label);
    }

    @Override
    @Transient
    @Serialize
    public String getLabelIdString() {
        return this.getLabelId().getLabelIdString();
    }

    @Override
    @Transient
    public String getName() {
        return new LabelId(this.label).toString();
    }

    @Transient
    @Serialize(archive=true)
    public Long getTransactionId() {
        return this.transaction != null ? this.transaction.getId() : null;
    }

    @Transient
    public boolean isValidRetry() {
        if (this.retryValidUntil == null) {
            return false;
        }
        return this.getRetryValidUntil().isAfterNow();
    }
}

