/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.BaseRecord;
import at.mrdevelopment.toolkit.authentication.Role;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

public class RequestHistoryRecord
extends BaseRecord {
    private Long id;
    private DateTime timestamp;
    private String method;
    private String uri;
    private String remoteAddress;
    private long elapsedTime;
    private int status;
    private String principal;
    private String authScheme;
    private String userAgent;
    private String errorMessage;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public RequestHistoryRecord(Long id, DateTime timestamp, String method, String uri, String remoteAddress, String userAgent, long elapsedTime, int status, String principal, String authScheme, String errorMessage) {
        this.id = id;
        this.timestamp = timestamp;
        this.method = method;
        this.uri = uri;
        this.remoteAddress = remoteAddress;
        this.userAgent = userAgent;
        this.elapsedTime = elapsedTime;
        this.status = status;
        this.principal = principal;
        this.authScheme = authScheme;
        this.errorMessage = errorMessage;
    }

    @Serialize
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getIdentifier() {
        return this.id.toString();
    }

    public String getName() {
        return this.uri;
    }

    @Serialize
    @Displayable(name="Timestamp", width=5)
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Serialize
    @Displayable(name="Method", width=5)
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Serialize
    @Displayable(name="URI", width=5)
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Serialize
    @Displayable(name="Remote Address", width=5)
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Serialize
    @Displayable(name="User-Agent", width=5)
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Serialize
    @Displayable(name="Elapsed Time", width=5)
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    @Serialize
    @Displayable(name="HTTP Status", width=5)
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Serialize
    @Displayable(name="Principal", width=5)
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @Serialize
    @Displayable(name="Auth Scheme", width=5)
    public String getAuthScheme() {
        return this.authScheme;
    }

    public void setAuthScheme(String authScheme) {
        this.authScheme = authScheme;
    }

    @Serialize
    @Displayable(name="Error Message", width=5)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

