/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Editable;
import at.mrdevelopment.esl.persistence.annotation.Lookup;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.esl.persistence.record.LabelIdRecord;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.persistence.record.Template;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Matching;
import at.mrdevelopment.toolkit.authentication.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Transformer;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="ESL_MATCHING")
public class MatchingRecord
extends Record
implements LabelIdRecord {
    public static final String LABEL_ID = "LABEL_ID";
    public static final String ARTICLE_NUMBER = "ARTICLE_NUMBER";
    public static final String TEMPLATE = "TEMPLATE";
    private Long label;
    private String articleNumber;
    private String template;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.USER, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static List<Matching> toMatchingList(Collection<MatchingRecord> matchings) {
        return (List)CollectionUtils.collect(matchings, (Transformer)new Transformer<MatchingRecord, Matching>(){

            public Matching transform(MatchingRecord matchingRecord) {
                return matchingRecord.toMatching();
            }
        }, new ArrayList(matchings.size()));
    }

    public static List<MatchingRecord> fromMatchingList(Collection<Matching> matchings) {
        return (List)CollectionUtils.collect(matchings, (Transformer)new Transformer<Matching, MatchingRecord>(){

            public MatchingRecord transform(Matching matching) {
                return MatchingRecord.fromMatching(matching);
            }
        }, new ArrayList(matchings.size()));
    }

    public static MatchingRecord fromMatching(Matching matching) {
        return new MatchingRecord(matching.getLabelId().getId(), matching.getArticleNumbersString(), matching.getTemplate());
    }

    public MatchingRecord() {
    }

    public MatchingRecord(Long label, String articleNumber, String template) {
        this.label = label;
        this.articleNumber = articleNumber;
        this.template = template;
    }

    @Column(name="CREATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Serialize
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Column(name="LABEL_ID", nullable=false, unique=true)
    @Displayable(name="Label ID", width=3, order=1)
    @Editable(createOnly=true)
    @UserType(value=LabelId.class)
    @Lookup(lookupType=LabelInfo.class, lookupField="Label")
    @Serialize
    public Long getLabel() {
        return this.label;
    }

    public void setLabel(Long label) {
        this.label = label;
    }

    @Column(name="ARTICLE_NUMBER", nullable=false)
    @Index(name="IDX_ARTICLE_NUMBER")
    @Displayable(name="Article Number", width=4, order=2)
    @Editable
    @UserType(value=ArticleNumber.class)
    @Lookup(lookupType=Article.class, lookupField="ArticleNumber")
    @Serialize
    public String getArticleNumber() {
        return this.articleNumber;
    }

    public void setArticleNumber(String articleNumber) {
        this.articleNumber = articleNumber;
    }

    @Column(name="TEMPLATE", nullable=false)
    @Displayable(name="Template", width=6, order=3)
    @Editable
    @Lookup(lookupType=Template.class, lookupField="TemplateFilename")
    @Serialize
    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Transient
    public void updateFromMatching(MatchingRecord matching) {
        this.label = matching.getLabel();
        this.articleNumber = matching.getArticleNumber();
        this.template = matching.getTemplate();
    }

    @Transient
    public void updateFromMatching(Matching matching) {
        this.label = matching.getLabelId().getId();
        this.articleNumber = matching.getArticleNumbersString();
        this.template = matching.getTemplate();
    }

    @Transient
    public boolean isEmptyMatching() {
        return this.articleNumber == null && this.template == null;
    }

    @Override
    @Transient
    public LabelId getLabelId() {
        return new LabelId(this.label);
    }

    @Override
    @Transient
    @Serialize
    public String getLabelIdString() {
        return this.getLabelId().getLabelIdString();
    }

    @Transient
    public Matching toMatching() {
        Collection articleNumbers = ArticleNumber.fromMultiString((String)this.articleNumber);
        return new Matching(new LabelId(this.label), articleNumbers, this.template);
    }
}

